/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.store.access;

import com.gemstone.gnu.trove.THashMap;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.RegionAndKey;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.conn.GfxdHeapThresholdListener;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.DiskHashtable;
import com.pivotal.gemfirexd.internal.iapi.store.access.KeyHasher;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowSource;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.CloneableObject;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.PropertyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;

public class BackingStoreHashtable {
    private TransactionController tc;
    private THashMap hash_table;
    private int[] key_column_numbers;
    private boolean remove_duplicates;
    private boolean skipNullKeyColumns;
    private Properties auxillary_runtimestats;
    protected RowSource row_source;
    private long max_inmemory_rowcnt;
    private long inmemory_rowcnt;
    private long max_inmemory_size;
    private boolean keepAfterCommit;
    private static final int ARRAY_LIST_SIZE = ClassSize.estimateBaseFromCatalog(ArrayList.class);
    private DiskHashtable diskHashtable;
    private final GfxdHeapThresholdListener thresholdListener = Misc.getMemStore().thresholdListener();
    private final THashMap hash_table_for_RegionNameAndKey = new THashMap();

    private BackingStoreHashtable() {
    }

    public BackingStoreHashtable(TransactionController tc, RowSource row_source, int[] key_column_numbers, boolean remove_duplicates, long estimated_rowcnt, long max_inmemory_rowcnt, int initialCapacity, float loadFactor, boolean skipNullKeyColumns, boolean keepAfterCommit) throws StandardException {
        this(tc, row_source, key_column_numbers, remove_duplicates, estimated_rowcnt, max_inmemory_rowcnt, initialCapacity, loadFactor, skipNullKeyColumns, keepAfterCommit, true);
    }

    protected BackingStoreHashtable(TransactionController tc, RowSource row_source, int[] key_column_numbers, boolean remove_duplicates, long estimated_rowcnt, long max_inmemory_rowcnt, int initialCapacity, float loadFactor, boolean skipNullKeyColumns, boolean keepAfterCommit, boolean fillUpHashTable) throws StandardException {
        this.key_column_numbers = key_column_numbers;
        this.remove_duplicates = remove_duplicates;
        this.row_source = row_source;
        this.skipNullKeyColumns = skipNullKeyColumns;
        this.max_inmemory_rowcnt = max_inmemory_rowcnt;
        this.max_inmemory_size = max_inmemory_rowcnt > 0L ? Long.MAX_VALUE : Runtime.getRuntime().totalMemory() / 100L;
        this.tc = tc;
        this.keepAfterCommit = keepAfterCommit;
        if (initialCapacity != -1) {
            this.hash_table = loadFactor == -1.0f ? new THashMap(initialCapacity) : new THashMap(initialCapacity, loadFactor * 0.8f);
        } else {
            Object object = estimated_rowcnt <= 0L || row_source == null ? new THashMap() : (this.hash_table = estimated_rowcnt < this.max_inmemory_size ? new THashMap((int)estimated_rowcnt) : null);
        }
        if (row_source != null && fillUpHashTable) {
            Object[] row;
            boolean needsToClone = row_source.needsToClone();
            while ((row = this.getNextRowFromRowSource()) != null) {
                if (this.hash_table == null) {
                    double rowUsage = this.getEstimatedMemUsage((DataValueDescriptor[])row);
                    this.hash_table = new THashMap((int)((double)this.max_inmemory_size / rowUsage));
                }
                if (GemFireXDUtils.TraceOuterJoin || GemFireXDUtils.TraceNCJIter) {
                    SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("BackingStoreHashTable::BackingStoreHashtable calling add_row_to_hash_table for row = " + Arrays.toString(row) + ", needsToclone: " + needsToClone + " and rak: " + null));
                }
                this.add_row_to_hash_table((DataValueDescriptor[])row, needsToClone, null);
            }
        }
        if (this.hash_table == null) {
            this.hash_table = new THashMap();
        }
    }

    protected DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        DataValueDescriptor[] row;
        ExecRow r = this.row_source.getNextRowFromRowSource();
        DataValueDescriptor[] dataValueDescriptorArray = row = r != null ? r.getRowArray() : null;
        if (this.skipNullKeyColumns) {
            while (row != null) {
                int index;
                for (index = 0; index < this.key_column_numbers.length && !row[this.key_column_numbers[index]].isNull(); ++index) {
                }
                if (index == this.key_column_numbers.length) {
                    return row;
                }
                r = this.row_source.getNextRowFromRowSource();
                row = r != null ? r.getRowArray() : null;
            }
        }
        return row;
    }

    private static DataValueDescriptor[] cloneRow(DataValueDescriptor[] old_row) throws StandardException {
        DataValueDescriptor[] new_row = new DataValueDescriptor[old_row.length];
        for (int i = 0; i < old_row.length; ++i) {
            if (old_row[i] == null) continue;
            new_row[i] = old_row[i].getClone();
        }
        return new_row;
    }

    static DataValueDescriptor[] shallowCloneRow(DataValueDescriptor[] old_row) throws StandardException {
        DataValueDescriptor[] new_row = new DataValueDescriptor[old_row.length];
        for (int i = 0; i < old_row.length; ++i) {
            if (old_row[i] == null) continue;
            new_row[i] = (DataValueDescriptor)((CloneableObject)((Object)old_row[i])).cloneObject();
        }
        return new_row;
    }

    protected void add_row_to_hash_table(DataValueDescriptor[] row, boolean needsToClone, RegionAndKey rak) throws StandardException {
        if (GemFireXDUtils.TraceOuterJoin || GemFireXDUtils.TraceNCJIter) {
            SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("BackingStoreHashTable::add_row_to_hash_table called for row: " + Arrays.toString(row) + " and rak: " + rak));
        }
        if (this.spillToDisk(row)) {
            return;
        }
        if (needsToClone) {
            row = BackingStoreHashtable.cloneRow(row);
        }
        Object key = KeyHasher.buildHashKey(row, this.key_column_numbers);
        Object duplicate_value = null;
        duplicate_value = this.hash_table.put(key, (Object)row);
        if (duplicate_value == null) {
            if (rak != null) {
                if (GemFireXDUtils.TraceOuterJoin || GemFireXDUtils.TraceNCJIter) {
                    SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("BackingStoreHashTable::add_row_to_hash_table putting rak: " + rak + " against key: " + key + " for row: " + Arrays.toString(row)));
                }
                this.hash_table_for_RegionNameAndKey.put(key, (Object)rak);
            }
            this.doSpaceAccounting(row, false);
        } else if (!this.remove_duplicates) {
            List<DataValueDescriptor[]> row_vec;
            ArrayList<RegionAndKey> rak_vec = null;
            if (duplicate_value instanceof List) {
                this.doSpaceAccounting(row, false);
                row_vec = (List)duplicate_value;
                if (rak != null) {
                    rak_vec = (ArrayList<RegionAndKey>)this.hash_table_for_RegionNameAndKey.get(key);
                }
            } else {
                row_vec = new ArrayList<Object>(2);
                row_vec.add((DataValueDescriptor[])duplicate_value);
                if (rak != null) {
                    rak_vec = new ArrayList<RegionAndKey>(2);
                    if (GemFireXDUtils.TraceOuterJoin || GemFireXDUtils.TraceNCJIter) {
                        SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("BackingStoreHashTable::add_row_to_hash_table created list of size 2 and added rak: " + rak + " against key: " + key));
                    }
                    rak_vec.add((RegionAndKey)this.hash_table_for_RegionNameAndKey.get(key));
                }
                this.doSpaceAccounting(row, true);
            }
            row_vec.add(row);
            if (rak_vec != null) {
                rak_vec.add(rak);
            }
            this.hash_table.put(key, row_vec);
            if (rak != null && rak_vec != null) {
                this.hash_table_for_RegionNameAndKey.put(key, rak_vec);
            }
        }
        row = null;
    }

    private void doSpaceAccounting(DataValueDescriptor[] row, boolean firstDuplicate) {
        ++this.inmemory_rowcnt;
        if (this.max_inmemory_rowcnt <= 0L) {
            this.max_inmemory_size -= this.getEstimatedMemUsage(row);
            if (firstDuplicate) {
                this.max_inmemory_size -= (long)ARRAY_LIST_SIZE;
            }
        }
    }

    private boolean spillToDisk(DataValueDescriptor[] row) throws StandardException {
        if (!this.thresholdListener.isCritical()) {
            return false;
        }
        throw StandardException.newException("0A000.S.13");
    }

    private long getEstimatedMemUsage(DataValueDescriptor[] row) {
        long rowMem = 0L;
        for (int i = 0; i < row.length; ++i) {
            rowMem += (long)row[i].estimateMemoryUsage();
            rowMem += (long)ClassSize.refSize;
        }
        return rowMem += (long)ClassSize.refSize;
    }

    public void close() throws StandardException {
        this.hash_table = null;
        if (this.diskHashtable != null) {
            this.diskHashtable.close();
            this.diskHashtable = null;
        }
    }

    public Enumeration elements() throws StandardException {
        if (this.diskHashtable == null) {
            return Collections.enumeration(this.hash_table.values());
        }
        return new BackingStoreHashtableEnumeration();
    }

    public Iterator valuesIterator() throws StandardException {
        return new BackingStoreHashtableValues();
    }

    public Object get(Object key) throws StandardException {
        Object obj = this.hash_table.get(key);
        if (this.diskHashtable == null || obj != null) {
            return obj;
        }
        return this.diskHashtable.get(key);
    }

    public void getAllRuntimeStats(Properties prop) throws StandardException {
        if (this.auxillary_runtimestats != null) {
            PropertyUtil.copyProperties(this.auxillary_runtimestats, prop);
        }
    }

    public Object remove(Object key) throws StandardException {
        Object obj = this.hash_table.remove(key);
        if (obj != null || this.diskHashtable == null) {
            return obj;
        }
        return this.diskHashtable.remove(key);
    }

    public void setAuxillaryRuntimeStats(Properties prop) throws StandardException {
        this.auxillary_runtimestats = prop;
    }

    public boolean putRow(boolean needsToClone, DataValueDescriptor[] row, RegionAndKey rak) throws StandardException {
        if (this.skipNullKeyColumns) {
            for (int index = 0; index < this.key_column_numbers.length; ++index) {
                if (!row[this.key_column_numbers[index]].isNull()) continue;
                return false;
            }
        }
        Object key = KeyHasher.buildHashKey(row, this.key_column_numbers);
        if (this.remove_duplicates && this.get(key) != null) {
            return false;
        }
        if (GemFireXDUtils.TraceOuterJoin || GemFireXDUtils.TraceNCJIter) {
            SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("BackingStoreHashTable::putRow calling add_row_to_hash_table for row = " + Arrays.toString(row) + ", needsToclone: " + needsToClone + " and rak: " + rak));
        }
        this.add_row_to_hash_table(row, needsToClone, rak);
        return true;
    }

    public int size() throws StandardException {
        if (this.diskHashtable == null) {
            return this.hash_table.size();
        }
        return this.hash_table.size() + this.diskHashtable.size();
    }

    public Object getFromRegionAndKeyHash(Object key) throws StandardException {
        return this.hash_table_for_RegionNameAndKey.get(key);
    }

    protected void assertHashTableNotNull() {
        SanityManager.ASSERT((this.hash_table != null ? 1 : 0) != 0);
    }

    public boolean moreRowsExpected() {
        return false;
    }

    public boolean fillUpHashTable() throws StandardException {
        SanityManager.THROWASSERT((String)"Should be called for derived class");
        return false;
    }

    public void purgeHashTable() {
        this.assertHashTableNotNull();
        this.hash_table.clear();
    }

    public class BackingStoreHashtableValues
    implements Iterator {
        private Iterator memoryIterator;

        BackingStoreHashtableValues() {
            this.memoryIterator = BackingStoreHashtable.this.hash_table.values().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.memoryIterator != null) {
                if (this.memoryIterator.hasNext()) {
                    return true;
                }
                this.memoryIterator = null;
            }
            return false;
        }

        public Object next() {
            if (this.memoryIterator != null) {
                if (this.memoryIterator.hasNext()) {
                    return this.memoryIterator.next();
                }
                this.memoryIterator = null;
            }
            return null;
        }

        @Override
        public void remove() {
        }
    }

    private class BackingStoreHashtableEnumeration
    implements Enumeration {
        private Iterator memoryIterator;
        private Enumeration diskEnumeration;

        BackingStoreHashtableEnumeration() {
            this.memoryIterator = BackingStoreHashtable.this.hash_table.values().iterator();
            if (BackingStoreHashtable.this.diskHashtable != null) {
                try {
                    this.diskEnumeration = BackingStoreHashtable.this.diskHashtable.elements();
                }
                catch (StandardException se) {
                    this.diskEnumeration = null;
                }
            }
        }

        @Override
        public boolean hasMoreElements() {
            if (this.memoryIterator != null) {
                if (this.memoryIterator.hasNext()) {
                    return true;
                }
                this.memoryIterator = null;
            }
            if (this.diskEnumeration == null) {
                return false;
            }
            return this.diskEnumeration.hasMoreElements();
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.memoryIterator != null) {
                if (this.memoryIterator.hasNext()) {
                    return this.memoryIterator.next();
                }
                this.memoryIterator = null;
            }
            return this.diskEnumeration.nextElement();
        }
    }
}

