/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.services.io;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.internal.iapi.services.io.Formatable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.util.ReuseFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class FormatableBitSet
implements Formatable,
Cloneable,
DataSerializableFixedID {
    private byte[] value;
    private byte bitsInLastByte;
    private transient int lengthAsBits;

    private final void checkPosition(int p) {
        if (p < 0 || this.lengthAsBits <= p) {
            throw new IllegalArgumentException("Bit position " + p + " is outside the legal range");
        }
    }

    public static int udiv8(int i) {
        return i >> 3;
    }

    public static byte umod8(int i) {
        return (byte)(i & 7);
    }

    private static int umul8(int i) {
        return i << 3;
    }

    public FormatableBitSet() {
        this.value = ReuseFactory.getZeroLenByteArray();
    }

    public FormatableBitSet(int numBits) {
        if (numBits < 0) {
            throw new IllegalArgumentException("Bit set size " + numBits + " is not allowed");
        }
        this.initializeBits(numBits);
    }

    private void initializeBits(int numBits) {
        int numBytes = FormatableBitSet.numBytesFromBits(numBits);
        this.value = new byte[numBytes];
        this.bitsInLastByte = FormatableBitSet.numBitsInLastByte(numBits);
        this.lengthAsBits = numBits;
    }

    public FormatableBitSet(byte[] newValue) {
        this.value = newValue;
        this.bitsInLastByte = (byte)8;
        this.lengthAsBits = this.calculateLength(newValue.length);
    }

    public FormatableBitSet(FormatableBitSet original) {
        SanityManager.ASSERT((original != null ? 1 : 0) != 0, (String)"cannot make copy from a null FormatableBitSet");
        this.bitsInLastByte = original.bitsInLastByte;
        this.lengthAsBits = original.lengthAsBits;
        int lenInBytes = FormatableBitSet.numBytesFromBits(original.lengthAsBits);
        this.value = new byte[lenInBytes];
        if (lenInBytes > 0) {
            System.arraycopy(original.value, 0, this.value, 0, lenInBytes);
        }
    }

    public final FormatableBitSet clone() {
        return new FormatableBitSet(this);
    }

    public boolean invariantHolds() {
        int arrayLengthAsBits = this.value.length * 8;
        if (this.lengthAsBits > arrayLengthAsBits) {
            return false;
        }
        int partialByteIndex = (this.lengthAsBits - 1) / 8;
        if (this.bitsInLastByte != this.lengthAsBits - 8 * partialByteIndex) {
            return false;
        }
        if (this.value.length == 0) {
            return true;
        }
        byte partialByte = this.value[partialByteIndex];
        partialByte = (byte)(partialByte << this.bitsInLastByte);
        for (int i = partialByteIndex + 1; i < this.value.length; ++i) {
            partialByte = (byte)(partialByte | this.value[i]);
        }
        return partialByte == 0;
    }

    public int getLengthInBytes() {
        return FormatableBitSet.numBytesFromBits(this.lengthAsBits);
    }

    public int getLength() {
        return this.lengthAsBits;
    }

    private int calculateLength(int realByteLength) {
        if (realByteLength == 0) {
            return 0;
        }
        return (realByteLength - 1) * 8 + this.bitsInLastByte;
    }

    public int size() {
        return this.getLength();
    }

    public byte[] getByteArray() {
        int realByteLength = this.getLengthInBytes();
        if (this.value.length != realByteLength) {
            byte[] data = new byte[realByteLength];
            System.arraycopy(this.value, 0, data, 0, realByteLength);
            this.value = data;
        }
        return this.value;
    }

    public void grow(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Bit set cannot grow from " + this.lengthAsBits + " to " + n + " bits");
        }
        if (n <= this.lengthAsBits) {
            return;
        }
        int newNumBytes = FormatableBitSet.numBytesFromBits(n);
        if (newNumBytes > this.value.length) {
            byte[] newValue = new byte[newNumBytes];
            int oldNumBytes = this.getLengthInBytes();
            System.arraycopy(this.value, 0, newValue, 0, oldNumBytes);
            this.value = newValue;
        }
        this.bitsInLastByte = FormatableBitSet.numBitsInLastByte(n);
        this.lengthAsBits = n;
    }

    public void shrink(int n) {
        if (n < 0 || n > this.lengthAsBits) {
            throw new IllegalArgumentException("Bit set cannot shrink from " + this.lengthAsBits + " to " + n + " bits");
        }
        int firstUnusedByte = FormatableBitSet.numBytesFromBits(n);
        this.bitsInLastByte = FormatableBitSet.numBitsInLastByte(n);
        this.lengthAsBits = n;
        for (int i = firstUnusedByte; i < this.value.length; ++i) {
            this.value[i] = 0;
        }
        if (firstUnusedByte > 0) {
            int n2 = firstUnusedByte - 1;
            this.value[n2] = (byte)(this.value[n2] & 65280 >> this.bitsInLastByte);
        }
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof FormatableBitSet)) {
            return false;
        }
        if (this.getLength() != ((FormatableBitSet)other).getLength()) {
            return false;
        }
        return this.compare((FormatableBitSet)other) == 0;
    }

    public int compare(FormatableBitSet other) {
        int thisCount;
        byte[] otherb = other.value;
        int otherLen = other.getLengthInBytes();
        int thisLen = this.getLengthInBytes();
        int otherCount = 0;
        for (thisCount = 0; otherCount < otherLen && thisCount < thisLen && otherb[otherCount] == this.value[thisCount]; ++otherCount, ++thisCount) {
        }
        if (otherCount == otherLen && thisCount == thisLen) {
            if (this.getLength() == other.getLength()) {
                return 0;
            }
            return other.getLength() < this.getLength() ? 1 : -1;
        }
        if (otherCount == otherLen) {
            return 1;
        }
        if (thisCount == thisLen) {
            return -1;
        }
        int otherInt = otherb[otherCount];
        int thisInt = this.value[thisCount];
        return (thisInt &= 0xFF) > (otherInt &= 0xFF) ? 1 : -1;
    }

    public int hashCode() {
        int code = 0;
        int shift = 0;
        int byteLength = this.getLengthInBytes();
        for (int i = 0; i < byteLength; ++i) {
            code ^= (this.value[i] & 0xFF) << shift;
            if (32 > (shift += 8)) continue;
            shift = 0;
        }
        return code;
    }

    public final boolean isSet(int position) {
        this.checkPosition(position);
        int byteIndex = FormatableBitSet.udiv8(position);
        byte bitIndex = FormatableBitSet.umod8(position);
        return (this.value[byteIndex] & 128 >> bitIndex) != 0;
    }

    public final boolean get(int position) {
        return this.isSet(position);
    }

    public void set(int position) {
        this.checkPosition(position);
        int byteIndex = FormatableBitSet.udiv8(position);
        byte bitIndex = FormatableBitSet.umod8(position);
        int n = byteIndex;
        this.value[n] = (byte)(this.value[n] | 128 >> bitIndex);
    }

    public void clear(int position) {
        this.checkPosition(position);
        int byteIndex = FormatableBitSet.udiv8(position);
        byte bitIndex = FormatableBitSet.umod8(position);
        int n = byteIndex;
        this.value[n] = (byte)(this.value[n] & ~(128 >> bitIndex));
    }

    public void clear() {
        int byteLength = this.getLengthInBytes();
        for (int ix = 0; ix < byteLength; ++ix) {
            this.value[ix] = 0;
        }
    }

    public static int numBytesFromBits(int bits) {
        return bits + 7 >> 3;
    }

    private static byte numBitsInLastByte(int bits) {
        if (bits == 0) {
            return 0;
        }
        byte lastbits = FormatableBitSet.umod8(bits);
        return lastbits != 0 ? lastbits : (byte)8;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.getLength() * 8 * 3);
        str.append('(');
        boolean first = true;
        for (int inPosition = 0; inPosition < this.getLength(); ++inPosition) {
            if (!this.isSet(inPosition)) continue;
            if (!first) {
                str.append(", ");
            }
            first = false;
            str.append(inPosition);
        }
        str.append(')');
        return new String(str);
    }

    public static int maxBitsForSpace(int numBytes) {
        return (numBytes - 4) * 8;
    }

    private static byte firstSet(byte v) {
        if ((v & 0x80) != 0) {
            return 0;
        }
        if ((v & 0x40) != 0) {
            return 1;
        }
        if ((v & 0x20) != 0) {
            return 2;
        }
        if ((v & 0x10) != 0) {
            return 3;
        }
        if ((v & 8) != 0) {
            return 4;
        }
        if ((v & 4) != 0) {
            return 5;
        }
        if ((v & 2) != 0) {
            return 6;
        }
        return 7;
    }

    public int anySetBit() {
        int numbytes = this.getLengthInBytes();
        for (int i = 0; i < numbytes; ++i) {
            byte v = this.value[i];
            if (v == 0) continue;
            return FormatableBitSet.umul8(i) + FormatableBitSet.firstSet(v);
        }
        return -1;
    }

    public int anySetBit(int beyondBit) {
        if (++beyondBit >= this.lengthAsBits) {
            return -1;
        }
        int i = FormatableBitSet.udiv8(beyondBit);
        byte v = (byte)(this.value[i] << FormatableBitSet.umod8(beyondBit));
        if (v != 0) {
            return beyondBit + FormatableBitSet.firstSet(v);
        }
        int numbytes = this.getLengthInBytes();
        ++i;
        while (i < numbytes) {
            v = this.value[i];
            if (v != 0) {
                return FormatableBitSet.umul8(i) + FormatableBitSet.firstSet(v);
            }
            ++i;
        }
        return -1;
    }

    public void or(FormatableBitSet otherBit) {
        if (otherBit == null) {
            return;
        }
        int otherLength = otherBit.getLength();
        if (otherLength > this.getLength()) {
            this.grow(otherLength);
        }
        int obByteLen = otherBit.getLengthInBytes();
        for (int i = 0; i < obByteLen; ++i) {
            int n = i;
            this.value[n] = (byte)(this.value[n] | otherBit.value[i]);
        }
    }

    public void and(FormatableBitSet otherBit) {
        int i;
        if (otherBit == null) {
            this.clear();
            return;
        }
        int otherLength = otherBit.getLength();
        if (otherLength > this.getLength()) {
            this.grow(otherLength);
        }
        int byteLength = otherBit.getLengthInBytes();
        for (i = 0; i < byteLength; ++i) {
            int n = i;
            this.value[n] = (byte)(this.value[n] & otherBit.value[i]);
        }
        byteLength = this.getLengthInBytes();
        while (i < byteLength) {
            this.value[i] = 0;
            ++i;
        }
    }

    public void xor(FormatableBitSet otherBit) {
        if (otherBit == null) {
            return;
        }
        int otherLength = otherBit.getLength();
        if (otherLength > this.getLength()) {
            this.grow(otherLength);
        }
        int obByteLen = otherBit.getLengthInBytes();
        for (int i = 0; i < obByteLen; ++i) {
            int n = i;
            this.value[n] = (byte)(this.value[n] ^ otherBit.value[i]);
        }
    }

    public int getNumBitsSet() {
        int bitsSet = 0;
        int numbytes = this.getLengthInBytes();
        for (int i = 0; i < numbytes; ++i) {
            byte v = this.value[i];
            v = (byte)(v - (v >> 1 & 0x55));
            v = (byte)((v & 0x33) + (v >> 2 & 0x33));
            v = (byte)((v & 7) + (v >> 4));
            bitsSet += v;
        }
        return bitsSet;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT((this.value != null ? 1 : 0) != 0);
        out.writeInt(this.getLength());
        int byteLen = this.getLengthInBytes();
        if (byteLen > 0) {
            out.write(this.value, 0, byteLen);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int lenInBits = in.readInt();
        int lenInBytes = FormatableBitSet.numBytesFromBits(lenInBits);
        this.value = new byte[lenInBytes];
        in.readFully(this.value);
        this.bitsInLastByte = FormatableBitSet.numBitsInLastByte(lenInBits);
        this.lengthAsBits = lenInBits;
    }

    @Override
    public int getTypeFormatId() {
        return 269;
    }

    public int lastSetBit() {
        int numBytes = this.getLengthInBytes();
        for (int i = numBytes - 1; i >= 0; --i) {
            byte v = this.value[i];
            if (v == 0) continue;
            return FormatableBitSet.umul8(i) + FormatableBitSet.lastSet(v);
        }
        return -1;
    }

    private static byte lastSet(byte v) {
        if ((v & 1) != 0) {
            return 7;
        }
        if ((v & 2) != 0) {
            return 6;
        }
        if ((v & 4) != 0) {
            return 5;
        }
        if ((v & 8) != 0) {
            return 4;
        }
        if ((v & 0x10) != 0) {
            return 3;
        }
        if ((v & 0x20) != 0) {
            return 2;
        }
        if ((v & 0x40) != 0) {
            return 1;
        }
        return 0;
    }

    public void toData(DataOutput out) throws IOException {
        InternalDataSerializer.writeArrayLength((int)this.getLength(), (DataOutput)out);
        int byteLen = this.getLengthInBytes();
        if (byteLen > 0) {
            DataSerializer.writeByteArray((byte[])this.value, (DataOutput)out);
        }
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        int lenInBits = InternalDataSerializer.readArrayLength((DataInput)in);
        int lenInBytes = FormatableBitSet.numBytesFromBits(lenInBits);
        if (lenInBytes > 0) {
            this.value = DataSerializer.readByteArray((DataInput)in);
        }
        this.bitsInLastByte = FormatableBitSet.numBitsInLastByte(lenInBits);
        this.lengthAsBits = lenInBits;
    }

    public int getDSFID() {
        return -16;
    }

    public Version[] getSerializationVersions() {
        return null;
    }
}

