/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.services.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class FormatIdUtil {
    private static final int BYTE_MASK = 255;
    private static final int NIBBLE_MASK = 15;
    private static final int NIBBLE_SHIFT = 4;
    private static final int HEX_RADIX = 16;

    private FormatIdUtil() {
    }

    public static int getFormatIdByteLength(int formatId) {
        return 2;
    }

    public static void writeFormatIdInteger(DataOutput out, int formatId) throws IOException {
        out.writeShort(formatId);
    }

    public static int readFormatIdInteger(DataInput in) throws IOException {
        return in.readUnsignedShort();
    }

    public static int readFormatIdInteger(byte[] data) {
        byte a = data[0];
        byte b = data[1];
        return (a & 0xFF) << 8 | b & 0xFF;
    }

    public static String formatIdToString(int fmtId) {
        return Integer.toString(fmtId);
    }

    public static String toString(byte[] written, int count) {
        char[] chars = new char[count * 2];
        int charIdx = 0;
        for (int i = 0; i < count; ++i) {
            int current = written[i] & 0xFF;
            int lowNibble = current & 0xF;
            int highNibble = current >>> 4;
            chars[charIdx++] = FormatIdUtil.encodeNibble(lowNibble);
            chars[charIdx++] = FormatIdUtil.encodeNibble(highNibble);
        }
        return new String(chars);
    }

    public static byte[] fromString(String objString) {
        char[] chars = objString.toCharArray();
        int count = chars.length;
        byte[] bytes = new byte[count / 2];
        int byteIdx = 0;
        for (int i = 0; i < count; i += 2) {
            int lowNibble = FormatIdUtil.decodeNibble(chars[i]);
            int highNibble = FormatIdUtil.decodeNibble(chars[i + 1]);
            bytes[byteIdx++] = (byte)(highNibble << 4 | lowNibble);
        }
        return bytes;
    }

    private static char encodeNibble(int nibble) {
        return Character.forDigit(nibble, 16);
    }

    private static int decodeNibble(char c) {
        return Character.digit(c, 16);
    }
}

