/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.services.io;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class ArrayUtil {
    public static void writeArrayLength(ObjectOutput out, Object[] a) throws IOException {
        out.writeInt(a.length);
    }

    public static void writeArrayItems(ObjectOutput out, Object[] a) throws IOException {
        if (a == null) {
            return;
        }
        for (int ix = 0; ix < a.length; ++ix) {
            out.writeObject(a[ix]);
        }
    }

    public static void writeArray(ObjectOutput out, Object[] a) throws IOException {
        if (a == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(a.length);
        for (int ix = 0; ix < a.length; ++ix) {
            out.writeObject(a[ix]);
        }
    }

    public static void readArrayItems(ObjectInput in, Object[] a) throws IOException, ClassNotFoundException {
        for (int ix = 0; ix < a.length; ++ix) {
            a[ix] = in.readObject();
        }
    }

    public static int readArrayLength(ObjectInput in) throws IOException {
        return in.readInt();
    }

    public static Object[] readObjectArray(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        if (size == 0) {
            return null;
        }
        Object[] result = new Object[size];
        ArrayUtil.readArrayItems(in, result);
        return result;
    }

    public static void writeIntArray(ObjectOutput out, int[] a) throws IOException {
        if (a == null) {
            out.writeInt(0);
        } else {
            out.writeInt(a.length);
            for (int i = 0; i < a.length; ++i) {
                out.writeInt(a[i]);
            }
        }
    }

    public static int[] readIntArray(ObjectInput in) throws IOException {
        int length = in.readInt();
        if (length == 0) {
            return null;
        }
        int[] a = new int[length];
        for (int i = 0; i < length; ++i) {
            a[i] = in.readInt();
        }
        return a;
    }

    public static void writeInts(ObjectOutput out, int[][] val) throws IOException {
        if (val == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            int count = val.length;
            out.writeInt(count);
            for (int i = 0; i < count; ++i) {
                ArrayUtil.writeIntArray(out, val[i]);
            }
        }
    }

    public static int[][] readInts(ObjectInput in) throws IOException, ClassNotFoundException {
        Object retVal = null;
        if (in.readBoolean()) {
            int count = in.readInt();
            retVal = new int[count][];
            for (int i = 0; i < count; ++i) {
                retVal[i] = ArrayUtil.readIntArray(in);
            }
        }
        return retVal;
    }

    public static String toString(int[] value) {
        String ret_val;
        if (value == null || value.length == 0) {
            ret_val = "null";
        } else {
            ret_val = "";
            for (int i = 0; i < value.length; ++i) {
                ret_val = ret_val + "[" + value[i] + "],";
            }
        }
        return ret_val;
    }

    public static void writeLongArray(ObjectOutput out, long[] a) throws IOException {
        if (a == null) {
            out.writeInt(0);
        } else {
            out.writeInt(a.length);
            for (int i = 0; i < a.length; ++i) {
                out.writeLong(a[i]);
            }
        }
    }

    public static long[] readLongArray(ObjectInput in) throws IOException {
        int length = in.readInt();
        long[] a = new long[length];
        for (int i = 0; i < length; ++i) {
            a[i] = in.readLong();
        }
        return a;
    }

    public static String[] readStringArray(ObjectInput in) throws IOException, ClassNotFoundException {
        Object[] objArray = ArrayUtil.readObjectArray(in);
        int size = 0;
        if (objArray == null) {
            return null;
        }
        size = objArray.length;
        String[] stringArray = new String[size];
        for (int i = 0; i < size; ++i) {
            stringArray[i] = (String)objArray[i];
        }
        return stringArray;
    }

    public static void writeBooleanArray(ObjectOutput out, boolean[] a) throws IOException {
        if (a == null) {
            out.writeInt(0);
        } else {
            out.writeInt(a.length);
            for (int i = 0; i < a.length; ++i) {
                out.writeBoolean(a[i]);
            }
        }
    }

    public static boolean[] readBooleanArray(ObjectInput in) throws IOException {
        int length = in.readInt();
        boolean[] a = new boolean[length];
        for (int i = 0; i < length; ++i) {
            a[i] = in.readBoolean();
        }
        return a;
    }
}

