/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.services.info;

import com.pivotal.gemfirexd.internal.iapi.services.info.ProductVersionHolder;
import com.pivotal.gemfirexd.internal.mbeans.VersionMBean;
import com.pivotal.gemfirexd.internal.security.SystemPermission;
import java.security.AccessControlException;
import java.security.AccessController;

public class Version
implements VersionMBean {
    private final ProductVersionHolder versionInfo;
    private final String permissionName;

    public Version(ProductVersionHolder pvh, String permissionName) {
        this.versionInfo = pvh;
        this.permissionName = permissionName;
    }

    private void checkMonitor() {
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new SystemPermission(this.permissionName, "monitor"));
            }
        }
        catch (AccessControlException e) {
            throw new SecurityException(e.getMessage());
        }
    }

    @Override
    public String getProductName() {
        this.checkMonitor();
        return this.versionInfo.getProductName();
    }

    @Override
    public String getProductTechnologyName() {
        this.checkMonitor();
        return this.versionInfo.getProductTechnologyName();
    }

    @Override
    public String getProductVendorName() {
        this.checkMonitor();
        return this.versionInfo.getProductVendorName();
    }

    @Override
    public String getVersionString() {
        this.checkMonitor();
        return this.versionInfo.getVersionBuildString(true);
    }

    @Override
    public int getMajorVersion() {
        this.checkMonitor();
        return this.versionInfo.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        this.checkMonitor();
        return this.versionInfo.getMinorVersion();
    }

    @Override
    public int getMaintenanceVersion() {
        this.checkMonitor();
        return this.versionInfo.getMaintVersion();
    }

    @Override
    public String getBuildNumber() {
        this.checkMonitor();
        return this.versionInfo.getBuildNumber();
    }

    @Override
    public boolean isBeta() {
        this.checkMonitor();
        return this.versionInfo.isBeta();
    }

    @Override
    public boolean isAlpha() {
        this.checkMonitor();
        return this.versionInfo.isAlpha();
    }
}

