/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.services.context;

import com.pivotal.gemfirexd.internal.iapi.error.ShutdownException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextImpl;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;

final class SystemContext
extends ContextImpl {
    SystemContext(ContextManager cm) {
        super(cm, "SystemContext");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupOnError(Throwable t) {
        boolean doShutdown = false;
        if (t instanceof StandardException) {
            StandardException se = (StandardException)t;
            int severity = se.getSeverity();
            if (severity < 40000) {
                return;
            }
            this.popMe();
            if (severity >= 50000) {
                doShutdown = true;
            }
        } else if (t instanceof ShutdownException || t instanceof ThreadDeath) {
            // empty if block
        }
        if (!doShutdown) {
            this.getContextManager().owningCsf.removeContext(this.getContextManager());
            return;
        }
        try {
            System.err.println("Shutting down due to severe error.");
            Monitor.getStream().printlnWithHeader("Shutting down due to severe error." + t.getMessage());
        }
        finally {
            Monitor.getMonitor().shutdown();
        }
    }
}

