/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.services.classfile;

import com.pivotal.gemfirexd.internal.iapi.services.classfile.ClassFormatOutput;
import com.pivotal.gemfirexd.internal.iapi.services.classfile.ClassMember;
import com.pivotal.gemfirexd.internal.iapi.services.classfile.MemberTableHash;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

class MemberTable {
    protected Vector entries;
    private Hashtable hashtable;
    private MemberTableHash mutableMTH = null;

    public MemberTable(int count) {
        this.entries = new Vector(count);
        this.hashtable = new Hashtable(count > 50 ? count : 50);
        this.mutableMTH = new MemberTableHash(null, null);
    }

    void addEntry(ClassMember item) {
        MemberTableHash mth = new MemberTableHash(item.getName(), item.getDescriptor(), this.entries.size());
        this.entries.addElement(item);
        this.hashtable.put(mth, mth);
    }

    ClassMember find(String name, String descriptor) {
        this.mutableMTH.name = name;
        this.mutableMTH.descriptor = descriptor;
        this.mutableMTH.setHashCode();
        MemberTableHash mth = (MemberTableHash)this.hashtable.get(this.mutableMTH);
        if (mth == null) {
            return null;
        }
        return (ClassMember)this.entries.elementAt(mth.index);
    }

    void put(ClassFormatOutput out) throws IOException {
        Vector lentries = this.entries;
        int count = lentries.size();
        for (int i = 0; i < count; ++i) {
            ((ClassMember)lentries.elementAt(i)).put(out);
        }
    }

    int size() {
        return this.entries.size();
    }

    int classFileSize() {
        int size = 0;
        Vector lentries = this.entries;
        int count = lentries.size();
        for (int i = 0; i < count; ++i) {
            size += ((ClassMember)lentries.elementAt(i)).classFileSize();
        }
        return size;
    }
}

