/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.db;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.store.CompositeRegionKey;
import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.ConnectionUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexRowGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.GenericScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ConsistencyChecker {
    private ConsistencyChecker() {
    }

    public static boolean checkTable(String schemaName, String tableName) throws SQLException {
        long baseRowCount = -1L;
        long basePrimaryBucketsRowCount = 0L;
        long baseRedundantBucketsRowCount = 0L;
        RowLocation rl = null;
        Object scanRL = null;
        GenericScanController scan = null;
        int baseColumns = 0;
        long indexRowsForLocalPrimaryBuckets = 0L;
        long indexRowsForLocalRedundantBuckets = 0L;
        ConglomerateController baseCC = null;
        ConglomerateController indexCC = null;
        LocalRegion region = (LocalRegion)Misc.getRegionForTable(schemaName + "." + tableName, true);
        Set localPrimaryBucketSet = null;
        if (region.getDataPolicy().withPartitioning()) {
            localPrimaryBucketSet = ((PartitionedRegion)region).getDataStore().getAllLocalPrimaryBucketIds();
        }
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        TransactionController tc = lcc.getTransactionExecute();
        try {
            ConstraintDescriptor constraintDesc;
            DataDictionary dd = lcc.getDataDictionary();
            DataValueFactory dvf = lcc.getDataValueFactory();
            ExecutionFactory ef = lcc.getLanguageConnectionFactory().getExecutionFactory();
            SchemaDescriptor sd = dd.getSchemaDescriptor(schemaName, tc, true);
            TableDescriptor td = dd.getTableDescriptor(tableName, sd, tc);
            if (td == null) {
                throw StandardException.newException("42X05", schemaName + "." + tableName);
            }
            if (td.getTableType() == 2) {
                boolean bl = true;
                return bl;
            }
            baseCC = tc.openConglomerate(td.getHeapConglomerateId(), false, 0, 7, 5);
            baseCC.checkConsistency();
            ConglomerateDescriptor heapCD = td.getConglomerateDescriptor(td.getHeapConglomerateId());
            ExecRow baseRow = ef.getValueRow(td.getNumberOfColumns());
            ColumnDescriptorList cdl = td.getColumnDescriptorList();
            int cdlSize = cdl.size();
            for (int index = 0; index < cdlSize; ++index) {
                ColumnDescriptor cd = cdl.elementAt(index);
                baseRow.setColumn(cd.getPosition(), cd.getType().getNull());
            }
            ConglomerateDescriptor[] cds = td.getConglomerateDescriptors();
            for (int index = 0; index < cds.length; ++index) {
                ConglomerateDescriptor indexCD = cds[index];
                String indexType = null;
                if (!indexCD.isIndex() || (indexType = indexCD.getIndexDescriptor().indexType()).equals("LOCALHASH1")) continue;
                indexCC = tc.openConglomerate(indexCD.getConglomerateNumber(), false, 0, 7, 5);
                indexCC.checkConsistency();
                indexCC.close();
                indexCC = null;
                if (indexCD.isConstraint() && (constraintDesc = dd.getConstraintDescriptor(td, indexCD.getUUID())) == null) {
                    throw StandardException.newException("42X94", (Object)"CONSTRAINT for INDEX", (Object)indexCD.getConglomerateName());
                }
                if (baseRowCount < 0L) {
                    scan = tc.openScan(heapCD.getConglomerateNumber(), false, 0, 7, 5, RowUtil.EMPTY_ROW_BITSET, null, 0, null, null, 0, null);
                    rl = scan.newRowLocationTemplate();
                    if (region.getDataPolicy().withPartitioning()) {
                        Map bucketSizes = ((PartitionedRegion)region).getDataStore().getSizeLocally();
                        baseRowCount = 0L;
                        basePrimaryBucketsRowCount = 0L;
                        baseRedundantBucketsRowCount = 0L;
                        Set primaryBuckets = ((PartitionedRegion)region).getDataStore().getAllLocalPrimaryBucketIds();
                        for (Map.Entry e : bucketSizes.entrySet()) {
                            baseRowCount += (long)((Integer)e.getValue()).intValue();
                            if (primaryBuckets.contains(e.getKey())) {
                                basePrimaryBucketsRowCount += (long)((Integer)e.getValue()).intValue();
                                continue;
                            }
                            baseRedundantBucketsRowCount += (long)((Integer)e.getValue()).intValue();
                        }
                    } else {
                        baseRowCount = region.size();
                    }
                    scan.close();
                    scan = null;
                }
                if (indexType.equals("LOCALSORTEDMAP") || indexType.equals("BTREE")) {
                    int[] baseColumnPositions = indexCD.getIndexDescriptor().baseColumnPositions();
                    baseColumns = baseColumnPositions.length;
                    FormatableBitSet indexColsBitSet = new FormatableBitSet();
                    for (int i = 0; i < baseColumns; ++i) {
                        indexColsBitSet.grow(baseColumnPositions[i]);
                        indexColsBitSet.set(baseColumnPositions[i] - 1);
                    }
                    ExecRow indexRow = ef.getValueRow(baseColumns + 1);
                    for (int column = 0; column < baseColumns; ++column) {
                        ColumnDescriptor cd = td.getColumnDescriptor(baseColumnPositions[column]);
                        indexRow.setColumn(column + 1, cd.getType().getNull());
                    }
                    indexRow.setColumn(baseColumns + 1, rl);
                    scan = tc.openScan(indexCD.getConglomerateNumber(), false, 0, 7, 5, null, null, 0, null, null, 0, null);
                    DataValueDescriptor[] baseRowIndexOrder = new DataValueDescriptor[baseColumns];
                    DataValueDescriptor[] baseObjectArray = baseRow.getRowArray();
                    for (int i = 0; i < baseColumns; ++i) {
                        baseRowIndexOrder[i] = baseObjectArray[baseColumnPositions[i] - 1];
                    }
                    indexRowsForLocalPrimaryBuckets = 0L;
                    indexRowsForLocalRedundantBuckets = 0L;
                    long indexRows = 0L;
                    while (scan.fetchNext(indexRow)) {
                        boolean base_row_exists;
                        RowLocation baseRL = (RowLocation)indexRow.getColumn(baseColumns + 1);
                        boolean bl = base_row_exists = (baseRL = baseCC.fetch(baseRL, baseRow, indexColsBitSet, false)) != null;
                        if (base_row_exists) {
                            indexRow.setColumn(baseColumns + 1, baseRL);
                            if (region.getDataPolicy().withPartitioning() && localPrimaryBucketSet.contains(baseRL.getBucketID())) {
                                ++indexRowsForLocalPrimaryBuckets;
                            } else {
                                ++indexRowsForLocalRedundantBuckets;
                            }
                        }
                        if (!base_row_exists) {
                            String indexName = indexCD.getConglomerateName();
                            throw StandardException.newException("X0X62.S", schemaName + "." + tableName, (Object)indexName, (Object)baseRL.toString(), (Object)indexRow.toString());
                        }
                        for (int column = 0; column < baseColumns; ++column) {
                            DataValueDescriptor baseColumn;
                            DataValueDescriptor indexColumn = indexRow.getColumn(column + 1);
                            if (indexColumn.compare(baseColumn = baseRowIndexOrder[column]) == 0) continue;
                            ColumnDescriptor cd = td.getColumnDescriptor(baseColumnPositions[column]);
                            throw StandardException.newException("X0X61.S", indexCD.getConglomerateName(), (Object)td.getSchemaName(), (Object)td.getName(), (Object)baseRL.toString(), (Object)cd.getColumnName(), (Object)indexColumn.toString(), (Object)baseColumn.toString(), (Object)indexRow.toString());
                        }
                        ++indexRows;
                    }
                    scan.close();
                    scan = null;
                    if (indexRows == baseRowCount) continue;
                    if (!region.getDataPolicy().withPartitioning()) {
                        throw StandardException.newException("X0Y55.S", indexCD.getConglomerateName(), (Object)td.getSchemaName(), (Object)td.getName(), (Object)Long.toString(indexRows), (Object)Long.toString(baseRowCount));
                    }
                    throw StandardException.newException("X0Y60.S", indexCD.getConglomerateName(), (Object)(td.getSchemaName() + "." + td.getName()), (Object)Long.toString(indexRows), (Object)Long.toString(baseRowCount), (Object)Long.toString(basePrimaryBucketsRowCount), (Object)Long.toString(baseRedundantBucketsRowCount), (Object)Long.toString(indexRowsForLocalPrimaryBuckets), (Object)Long.toString(indexRowsForLocalRedundantBuckets));
                }
                if (indexType.equals("GLOBALHASH")) {
                    ConsistencyChecker.checkGlobalHashIndex(tc, td, baseCC, heapCD, indexCD);
                    continue;
                }
                SanityManager.THROWASSERT((String)("unknown indexType=" + indexType));
            }
            ConstraintDescriptorList constraintDescList = dd.getConstraintDescriptors(td);
            for (int index = 0; index < constraintDescList.size(); ++index) {
                ConglomerateDescriptor conglomDesc;
                constraintDesc = constraintDescList.elementAt(index);
                if (!constraintDesc.hasBackingIndex() || (conglomDesc = td.getConglomerateDescriptor(constraintDesc.getConglomerateId())) != null) continue;
                throw StandardException.newException("42X94", (Object)"INDEX for CONSTRAINT", (Object)constraintDesc.getConstraintName());
            }
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        finally {
            try {
                if (baseCC != null) {
                    baseCC.close();
                    baseCC = null;
                }
                if (indexCC != null) {
                    indexCC.close();
                    indexCC = null;
                }
                if (scan != null) {
                    scan.close();
                    scan = null;
                }
                if (!tc.isTransactional()) {
                    tc.releaseAllLocks(false, false);
                }
            }
            catch (StandardException se) {
                throw PublicAPI.wrapStandardException(se);
            }
        }
        return true;
    }

    static void checkGlobalHashIndex(TransactionController tc, TableDescriptor td, ConglomerateController baseCC, ConglomerateDescriptor heapCD, ConglomerateDescriptor indexCD) throws StandardException {
        LocalRegion globalIndexRegion = (LocalRegion)Misc.getRegionForTable(td.getSchemaName() + "." + indexCD.getDescriptorName(), true);
        ExecRow baseRow = td.getEmptyExecRow();
        IndexRowGenerator irg = indexCD.getIndexDescriptor();
        int[] baseColumnPositions = irg.baseColumnPositions();
        int baseColumns = baseColumnPositions.length;
        DataValueDescriptor[] searchCondition = new DataValueDescriptor[baseColumnPositions.length];
        ExecIndexRow indexRow = irg.getIndexRowTemplate();
        ScanController scan = tc.openScan(heapCD.getConglomerateNumber(), false, 0, 7, 5, RowUtil.EMPTY_ROW_BITSET, null, 0, null, null, 0, null);
        irg.getIndexRow(baseRow, scan.newRowLocationTemplate(), indexRow, null);
        int batchSize = 5000;
        Object[] tableIndexKeys = new Object[batchSize];
        int numRows = 0;
        if (baseColumns > 1) {
            for (int p = 0; p < batchSize; ++p) {
                tableIndexKeys[p] = new CompositeRegionKey();
            }
        }
        while (scan.next()) {
            DataValueDescriptor[] key;
            scan.fetch(baseRow);
            for (int i = 0; i < baseColumns; ++i) {
                searchCondition[i] = baseRow.getColumn(baseColumnPositions[i]);
            }
            if (searchCondition.length == 1) {
                tableIndexKeys[numRows] = key = searchCondition[0].getClone();
            } else {
                key = ConsistencyChecker.getNewArray(searchCondition, baseColumns, true);
                ((CompositeRegionKey)tableIndexKeys[numRows]).setPrimaryKey(key);
            }
            if (++numRows % batchSize != 0) continue;
            ConsistencyChecker.checkTableKeysInGlobalIndexRegion(td, indexCD, globalIndexRegion, searchCondition, Arrays.asList(tableIndexKeys));
            Arrays.asList(tableIndexKeys);
            numRows = 0;
        }
        if (numRows > 0) {
            Object[] remainingTableIndexKeys = Arrays.copyOfRange(tableIndexKeys, 0, numRows);
            ConsistencyChecker.checkTableKeysInGlobalIndexRegion(td, indexCD, globalIndexRegion, searchCondition, Arrays.asList(remainingTableIndexKeys));
        }
        scan.close();
        scan = null;
    }

    private static void checkTableKeysInGlobalIndexRegion(TableDescriptor td, ConglomerateDescriptor indexCD, LocalRegion globalIndexRegion, DataValueDescriptor[] searchCondition, Collection tableIndexKeys) throws StandardException {
        Map globalIndexEntriesMap = globalIndexRegion.getAll(tableIndexKeys);
        for (Object o : tableIndexKeys) {
            if (globalIndexEntriesMap.get(o) != null) continue;
            Object[] keyColumns = new DataValueDescriptor[searchCondition.length];
            if (searchCondition.length == 1) {
                keyColumns[0] = (DataValueDescriptor)o;
            } else {
                ((CompositeRegionKey)o).getKeyColumns((DataValueDescriptor[])keyColumns);
            }
            throw StandardException.newException("X0X64.S", (Object)td.getQualifiedName(), (Object)indexCD.getConglomerateName(), (Object)RowUtil.toString(keyColumns));
        }
    }

    private static DataValueDescriptor[] getNewArray(DataValueDescriptor[] row, int numColumns, boolean clone) {
        DataValueDescriptor[] newRow = new DataValueDescriptor[numColumns];
        for (int index = 0; index < numColumns; ++index) {
            newRow[index] = clone ? row[index].getClone() : row[index];
        }
        return newRow;
    }
}

