/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.hadoop;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.hdfs.HDFSStore;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreFactoryImpl;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.DDLHoplogOrganizer;
import com.gemstone.gemfire.internal.shared.Version;
import com.gemstone.gemfire.internal.util.BlobHelper;
import com.pivotal.gemfirexd.internal.engine.ddl.DDLConflatable;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLRegionQueue;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;

public class HadoopGfxdLonerConfig {
    private Properties bootProps;
    private GemFireStore gemfireStore;
    private String namenodeUrl = null;
    private String hdfsHomeDirs = null;
    private Configuration config = null;

    public HadoopGfxdLonerConfig(Properties properties, GemFireStore gemfireStore) {
        this.gemfireStore = gemfireStore;
        this.bootProps = properties;
        this.namenodeUrl = this.bootProps.getProperty("hadoop.gemfirexd.loner.namenodeurl");
        this.hdfsHomeDirs = this.bootProps.getProperty("hadoop.gemfirexd.loner.homedirs");
        assert (this.hdfsHomeDirs != null);
        this.config = new Configuration();
        Enumeration<?> propNames = properties.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propValue = properties.getProperty(propName);
            if (!propName.startsWith("hadoop.gemfirexd.loner.props.")) continue;
            String hadoopProp = propName.substring("hadoop.gemfirexd.loner.props.".length());
            this.config.set(hadoopProp, propValue);
        }
    }

    public void loadDDLQueueWithDDLsFromHDFS(GfxdDDLRegionQueue ddlStmtQueue) {
        try {
            String[] homedirs;
            for (String homedir : homedirs = this.hdfsHomeDirs.split(",")) {
                if (homedir.length() == 0) continue;
                String tempHDFSStoreName = "StoreForDDLFetching" + System.nanoTime();
                HDFSStoreFactoryImpl hdfsStoreFactory = new HDFSStoreFactoryImpl((Cache)this.gemfireStore.getGemFireCache());
                HDFSStore hdfsStore = hdfsStoreFactory.setConfiguration(this.config).setHomeDir(homedir).setNameNodeURL(this.namenodeUrl).create(tempHDFSStoreName);
                DDLHoplogOrganizer ddlOrganizer = new DDLHoplogOrganizer(hdfsStore);
                ArrayList ddls = null;
                int LOOP_COUNT = 3;
                int repeat = 0;
                DDLHoplogOrganizer.DDLHoplog ddlHoplog = null;
                while (true) {
                    try {
                        ++repeat;
                        ddlHoplog = ddlOrganizer.getDDLStatementsForReplay();
                    }
                    catch (IOException e) {
                        if (repeat < 3) continue;
                        throw e;
                    }
                    break;
                }
                if (ddlHoplog != null && ddlHoplog.getDDLStatements() != null) {
                    ddls = ddlHoplog.getDDLStatements();
                    for (byte[] ddl : ddls) {
                        DDLConflatable ddlConflatable = (DDLConflatable)BlobHelper.deserializeBlob((byte[])ddl, (Version)ddlHoplog.getDDLVersion(), null);
                        try {
                            ddlStmtQueue.put(ddlConflatable.getId(), ddlConflatable);
                        }
                        catch (EntryExistsException entryExistsException) {}
                    }
                }
                ddlOrganizer.close();
            }
        }
        catch (IOException e) {
            throw new GemFireXDRuntimeException("Exception thrown while loading DDL statements from HDFS. Internal exception: " + e);
        }
        catch (CacheException e) {
            throw new GemFireXDRuntimeException("Exception thrown while loading DDL statements from HDFS. Internal exception: " + (Object)((Object)e));
        }
        catch (ClassNotFoundException e) {
            throw new GemFireXDRuntimeException("Exception thrown while loading DDL statements from HDFS. Internal exception: " + e);
        }
        catch (InterruptedException e) {
            throw new GemFireXDRuntimeException("Exception thrown while loading DDL statements from HDFS. Internal exception: " + e);
        }
    }

    public Properties removeHadoopProperties(Properties properties) {
        Properties newprops = new Properties();
        if (properties == null) {
            return newprops;
        }
        Enumeration<?> propNames = properties.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propValue = properties.getProperty(propName);
            if (propName == null) continue;
            if (propValue == null) {
                propValue = "";
            }
            if (propName.startsWith("hadoop.gemfirexd.loner.props.")) continue;
            newprops.put(propName, propValue);
        }
        return newprops;
    }
}

