/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ui;

import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import com.pivotal.gemfirexd.internal.engine.ui.SnappyIndexStats;
import com.pivotal.gemfirexd.internal.engine.ui.SnappyRegionStats;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SnappyRegionStatsCollectorResult
extends GfxdDataSerializable {
    private transient List<SnappyRegionStats> combinedStats = new ArrayList<SnappyRegionStats>();
    private transient List<SnappyIndexStats> indexStats = new ArrayList<SnappyIndexStats>();
    private static Version[] serializationVersions = new Version[]{Version.STORE_162};

    public void addRegionStat(SnappyRegionStats stats) {
        this.combinedStats.add(stats);
    }

    public void addIndexStat(SnappyIndexStats stats) {
        this.indexStats.add(stats);
    }

    public void addAllIndexStat(List<SnappyIndexStats> stats) {
        this.indexStats.addAll(stats);
    }

    public List<SnappyRegionStats> getRegionStats() {
        return this.combinedStats;
    }

    public List<SnappyIndexStats> getIndexStats() {
        return this.indexStats;
    }

    @Override
    public byte getGfxdID() {
        return 111;
    }

    @Override
    public Version[] getSerializationVersions() {
        return serializationVersions;
    }

    private void toData(DataOutput out, boolean pre162) throws IOException {
        out.writeInt(this.combinedStats.size());
        for (SnappyRegionStats snappyRegionStats : this.combinedStats) {
            if (pre162) {
                snappyRegionStats.toDataPre_STORE_1_6_2_0(out);
                continue;
            }
            snappyRegionStats.toData(out);
        }
        out.writeInt(this.indexStats.size());
        for (SnappyIndexStats snappyIndexStats : this.indexStats) {
            InternalDataSerializer.writeString((String)snappyIndexStats.getIndexName(), (DataOutput)out);
            InternalDataSerializer.writeLong((Long)snappyIndexStats.getRowCount(), (DataOutput)out);
            InternalDataSerializer.writeLong((Long)snappyIndexStats.getSizeInMemory(), (DataOutput)out);
        }
    }

    public void toDataPre_STORE_1_6_2_0(DataOutput out) throws IOException {
        this.toData(out, true);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        this.toData(out, false);
    }

    private void fromData(DataInput in, boolean pre162) throws IOException {
        int size = in.readInt();
        while (size > 0) {
            --size;
            SnappyRegionStats stats = new SnappyRegionStats();
            if (pre162) {
                stats.fromDataPre_STORE_1_6_2_0(in);
            } else {
                stats.fromData(in);
            }
            this.addRegionStat(stats);
        }
        for (int numIndex = in.readInt(); numIndex > 0; --numIndex) {
            String indexName = InternalDataSerializer.readString((DataInput)in);
            long rowCount = InternalDataSerializer.readLong((DataInput)in);
            long sizeInMemory = InternalDataSerializer.readLong((DataInput)in);
            this.addIndexStat(new SnappyIndexStats(indexName, rowCount, sizeInMemory));
        }
    }

    public void fromDataPre_STORE_1_6_2_0(DataInput in) throws IOException {
        this.fromData(in, true);
    }

    @Override
    public void fromData(DataInput in) throws IOException {
        this.fromData(in, false);
    }
}

