/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;

public class IndexStats {
    public static final String typeName = "IndexUsageStats";
    private static final StatisticsType type;
    protected static int pointLookupId;
    protected static int indexSubmapId;
    protected static final String INDEX_SCAN_POINT_LOOKUP = "IndexPointLookup";
    protected static final String INDEX_SCAN_RANGE = "IndexRangeScan";
    private Statistics stats;

    public IndexStats(DistributedSystem dsys, String indexName) {
        this.stats = dsys.createAtomicStatistics(type, indexName);
    }

    public void close() {
        this.stats.close();
    }

    public void incPointLookupStats() {
        this.stats.incLong(pointLookupId, 1L);
    }

    public void incScanStats() {
        this.stats.incLong(indexSubmapId, 1L);
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        type = f.createType(typeName, "Stats for checking index effectiveness", new StatisticDescriptor[]{f.createLongCounter(INDEX_SCAN_POINT_LOOKUP, "Number of Times index used for point lookups.", "operations", true), f.createLongCounter(INDEX_SCAN_RANGE, "Number of Times index used for range lookups.", "operations", true)});
        pointLookupId = type.nameToId(INDEX_SCAN_POINT_LOOKUP);
        indexSubmapId = type.nameToId(INDEX_SCAN_RANGE);
    }
}

