/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.ResultHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.message.StatementExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.XPLAINDistPropsDescriptor;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireDistributionActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.ActivationStatisticsVisitor;
import com.pivotal.gemfirexd.internal.engine.sql.execute.DistributionObserver;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireDeleteActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireDeleteDistributionActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireDistributedResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireSelectActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireSelectDistributionActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireUpdateActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireUpdateDistributionActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.IteratorStatisticsVisitor;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINResultSetDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINResultSetTimingsDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINScanPropsDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINSortPropsDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ConstantActionActivation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.StatementPlanCollector;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.List;
import java.util.Set;

public final class DistributionPlanCollector
implements ActivationStatisticsVisitor,
IteratorStatisticsVisitor {
    private static final long serialVersionUID = 1973771854223467210L;
    private final StatementPlanCollector baseCollector;
    private boolean considerTimingInformation;
    private LanguageConnectionContext lcc;
    private BaseActivation ac;
    private DataDictionary dd;
    private XPLAINDistPropsDescriptor root_msg_descriptor;

    public DistributionPlanCollector(StatementPlanCollector parentCollector, List<XPLAINDistPropsDescriptor> dsets) {
        this.baseCollector = parentCollector;
    }

    public void setup(BaseActivation activation) {
        this.ac = activation;
        this.lcc = this.ac.getLanguageConnectionContext();
        this.dd = this.lcc.getDataDictionary();
        this.considerTimingInformation = this.lcc.getStatisticsTiming();
    }

    public void processDistribution(ResultSet rs) {
        BaseActivation ac = (BaseActivation)rs.getActivation();
        this.baseCollector.setNumberOfChildren(1);
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("DistributionPlanCollector: Processing activation " + ac));
        }
        ac.accept(this);
    }

    public void processGFDistResultSet(GemFireDistributedResultSet rs) {
        this.setup(rs.act);
        this.processDistribution(rs);
        if (rs.iterator != null) {
            rs.iterator.accept(this);
        }
        this.baseCollector.setNumberOfChildren(0);
        XPLAINResultSetTimingsDescriptor time_desc = null;
        if (this.considerTimingInformation) {
            UUID timingID = this.dd.getUUIDFactory().createUUID();
            time_desc = this.baseCollector.createResultSetTimingDescriptor(timingID, 0L, rs.openTime, rs.nextTime, rs.closeTime, rs.getTimeSpent(0, 0), 1, -1L, -1L);
        }
        this.baseCollector.createResultSetDescriptor(rs.getClass().getSimpleName(), time_desc, null, null, "DISTRIBUTION-END", rs.getClass().getSimpleName(), -1, -1.0, -1.0, 0, 0, rs.rowsReturned, null, null, null);
        this.clean();
    }

    public void processMessage(StatementExecutorMessage<?> msg, ResultHolder rh, boolean isLocallyExecuted) {
        GemFireCacheImpl c;
        UUID distID = this.dd.getUUIDFactory().createUUID();
        String sender = msg.getSender() != null ? msg.getSender().toString() : ((c = Misc.getGemFireCacheNoThrow()) != null ? c.getDistributedSystem().getDistributedMember().toString() : null);
        long connectionID = this.ac.getConnectionID();
        UUID statementID = this.baseCollector.getStmtUUID();
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("Collecting distribution plan for statementID=" + statementID + (this.considerTimingInformation ? " with time stats " : " without time stats")));
        }
        XPLAINDistPropsDescriptor distdesc = new XPLAINDistPropsDescriptor(distID, statementID, null, XPLAINUtil.DIRECTION.IN, connectionID == -2L ? (short)2 : 1, "QUERY-RECEIVE", sender);
        msg.setDistributionStatistics(distdesc, true);
        if (distdesc.locallyExecuted != isLocallyExecuted) {
            SanityManager.THROWASSERT((String)("Distribution information wrongly captured distdesc. locallyExecuted=" + distdesc.locallyExecuted + " isLocallyExecuted=" + isLocallyExecuted));
        }
        this.baseCollector.setNumberOfChildren(distdesc.memberSentMappedDesc.size() + distdesc.memberReplyMappedDesc.size());
        this.baseCollector.createDistPropDescriptor(distdesc);
        this.baseCollector.createResultSetDescriptor(msg.getClass().getSimpleName(), null, null, null, "QUERY-RECEIVE", msg.getClass().getSimpleName(), -1, -1.0, -1.0, 0, 0, -1, null, null, distdesc);
        this.createSendReceiveResultSet(distdesc.memberSentMappedDesc, rh, statementID);
        this.createSendReceiveResultSet(distdesc.memberReplyMappedDesc, rh, statementID);
    }

    private void createSendReceiveResultSet(List<XPLAINDistPropsDescriptor> memberMappedDesc, ResultHolder rh, UUID statementID) {
        long[] prev_rh_stats = null;
        for (XPLAINDistPropsDescriptor desc : memberMappedDesc) {
            int rows_returned;
            long[] rh_stats;
            if (rh != null) {
                this.setNumberOfChildren(1);
            } else {
                this.setNumberOfChildren(0);
            }
            this.createSendReceiveResultSet(desc);
            UUID rh_distID = this.dd.getUUIDFactory().createUUID();
            if (rh == null) continue;
            XPLAINDistPropsDescriptor rh_distdesc = new XPLAINDistPropsDescriptor(rh_distID, statementID, desc.getRSID(), XPLAINUtil.DIRECTION.OUT, 0, "RESULT-HOLDER", null);
            if (GemFireXDUtils.TracePlanGeneration) {
                SanityManager.ASSERT((rh.ser_deser_time + rh.process_time != 0L || rh.rows_returned == 0 ? 1 : 0) != 0, (String)(" execute_time is " + rh.process_time + " serialization " + rh.ser_deser_time + " throttling time " + rh.throttle_time + " rows returned " + rh.rows_returned));
            }
            if ((rh_stats = desc.getReplySingleResultStatistics()) != null && prev_rh_stats == null) {
                SanityManager.ASSERT((rh_stats.length == 4 ? 1 : 0) != 0);
                rh_distdesc.setSerDeSerTime(rh_stats[0]);
                rh_distdesc.setProcessTime(rh_stats[1]);
                rh_distdesc.setThrottleTime(rh_stats[2]);
                rows_returned = (int)rh_stats[3];
                prev_rh_stats = rh_stats;
            } else if (rh_stats != null && prev_rh_stats != null) {
                rh_distdesc.setSerDeSerTime(rh_stats[0] - prev_rh_stats[0]);
                rh_distdesc.setProcessTime(rh_stats[1] - prev_rh_stats[1]);
                rh_distdesc.setThrottleTime(rh_stats[2] - prev_rh_stats[2]);
                rows_returned = (int)(rh_stats[3] - prev_rh_stats[3]);
                prev_rh_stats = rh_stats;
            } else {
                rh_distdesc.setSerDeSerTime(rh.ser_deser_time);
                rh_distdesc.setProcessTime(rh.process_time);
                rh_distdesc.setThrottleTime(rh.throttle_time);
                rows_returned = rh.rows_returned;
            }
            this.baseCollector.createDistPropDescriptor(rh_distdesc);
            if (rh_stats == null) {
                this.setNumberOfChildren(1);
            } else {
                this.setNumberOfChildren(0);
            }
            this.baseCollector.createResultSetDescriptor(rh.getClass().getSimpleName(), null, null, null, "RESULT-HOLDER", rh.getClass().getSimpleName(), 1, -1.0, -1.0, -1, -1, rows_returned, null, null, rh_distdesc);
        }
    }

    private void processObserverStatistics(AbstractGemFireDistributionActivation ac) {
        Object[] stats;
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.ASSERT((this.baseCollector.getNumberOfChildren() > 0 ? 1 : 0) != 0);
        }
        if ((stats = ac.observerStatistics) == null) {
            return;
        }
        UUID rsID = this.baseCollector.popUUIDFromStack();
        this.processGlobalIndex(rsID, (DistributionObserver.GlobalIndexStat)stats[DistributionObserver.StatObjects.GLOBAL_INDEX.ordinal()]);
    }

    private void processGlobalIndex(UUID parentRSID, DistributionObserver.GlobalIndexStat stat) {
        if (stat.indexName == null) {
            return;
        }
        XPLAINResultSetTimingsDescriptor time_desc = null;
        if (this.considerTimingInformation) {
            UUID timingID = this.dd.getUUIDFactory().createUUID();
            long fetchTime = stat.seekTime;
            time_desc = this.baseCollector.createResultSetTimingDescriptor(timingID, 0L, 0L, fetchTime, 0L, fetchTime, 1, -1L, -1L);
        }
        UUID scanID = this.dd.getUUIDFactory().createUUID();
        String lookupKey = stat.lookupKey.toString();
        XPLAINScanPropsDescriptor scan_desc = this.baseCollector.createScanPropDescriptor("G", stat.indexName, lookupKey, lookupKey, scanID, 2, 1, null, null, stat.baseColPos);
        int returned_rows = 0;
        if (stat.result != null) {
            returned_rows = 1;
        }
        this.baseCollector.createResultSetDescriptor("GLOBALINDEXSCAN", time_desc, null, null, "GLOBALINDEXSCAN", stat.indexName, stat.numOpens, stat.esitmatedRowCount, stat.esitmatedCost, 1, 0, returned_rows, scan_desc, null, null);
    }

    @Override
    public void visit(Activation ac, int donotHonor) {
        throw new AssertionError((Object)"#visit(Activation, int) Method call not expected ");
    }

    @Override
    public void visit(BaseActivation ac, int donotHonor) {
        throw new AssertionError((Object)"#visit(BaseActivation, int) Method call not expected ");
    }

    @Override
    public final void visit(AbstractGemFireActivation ac, int donotHonor) {
        throw new AssertionError((Object)"#visit(AbstractGemFireActivation, int) Method call not expected ");
    }

    @Override
    public void visit(AbstractGemFireDistributionActivation ac, int donotHonor) {
        throw new AssertionError((Object)"#visit(AbstractGemFireDistributionActivation, int) Method call not expected ");
    }

    @Override
    public void visit(GemFireSelectActivation ac) {
    }

    @Override
    public void visit(GemFireUpdateActivation ac) {
    }

    @Override
    public void visit(GemFireDeleteActivation ac) {
    }

    @Override
    public void visit(GemFireSelectDistributionActivation ac) {
        UUID distID = this.dd.getUUIDFactory().createUUID();
        GemFireCacheImpl c = Misc.getGemFireCacheNoThrow();
        this.root_msg_descriptor = new XPLAINDistPropsDescriptor(distID, this.baseCollector.getStmtUUID(), XPLAINUtil.DIRECTION.OUT, ac.distributionLevel, "QUERY-SCATTER", c != null ? c.getDistributedSystem().getDistributedMember().toString() : null, (Set<Object>)ac.routingKeysToExecute, ac.routingComputeTime, ac.prepStmntAwareMembers, ac.getParameterValueSet());
        ac.functionMsg.setDistributionStatistics(this.root_msg_descriptor, false);
        this.baseCollector.createDistPropDescriptor(this.root_msg_descriptor);
        int numChildren = 2 + this.root_msg_descriptor.memberSentMappedDesc.size() + this.root_msg_descriptor.memberReplyMappedDesc.size() + this.getNumObserverStatistics(ac);
        this.baseCollector.setNumberOfChildren(numChildren);
        this.baseCollector.createResultSetDescriptor(ac.getClass().getSimpleName(), null, null, null, "QUERY-SCATTER", "SELECT-DISTRIBUTION-ACTIVATION", -1, -1.0, -1.0, 0, 0, -1, null, null, this.root_msg_descriptor);
        this.processObserverStatistics(ac);
        block0: for (XPLAINDistPropsDescriptor desc : this.root_msg_descriptor.memberSentMappedDesc) {
            this.setNumberOfChildren(0);
            this.createSendReceiveResultSet(desc);
            for (XPLAINDistPropsDescriptor reply_desc : this.root_msg_descriptor.memberReplyMappedDesc) {
                if (!reply_desc.getOriginator().equals(desc.getTargetMember())) continue;
                this.setNumberOfChildren(0);
                this.createSendReceiveResultSet(reply_desc);
                continue block0;
            }
        }
    }

    private int getNumObserverStatistics(AbstractGemFireDistributionActivation ac) {
        int totalObserverStats = 0;
        Object[] stats = ac.observerStatistics;
        if (stats == null) {
            return 0;
        }
        DistributionObserver.GlobalIndexStat stat = (DistributionObserver.GlobalIndexStat)stats[DistributionObserver.StatObjects.GLOBAL_INDEX.ordinal()];
        if (stat.indexName != null) {
            ++totalObserverStats;
        }
        return totalObserverStats;
    }

    private void createSendReceiveResultSet(XPLAINDistPropsDescriptor desc) {
        this.baseCollector.createDistPropDescriptor(desc);
        this.baseCollector.createResultSetDescriptor(desc.getDistObjectName(), null, null, null, desc.getDistObjectType(), desc.getDistObjectName(), -1, -1.0, -1.0, 0, 0, -1, null, null, desc);
    }

    @Override
    public void visit(GemFireUpdateDistributionActivation ac) {
    }

    @Override
    public void visit(GemFireDeleteDistributionActivation ac) {
    }

    @Override
    public void visit(ConstantActionActivation ac) {
    }

    @Override
    public void reset() {
    }

    private void clean() {
        this.lcc = null;
        this.dd = null;
        this.ac = null;
        GemFireXDQueryObserver ob = GemFireXDQueryObserverHolder.getInstance();
        if (ob != null) {
            ob.reset();
        }
    }

    @Override
    public void visit(GemFireDistributedResultSet.RSIterator it, int donotHonor) {
        throw new AssertionError((Object)"#visit(RSIteration, int) Method call not expected ");
    }

    @Override
    public void visit(GemFireDistributedResultSet.SequentialIterator it) {
        this.createIteratorDescriptor(it, "SEQUENTIAL-ITERATION", null, -1, -1);
    }

    @Override
    public void visit(GemFireDistributedResultSet.RoundRobinIterator it) {
        this.createIteratorDescriptor(it, "ROUNDROBIN-ITERATION", null, -1, -1);
    }

    @Override
    public void visit(ResultHolder rh) {
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.ASSERT((this.root_msg_descriptor != null ? 1 : 0) != 0, (String)"at this point we should have processed all the reply messages");
        }
        XPLAINDistPropsDescriptor replyMsgDesc = null;
        for (XPLAINDistPropsDescriptor d : this.root_msg_descriptor.memberReplyMappedDesc) {
            if (d.replySingleResult != rh) continue;
            replyMsgDesc = d;
        }
        if (replyMsgDesc == null) {
            if (GemFireXDUtils.TracePlanGeneration) {
                SanityManager.ASSERT((!GemFireXDUtils.getMyVMKind().isStore() || !rh.isLocallyExecuted() ? 1 : 0) != 0, (String)("expected to be locally execute RH. IsStore=" + GemFireXDUtils.getMyVMKind().isStore()));
            }
            replyMsgDesc = this.root_msg_descriptor;
        }
        UUID distID = this.dd.getUUIDFactory().createUUID();
        XPLAINDistPropsDescriptor distdesc = new XPLAINDistPropsDescriptor(distID, this.baseCollector.getStmtUUID(), replyMsgDesc.getRSID(), XPLAINUtil.DIRECTION.IN, 0, "RESULT-HOLDER", replyMsgDesc.getOriginator());
        distdesc.setSerDeSerTime(rh.ser_deser_time);
        distdesc.setProcessTime(rh.process_time);
        distdesc.setThrottleTime(rh.throttle_time);
        this.setNumberOfChildren(0);
        this.baseCollector.createDistPropDescriptor(distdesc);
        this.baseCollector.createResultSetDescriptor(rh.getClass().getSimpleName(), null, null, null, "RESULT-HOLDER", rh.getClass().getSimpleName(), 1, -1.0, -1.0, -1, -1, rh.rows_returned, null, null, distdesc);
    }

    @Override
    public void visit(GemFireDistributedResultSet.OrderedIterator it) {
        UUID sortID = this.dd.getUUIDFactory().createUUID();
        SanityManager.ASSERT((it.sortProperties != null ? 1 : 0) != 0, (String)"Sort properties must have been got created by this time .");
        XPLAINSortPropsDescriptor sort_desc = this.baseCollector.createSortPropDescriptor(sortID, it.sortProperties, null, -1, -1, -1, it.sortDistinct, it.source instanceof GemFireDistributedResultSet.RoundRobinIterator);
        this.createIteratorDescriptor(it, "ORDERED-ITERATION", sort_desc, -1, it.rowsInput);
    }

    @Override
    public void visit(GemFireDistributedResultSet.GroupedIterator it) {
        this.createIteratorDescriptor(it, "GROUPED-ITERATION", null, -1, -1);
    }

    @Override
    public void visit(GemFireDistributedResultSet.SpecialCaseOuterJoinIterator it) {
        this.createIteratorDescriptor(it, "OUTER-JOIN-ITERATION", null, -1, -1);
    }

    @Override
    public void visit(GemFireDistributedResultSet.SetOperatorIterator it) {
        this.createIteratorDescriptor(it, "SET", null, -1, -1);
    }

    @Override
    public void visit(GemFireDistributedResultSet.RowCountIterator it) {
        this.createIteratorDescriptor(it, "ROW-COUNT-ITERATION", null, -1, -1);
    }

    @Override
    public void setNumberOfChildren(int noChildren) {
        this.baseCollector.setNumberOfChildren(noChildren);
    }

    private void createIteratorDescriptor(GemFireDistributedResultSet.AbstractRSIterator it, String opDetail, XPLAINSortPropsDescriptor sort, int rowsSeen, int rowsInput) {
        XPLAINResultSetTimingsDescriptor time_desc = null;
        if (this.considerTimingInformation) {
            UUID timingID = this.dd.getUUIDFactory().createUUID();
            time_desc = this.baseCollector.createResultSetTimingDescriptor(timingID, -1L, -1L, it.nextTime, -1L, it.nextTime == 0L ? 1L : it.nextTime, it.rowsReturned, -1L, -1L);
        }
        XPLAINResultSetDescriptor rdesc = this.baseCollector.createResultSetDescriptor(it.getClass().getSimpleName(), time_desc, null, null, opDetail, it.getClass().getSimpleName(), 1, -2.0, -1.0, -1, -1, it.rowsReturned, null, sort, null);
        rdesc.setInputRows(rowsInput);
        rdesc.setRowsSeen(rowsSeen);
    }
}

