/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireDistributionActivation;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

public final class DistributionObserver
extends GemFireXDQueryObserverAdapter {
    private static final long serialVersionUID = -3504542001869619050L;
    private static final DistributionObserver _theObserver;
    private static final AtomicInteger refCount;
    private volatile boolean deleteMode = false;
    private static ThreadLocal<Object[]> dataPoints;
    private boolean statisticsTimingOn = false;

    private DistributionObserver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setObserver() {
        if (refCount.incrementAndGet() > 0 && (GemFireXDQueryObserverHolder.getInstance() == null || DistributionObserver._theObserver.deleteMode)) {
            DistributionObserver distributionObserver = _theObserver;
            synchronized (distributionObserver) {
                if (GemFireXDQueryObserverHolder.getInstance() == null) {
                    GemFireXDQueryObserverHolder.putInstanceIfAbsent(_theObserver);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unsetObserver() {
        int existingCount = refCount.decrementAndGet();
        if (existingCount < 1 && GemFireXDQueryObserverHolder.getInstance() != null) {
            DistributionObserver distributionObserver = _theObserver;
            synchronized (distributionObserver) {
                if (GemFireXDQueryObserverHolder.getInstance() != null && refCount.get() == existingCount) {
                    try {
                        DistributionObserver._theObserver.deleteMode = true;
                        GemFireXDQueryObserverHolder.removeObserver(DistributionObserver.class);
                    }
                    finally {
                        DistributionObserver._theObserver.deleteMode = false;
                    }
                }
            }
        }
    }

    public static void clearStatics() {
        refCount.set(0);
    }

    private static Object[] popData() {
        Object[] ret = dataPoints.get();
        dataPoints.remove();
        return ret;
    }

    @Override
    public void reset() {
    }

    private static void clean() {
        Object[] stat = dataPoints.get();
        GlobalIndexStat gbs = (GlobalIndexStat)stat[StatObjects.GLOBAL_INDEX.ordinal()];
        gbs.release();
    }

    @Override
    public void beforeGemFireActivationCreate(AbstractGemFireActivation ac) {
        this.statisticsTimingOn = ac.getLanguageConnectionContext().getStatisticsTiming();
        if (this.statisticsTimingOn) {
            ac.constructorTime = XPLAINUtil.nanoTime();
        }
    }

    @Override
    public void afterGemFireActivationCreate(AbstractGemFireActivation ac) {
        if (this.statisticsTimingOn) {
            ac.constructorTime = XPLAINUtil.nanoTime() - ac.constructorTime;
        }
    }

    @Override
    public void beforeGlobalIndexLookup(LanguageConnectionContext lcc, PartitionedRegion indexRegion, Serializable indexKey) {
        Object[] stat = dataPoints.get();
        GlobalIndexStat gbs = (GlobalIndexStat)stat[StatObjects.GLOBAL_INDEX.ordinal()];
        Object o = indexRegion.getUserAttribute();
        assert (o instanceof GemFireContainer);
        GemFireContainer c = (GemFireContainer)o;
        gbs.indexName = c.toString();
        gbs.baseColPos = c.getBaseColumnPositions();
        gbs.esitmatedRowCount = c.getNumRows();
        gbs.esitmatedCost = c.getRowSize();
        gbs.lookupKey = indexKey;
        if (this.statisticsTimingOn) {
            gbs.seekTime = XPLAINUtil.nanoTime();
        }
    }

    @Override
    public void afterGlobalIndexLookup(LanguageConnectionContext lcc, PartitionedRegion indexRegion, Serializable indexKey, Object result) {
        Object[] stat = dataPoints.get();
        GlobalIndexStat gbs = (GlobalIndexStat)stat[StatObjects.GLOBAL_INDEX.ordinal()];
        gbs.result = result;
        gbs.numOpens = (short)(gbs.numOpens + 1);
        if (this.statisticsTimingOn) {
            gbs.seekTime = XPLAINUtil.nanoTime() - gbs.seekTime;
        }
    }

    @Override
    public void beforeGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
    }

    @Override
    public void afterGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
        if (activation instanceof AbstractGemFireDistributionActivation) {
            ((AbstractGemFireDistributionActivation)activation).observerStatistics = DistributionObserver.popData();
        }
    }

    static {
        refCount = new AtomicInteger(0);
        _theObserver = new DistributionObserver();
        dataPoints = new ThreadLocal<Object[]>(){

            @Override
            public Object[] initialValue() {
                Object[] val = new Object[StatObjects.values().length];
                val[StatObjects.GLOBAL_INDEX.ordinal()] = new GlobalIndexStat();
                return val;
            }
        };
    }

    public static class ResultHolderStat {
        void release() {
        }
    }

    public static class GlobalIndexStat {
        String indexName;
        int[] baseColPos;
        short numOpens;
        long esitmatedRowCount;
        long esitmatedCost;
        long seekTime;
        Serializable lookupKey;
        Object result;

        void release() {
            this.indexName = null;
            this.baseColPos = null;
            this.numOpens = 0;
            this.esitmatedRowCount = 0L;
            this.esitmatedCost = 0L;
            this.seekTime = 0L;
            this.lookupKey = null;
            this.result = null;
        }
    }

    public static enum StatObjects {
        GLOBAL_INDEX;

    }
}

