/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollector;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.stream.HeaderPrintWriter;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.sql.SQLWarning;
import java.sql.Timestamp;

public abstract class AbstractGemFireResultSet
implements ResultSet {
    protected final Activation activation;
    protected final LanguageConnectionContext lcc;
    protected final GemFireTransaction tran;
    protected boolean isClosed;
    protected final GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
    protected transient boolean runtimeStatisticsOn;
    protected transient boolean statisticsTimingOn;
    protected transient boolean explainConnection;
    protected transient boolean statsEnabled;
    protected transient long beginExecutionTime;
    protected transient long endExecutionTime;
    public transient long openTime;
    public transient long nextTime;
    public transient long closeTime;
    protected NoPutResultSet[] subqueryTrackingArray;
    private UUID executionPlanID;
    protected transient boolean allTablesReplicatedOnRemote;
    protected transient boolean hasLockReference;

    public void setAllTablesReplicatedOnRemote(boolean allTablesReplicatedOnRemote) {
        this.allTablesReplicatedOnRemote = allTablesReplicatedOnRemote;
    }

    public AbstractGemFireResultSet(Activation act) {
        this.activation = act;
        this.lcc = this.activation.getLanguageConnectionContext();
        this.runtimeStatisticsOn = this.lcc.getRunTimeStatisticsMode();
        this.statisticsTimingOn = this.lcc.getStatisticsTiming();
        this.explainConnection = this.lcc.explainConnection();
        this.statsEnabled = this.lcc.statsEnabled();
        this.beginExecutionTime = this.statisticsTimingOn ? XPLAINUtil.currentTimeMillis() : 0L;
        this.tran = (GemFireTransaction)act.getTransactionController();
        this.isClosed = true;
    }

    @Override
    public final Activation getActivation() {
        return this.activation;
    }

    public final LanguageConnectionContext getLanguageConnectionContext() {
        return this.lcc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws StandardException {
        long beginTime;
        if (!this.isClosed) {
            return;
        }
        this.runtimeStatisticsOn = this.lcc.getRunTimeStatisticsMode();
        this.statisticsTimingOn = this.lcc.getStatisticsTiming();
        this.explainConnection = this.lcc.explainConnection();
        this.statsEnabled = this.lcc.statsEnabled();
        if (this.statisticsTimingOn) {
            if (this.beginExecutionTime == 0L) {
                this.beginExecutionTime = XPLAINUtil.currentTimeMillis();
            }
            beginTime = XPLAINUtil.recordTiming(this.openTime == 0L ? (this.openTime = -1L) : -2L);
        } else {
            beginTime = 0L;
        }
        this.isClosed = false;
        if (this.observer != null) {
            this.observer.beforeGemFireResultSetOpen(this, this.lcc);
        }
        StatementContext sc = this.activation.getLanguageConnectionContext().getStatementContext();
        sc.setTopResultSet(this, null);
        try {
            this.openCore();
        }
        finally {
            this.activation.checkStatementValidity();
        }
        if (this.observer != null) {
            this.observer.afterGemFireResultSetOpen(this, this.lcc);
        }
        if (beginTime != 0L) {
            this.openTime = XPLAINUtil.recordTiming(beginTime);
        }
    }

    protected abstract void openCore() throws StandardException;

    public static void openOrCloseFKContainers(GemFireContainer container, GemFireTransaction tran, boolean doClose, boolean forUpdate) throws StandardException {
        GemFireContainer[] fkContainers;
        ExtraTableInfo tableInfo = container.getExtraTableInfo();
        if (tableInfo != null && (fkContainers = tableInfo.getForeignKeyContainers()) != null) {
            for (int index = 0; index < fkContainers.length; ++index) {
                GemFireContainer refContainer = fkContainers[index];
                if (doClose) {
                    refContainer.closeForEndTransaction(tran, forUpdate);
                    continue;
                }
                refContainer.open(tran, 8);
            }
        }
    }

    public void setup(Object results, int numMembers) throws StandardException {
    }

    public void setupRC(GfxdResultCollector<?> rc) throws StandardException {
    }

    public void reset(GfxdResultCollector<?> rc) throws StandardException {
    }

    protected void setNumRowsModified(int numRowsModified) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        if (this.isClosed) {
            return;
        }
        long beginTime = this.statisticsTimingOn ? (this.closeTime == 0L ? XPLAINUtil.recordTiming(-1L) : this.closeTime) : 0L;
        LanguageConnectionContext lcc = this.activation.getLanguageConnectionContext();
        String query = null;
        if (this.observer != null) {
            ExecPreparedStatement ps = this.activation.getPreparedStatement();
            if (ps != null) {
                query = ps.getUserQueryString(lcc);
            }
            this.observer.beforeGemFireResultSetClose(this, query);
        }
        this.finishResultSet(cleanupOnError);
        if (this.activation instanceof AbstractGemFireActivation) {
            ((AbstractGemFireActivation)this.activation).currentRS = null;
        }
        if (this.observer != null) {
            this.observer.afterGemFireResultSetClose(this, query);
        }
        if (beginTime != 0L) {
            this.closeTime = XPLAINUtil.recordTiming(beginTime);
        }
        try {
            if (this.runtimeStatisticsOn) {
                this.collectPlan(lcc, cleanupOnError);
            }
        }
        finally {
            this.isClosed = true;
            if (this.activation.isSingleExecution()) {
                this.activation.close();
            }
        }
    }

    private final void collectPlan(LanguageConnectionContext lcc, boolean cleanupOnError) throws StandardException {
        HeaderPrintWriter istream;
        this.endExecutionTime = this.statisticsTimingOn ? XPLAINUtil.currentTimeMillis() : 0L;
        ExecutionFactory ef = lcc.getLanguageConnectionFactory().getExecutionFactory();
        lcc.setRunTimeStatisticsObject(ef.getResultSetStatisticsFactory().getRunTimeStatistics(this.activation, this, null));
        HeaderPrintWriter headerPrintWriter = istream = lcc.getLogQueryPlan() ? Monitor.getStream() : null;
        if (istream != null) {
            istream.printlnWithHeader("RunTime Statistics: (XID = " + lcc.getTransactionExecute().getTransactionIdString() + "), " + "(SESSIONID = " + lcc.getInstanceNumber() + "), " + lcc.getRunTimeStatisticsObject().getStatementText() + " ******* " + lcc.getRunTimeStatisticsObject().getStatementExecutionPlanText());
        }
        if (!cleanupOnError) {
            ResultSetStatisticsVisitor visitor = ef.getXPLAINFactory().getXPLAINVisitor(lcc, this.statsEnabled, this.explainConnection);
            visitor.doXPLAIN(this, this.activation, true, this.statisticsTimingOn, false);
            this.executionPlanID = visitor.getStatementUUID();
        }
        this.resetStatistics();
    }

    public PlanUtils.Context getNewPlanContext() {
        return new PlanUtils.Context();
    }

    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        PlanUtils.xmlBeginTag(builder, context, this);
        return builder;
    }

    @Override
    public UUID getExecutionPlanID() {
        return this.executionPlanID;
    }

    @Override
    public final void finish() throws StandardException {
        this.close(false);
    }

    public abstract void finishResultSet(boolean var1) throws StandardException;

    @Override
    public final boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public final Timestamp getBeginExecutionTimestamp() {
        return new Timestamp(this.beginExecutionTime);
    }

    @Override
    public final Timestamp getEndExecutionTimestamp() {
        return new Timestamp(this.endExecutionTime);
    }

    public abstract long estimateMemoryUsage() throws StandardException;

    @Override
    public long getTimeSpent(int type, int timeType) {
        return PlanUtils.getTimeSpent(0L, this.openTime, this.nextTime, this.closeTime, timeType);
    }

    @Override
    public final void checkCancellationFlag() throws StandardException {
        Activation act = this.activation;
        if (act != null && act.isQueryCancelled()) {
            act.checkCancellationFlag();
        }
    }

    @Override
    public final boolean checkRowPosition(int isType) throws StandardException {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final void cleanUp(boolean cleanupOnError) throws StandardException {
        this.close(cleanupOnError);
    }

    @Override
    public final ExecRow getAbsoluteRow(int row) throws StandardException {
        throw StandardException.newException("0A000.S.19");
    }

    @Override
    public final ExecRow getFirstRow() throws StandardException {
        throw StandardException.newException("0A000.S.19");
    }

    @Override
    public final ExecRow getLastRow() throws StandardException {
        throw StandardException.newException("0A000.S.19");
    }

    @Override
    public ExecRow getNextRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "next");
    }

    @Override
    public final ExecRow getPreviousRow() throws StandardException {
        throw StandardException.newException("0A000.S.19");
    }

    @Override
    public final ExecRow getRelativeRow(int row) throws StandardException {
        throw StandardException.newException("0A000.S.19");
    }

    @Override
    public final int getRowNumber() {
        return 0;
    }

    @Override
    public final ExecRow setBeforeFirstRow() throws StandardException {
        throw StandardException.newException("0A000.S.19");
    }

    @Override
    public final ExecRow setAfterLastRow() throws StandardException {
        throw StandardException.newException("0A000.S.19");
    }

    protected final void addWarning(SQLWarning w) {
        this.activation.addResultsetWarning(w);
    }

    @Override
    public final SQLWarning getWarnings() {
        return this.activation.getResultsetWarnings();
    }

    @Override
    public int modifiedRowCount() {
        return 0;
    }

    @Override
    public void clearCurrentRow() {
    }

    @Override
    public ResultSet getAutoGeneratedKeysResultset() {
        throw new UnsupportedOperationException("requires implementation in child");
    }

    @Override
    public boolean hasAutoGeneratedKeysResultSet() {
        return false;
    }

    @Override
    public void flushBatch() throws StandardException {
    }

    @Override
    public void closeBatch() throws StandardException {
    }

    @Override
    public final String getCursorName() {
        return null;
    }

    @Override
    public final long getExecuteTime() {
        return -1L;
    }

    @Override
    public final NoPutResultSet[] getSubqueryTrackingArray(int numSubqueries) {
        if (this.subqueryTrackingArray == null) {
            this.subqueryTrackingArray = new NoPutResultSet[numSubqueries];
        }
        return this.subqueryTrackingArray;
    }

    @Override
    public void markLocallyExecuted() {
    }

    @Override
    public void resetStatistics() {
        this.beginExecutionTime = 0L;
        this.endExecutionTime = 0L;
        this.openTime = 0L;
        this.nextTime = 0L;
        this.closeTime = 0L;
    }

    public boolean supportsMoveToNextKey() {
        return false;
    }

    public int getScanKeyGroupID() {
        throw new UnsupportedOperationException("not expected to be invoked");
    }

    @Override
    public boolean isDistributedResultSet() {
        return false;
    }

    @Override
    public boolean addLockReference(GemFireTransaction tran) {
        tran.getLockSpace().addResultSetRef();
        this.hasLockReference = true;
        return true;
    }

    @Override
    public boolean releaseLocks(GemFireTransaction tran) {
        if (this.hasLockReference) {
            tran.releaseAllLocks(false, true);
            this.hasLockReference = false;
            return true;
        }
        return false;
    }

    public void forceReOpenCore() throws StandardException {
    }
}

