/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.conn;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.internal.engine.sql.conn.ConnectionState;

final class ConnectionStateKey
implements Comparable<ConnectionStateKey> {
    private final ConnectionState state;
    private final long endWaitTime;
    static final long TIME_IMMEDIATE = -1L;

    ConnectionStateKey(ConnectionState connState) {
        this.state = connState;
        this.endWaitTime = this.state.numChanges() < this.state.minBatchSize() ? System.currentTimeMillis() + this.state.waitMillis() : -1L;
    }

    final ConnectionState connectionState() {
        return this.state;
    }

    final long endWaitTime() {
        return this.endWaitTime;
    }

    final boolean processNow() {
        int numChanges = this.state.numChanges();
        return this.endWaitTime == -1L || numChanges != 0 && (numChanges >= this.state.minBatchSize() || System.currentTimeMillis() >= this.endWaitTime);
    }

    @Override
    public final int compareTo(ConnectionStateKey conn2) {
        if (this == conn2) {
            return 0;
        }
        int remainingChanges1 = this.state.minBatchSize() - this.state.numChanges();
        int remainingChanges2 = conn2.state.minBatchSize() - conn2.state.numChanges();
        if (remainingChanges1 <= 0 || remainingChanges2 <= 0) {
            if (remainingChanges1 != remainingChanges2) {
                return remainingChanges1 < remainingChanges2 ? -1 : 1;
            }
        } else {
            long endTime1 = this.endWaitTime;
            long endTime2 = conn2.endWaitTime;
            if (endTime1 != endTime2) {
                return endTime1 < endTime2 ? -1 : 1;
            }
        }
        return ArrayUtils.objectEquals((Object)this.state, (Object)conn2.state) ? 0 : 1;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder().append(this.state).append(" [endTime: ");
        ClientSharedUtils.formatDate((long)this.endWaitTime, (StringBuilder)sb);
        sb.append(']');
        return sb.toString();
    }
}

