/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.SystemProcedures;
import com.pivotal.gemfirexd.internal.engine.diag.DiagProcedures;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StaticMethodCallNode;

public final class VerifySysfunctionExpressionVisitor
extends VisitorAdaptor {
    private boolean isStaticMethodFound = false;
    private static final String[] procedureClasses = new String[]{SystemProcedures.class.getName(), DiagProcedures.class.getName()};

    @Override
    public boolean skipChildren(Visitable node) throws StandardException {
        return this.isStaticMethodFound;
    }

    @Override
    public boolean stopTraversal() {
        return this.isStaticMethodFound;
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (node instanceof StaticMethodCallNode) {
            StaticMethodCallNode n = (StaticMethodCallNode)node;
            if (n.javaClassName != null) {
                for (String pc : procedureClasses) {
                    if (!pc.equals(n.javaClassName)) continue;
                    this.isStaticMethodFound = true;
                    break;
                }
            }
        }
        return node;
    }

    public boolean hasSysFun() {
        return this.isStaticMethodFound;
    }
}

