/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.compile;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ParameterizedConstantQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.JSQLType;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.Vector;

public final class ParameterizedConstantNode
extends ValueNode {
    private ConstantNode constantNode;
    private int constantNumber;
    private DataTypeDescriptor[] userParameterTypes;

    @Override
    public void init(Object constantCount, Object constantValueNode) throws StandardException {
        if (!(constantValueNode instanceof ConstantNode) || constantValueNode == null) {
            SanityManager.THROWASSERT((String)("Unexpected constant " + constantValueNode + " in node " + this.getNodeType()));
        }
        if (!this.getCompilerContext().isOptimizeLiteralAllowed()) {
            SanityManager.THROWASSERT((String)("Shouldn't have this type for constants in call to EmbedConnection.prepareStatement() " + this.constantNode + " statement " + this.getLanguageConnectionContext().getStatementContext().getStatementText()));
        }
        this.constantNode = (ConstantNode)constantValueNode;
        this.constantNumber = (Integer)constantCount;
    }

    public final ConstantNode constantNode() {
        return this.constantNode;
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        if (!this.getCompilerContext().isOptimizeLiteralAllowed()) {
            SanityManager.THROWASSERT((String)("Shouldn't have this type for constants in call to EmbedConnection.prepareStatement() " + this.constantNode + " statement " + this.getLanguageConnectionContext().getStatementContext().getStatementText()));
        }
        if (this.userParameterTypes != null && this.userParameterTypes[this.constantNumber] == null) {
            ValueNode n = this.constantNode.bindExpression(fromList, subqueryList, aggregateVector);
            this.setType(n.getTypeServices());
        }
        return this;
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (!this.getCompilerContext().isOptimizeLiteralAllowed()) {
            SanityManager.THROWASSERT((String)("Shouldn't have this type for constants in call to EmbedConnection.prepareStatement() " + this.constantNode + " statement " + this.getLanguageConnectionContext().getStatementContext().getStatementText()));
        }
        mb.pushThis();
        mb.push(this.constantNumber);
        mb.callMethod((short)182, "com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation", "getParameter", "com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor", 1);
        mb.cast(this.getTypeCompiler(this.constantNode.getTypeServices().getTypeId()).interfaceName());
    }

    @Override
    public String toString() {
        return "ParameterizedConstantNode::" + this.constantNode.toString();
    }

    @Override
    public boolean isParameterizedConstantNode() {
        return true;
    }

    @Override
    public boolean isConstantExpression() {
        return true;
    }

    @Override
    public boolean constantExpression(PredicateList whereClause) {
        return true;
    }

    @Override
    protected int getOrderableVariantType() {
        return 2;
    }

    @Override
    public void setType(DataTypeDescriptor descriptor) throws StandardException {
        DataTypeDescriptor inputConstantType = this.constantNode.getTypeServices();
        if (DataTypeDescriptor.isNumericType(inputConstantType.getJDBCTypeId())) {
            if (DataTypeDescriptor.isNumericType(descriptor.getJDBCTypeId()) && inputConstantType.getTypeId().typePrecedence() > descriptor.getTypeId().typePrecedence()) {
                return;
            }
        }
        if (this.userParameterTypes != null) {
            this.userParameterTypes[this.constantNumber] = descriptor;
        }
        super.setType(descriptor);
        if (descriptor.getTypeId() != this.constantNode.getTypeId()) {
            this.constantNode.setType(descriptor);
        }
    }

    @Override
    public DataTypeDescriptor getTypeServices() {
        return this.constantNode.getTypeServices();
    }

    public JSQLType getJSQLType() {
        return new JSQLType(this.constantNode.getTypeServices());
    }

    public void setDescriptors(DataTypeDescriptor[] descriptors) {
        this.userParameterTypes = descriptors;
    }

    @Override
    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeType(o)) {
            ParameterizedConstantNode other = (ParameterizedConstantNode)o;
            return this.constantNode.isEquivalent(other.constantNode);
        }
        return false;
    }

    @Override
    public QueryInfo computeQueryInfo(QueryInfoContext qic) throws StandardException {
        DMLQueryInfo queryInfo = qic.getRootQueryInfo();
        if (queryInfo.isSelect() && queryInfo.isPreparedStatementQuery()) {
            return this.constantNode.computeQueryInfo(qic);
        }
        qic.foundParameter(this.constantNumber - qic.getAbsoluteStart());
        return new ParameterizedConstantQueryInfo(this.constantNumber, this.constantNumber - qic.getAbsoluteStart());
    }

    @Override
    public ValueNode genExpressionOperands(ResultColumnList outerResultColumns, ResultColumn parentRC, boolean remapToNew) throws StandardException {
        this.constantNode = (ConstantNode)this.constantNode.genExpressionOperands(outerResultColumns, parentRC, remapToNew);
        return this;
    }

    @Override
    public boolean requiresTypeFromContext() {
        return true;
    }

    public int getConstantNumber() {
        return this.constantNumber;
    }

    @Override
    public String printExplainInfo() {
        return "CONSTANT:" + this.constantNode.printExplainInfo();
    }

    @Override
    public String ncjGenerateSql() {
        return this.constantNode.ncjGenerateSql();
    }
}

