/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.compile;

import com.pivotal.gemfirexd.internal.engine.sql.compile.HasAggregateVisitor;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.NodeFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNodeList;
import java.util.ArrayList;
import java.util.Vector;

public final class CollectExpressionOperandsVisitor
extends VisitorAdaptor {
    private final NodeFactory nf;
    private final ResultColumnList expandedRCL;
    private final boolean isCompilationAsDataStoreNode;
    private final ArrayList<Integer> numOperands;
    private final HasAggregateVisitor checkAgg;
    private ValueNodeList otherExpressions;

    public CollectExpressionOperandsVisitor(LanguageConnectionContext lcc, Vector[] aggregateInfoList, boolean isCompilationAsDataStoreNode) throws StandardException {
        if (lcc != null) {
            this.nf = lcc.getLanguageConnectionFactory().getNodeFactory();
            this.expandedRCL = (ResultColumnList)this.nf.getNode(9, lcc.getContextManager());
            this.numOperands = new ArrayList();
        } else {
            this.nf = null;
            this.expandedRCL = null;
            this.numOperands = null;
        }
        this.isCompilationAsDataStoreNode = isCompilationAsDataStoreNode;
        this.checkAgg = new HasAggregateVisitor();
    }

    public boolean visitHasAggregateVisitorOnly(ValueNode node) throws StandardException {
        this.checkAgg.reset();
        if (node != null) {
            node.accept(this.checkAgg);
        }
        return this.checkAgg.hasAggregates();
    }

    @Override
    public boolean skipChildren(Visitable node) throws StandardException {
        return !ResultColumnList.class.isInstance(node);
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (!(node instanceof ValueNode)) {
            return node;
        }
        try {
            ValueNode vn = null;
            ResultColumn parentRC = null;
            if (node instanceof ResultColumn) {
                parentRC = (ResultColumn)node;
                vn = parentRC;
            } else {
                vn = (ValueNode)node;
            }
            vn.accept(this.checkAgg);
            int before = this.expandedRCL.size();
            if (this.checkAgg.hasAggregates()) {
                vn.genExpressionOperands(this.expandedRCL, parentRC, !this.isCompilationAsDataStoreNode);
            } else if (parentRC != null) {
                this.expandedRCL.addResultColumn(parentRC);
            }
            int after = this.expandedRCL.size();
            if (parentRC != null) {
                if (!parentRC.isExpanded() && after - before > 1) {
                    parentRC.markExpanded();
                }
            } else if (this.checkAgg.hasAggregates()) {
                if (this.otherExpressions == null) {
                    this.otherExpressions = new ValueNodeList();
                }
                this.otherExpressions.addValueNode(vn);
            }
            this.numOperands.add(after - before);
        }
        finally {
            this.checkAgg.reset();
        }
        return node;
    }

    public ResultColumnList getResultColumns() {
        this.expandedRCL.resetVirtualColumnIds();
        return this.expandedRCL;
    }

    public ValueNodeList getOtherExpressions() {
        return this.otherExpressions;
    }

    public ArrayList<Integer> getNumOperands() {
        return this.numOperands;
    }
}

