/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.raw.store;

import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.db.FabricDatabase;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowSource;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.StreamContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.io.DirFile;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;

public final class FileStreamInputOutput
implements StreamContainerHandle,
ObjectOutput,
ObjectInput {
    private final DirFile file;
    private final FileChannel channel;
    private final int capacity;
    private RowSource rowSource;
    private final ExecRow templateRow;
    private ByteBuffer rwBuffer;
    private long numRows;
    private final boolean isDvdArray;
    private final boolean isArray;
    private final ArrayList<String> rowObjectsWritten;
    private int rowObjectsindex = 0;
    private final boolean diagnoseFileData = SanityManager.DEBUG_ON((String)"DiagnoseTempFileIO");
    private int totalBytesWritten;
    private int rowsWritten;
    private int totalBytesRead;
    private int rowsRead;

    public FileStreamInputOutput(long conglomId, GemFireTransaction txn, RowSource rowSource, ByteBuffer rwBuffer) throws StandardException {
        FabricDatabase db = Misc.getMemStore().getDatabase();
        this.file = db.getTempDir().createTemporaryFile(conglomId);
        this.channel = this.file.getChannel();
        this.capacity = rwBuffer.capacity();
        this.rwBuffer = rwBuffer;
        this.rwBuffer.clear();
        this.rowSource = rowSource;
        if (GemFireXDUtils.TraceTempFileIO) {
            SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)("Created temporary file : " + this.file));
        }
        ExecRow row = rowSource.getNextRowFromRowSource();
        assert (row != null) : "atleast one row is expected... ";
        this.templateRow = row.getNewNullRow();
        Object o = row.getRawRowValue(false);
        Class<?> cls = o.getClass();
        if (cls == byte[].class) {
            this.isArray = true;
            this.isDvdArray = false;
            this.rowObjectsWritten = null;
            this.writeBuffer((byte[])o);
        } else if (cls == byte[][].class) {
            this.isArray = false;
            this.isDvdArray = false;
            this.rowObjectsWritten = null;
            this.writeBuffer(((byte[][])o)[0]);
        } else if (cls == DataValueDescriptor[].class) {
            this.isArray = false;
            this.isDvdArray = true;
            this.rowObjectsWritten = this.diagnoseFileData ? new ArrayList() : null;
            this.writeDVDBuffer((DataValueDescriptor[])o);
        } else {
            SanityManager.THROWASSERT((String)"StreamFileHandler: unkown row format ");
            this.isArray = false;
            this.isDvdArray = false;
            this.rowObjectsWritten = null;
        }
        ++this.rowsWritten;
        ++this.numRows;
        this.load();
    }

    public final void load() throws StandardException {
        if (this.isArray) {
            ExecRow row;
            while ((row = this.rowSource.getNextRowFromRowSource()) != null) {
                this.writeBuffer((byte[])row.getRawRowValue(false));
                ++this.rowsWritten;
                ++this.numRows;
            }
        } else if (!this.isDvdArray) {
            ExecRow row;
            while ((row = this.rowSource.getNextRowFromRowSource()) != null) {
                this.writeBuffer(((byte[][])row.getRawRowValue(false))[0]);
                ++this.rowsWritten;
                ++this.numRows;
            }
        } else {
            ExecRow row;
            assert (this.isDvdArray);
            while ((row = this.rowSource.getNextRowFromRowSource()) != null) {
                this.writeDVDBuffer((DataValueDescriptor[])row.getRawRowValue(false));
                ++this.rowsWritten;
                ++this.numRows;
            }
        }
        try {
            this.flushNoSync(false);
            this.channel.force(true);
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSLA0.D", ioe);
        }
        finally {
            this.rowSource = null;
            this.rwBuffer.clear();
            this.rwBuffer = null;
        }
    }

    public FileStreamInputOutput(long conglomId, ByteBuffer rwBuffer) throws StandardException {
        this.rwBuffer = rwBuffer;
        this.isArray = false;
        this.isDvdArray = true;
        FabricDatabase db = Misc.getMemStore().getDatabase();
        this.file = db.getTempDir().createTemporaryFile(conglomId);
        this.channel = this.file.getChannel();
        this.rowSource = null;
        this.templateRow = null;
        this.capacity = rwBuffer.capacity();
        this.rowObjectsWritten = new ArrayList();
    }

    public final void flipToRead() throws StandardException {
        try {
            this.channel.position(0L);
            this.rwBuffer = FileStreamInputOutput.realAllocate(this.capacity);
            if (GemFireXDUtils.TraceTempFileIO) {
                SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)("Reading file : " + this.file));
            }
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSLA0.D", ioe);
        }
        this.getNextBuffer();
    }

    private final void writeBuffer(byte[] b) throws StandardException {
        int r = this.rwBuffer.remaining();
        if (r < 4) {
            try {
                this.flushNoSync(true);
            }
            catch (IOException ioe) {
                throw StandardException.newException("XSLA0.D", ioe);
            }
        }
        try {
            this.rwBuffer.putInt(b.length);
            this.write(b, 0, b.length);
        }
        catch (IOException e) {
            Throwable t = e.getCause();
            if (t instanceof StandardException) {
                throw (StandardException)t;
            }
            throw GemFireXDRuntimeException.newRuntimeException("writeBuffer:write exception", e);
        }
    }

    private final void writeDVDBuffer(DataValueDescriptor[] dvdA) throws StandardException {
        try {
            if (GemFireXDUtils.TraceTempFileIO) {
                StringBuilder sb = new StringBuilder();
                sb.append("Writing DataValueDescriptors of length ").append(dvdA.length);
                sb.append(" values ");
                StringBuilder dvdS = this.toString(dvdA, new StringBuilder());
                sb.append((CharSequence)dvdS);
                SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)sb.toString());
                if (this.diagnoseFileData) {
                    this.rowObjectsWritten.add(dvdS.toString());
                }
            }
            DataType.writeDVDArray(dvdA, this);
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSLA0.D", ioe);
        }
    }

    private final DataValueDescriptor[] readDVDBuffer() throws StandardException {
        try {
            if (!this.diagnoseFileData) {
                return DataType.readDVDArray(this);
            }
            DataValueDescriptor[] dvd = DataType.readDVDArray(this);
            if (GemFireXDUtils.TraceTempFileIO) {
                String srcDvd = this.rowObjectsWritten.get(this.rowObjectsindex++);
                String dvdS = this.toString(dvd, new StringBuilder()).toString();
                SanityManager.ASSERT((boolean)srcDvd.equals(dvdS), (String)(srcDvd + " != " + dvdS));
            }
            return dvd;
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSLA0.D", ioe);
        }
        catch (ClassNotFoundException cnf) {
            throw StandardException.newException("XSLA0.D", cnf);
        }
    }

    private final boolean checkWriteBounds(int expected, boolean isByteArray) throws IOException {
        if (this.rwBuffer.remaining() >= expected) {
            return true;
        }
        if (isByteArray) {
            return false;
        }
        if (GemFireXDUtils.TraceTempFileIO) {
            SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)("[" + this.file + "] flushing the current buffer as remaining " + this.rwBuffer.remaining() + " doesn't fits expected ... " + expected));
        }
        this.flushNoSync(!isByteArray);
        return this.rwBuffer.remaining() >= expected;
    }

    private final void checkReadBounds(int expected) throws IOException {
        if (this.rwBuffer.remaining() >= expected) {
            return;
        }
        if (GemFireXDUtils.TraceTempFileIO) {
            SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)("[" + this.file + "] moving onto next buffer as remaining " + this.rwBuffer.remaining() + " doesn't fits expected " + expected));
        }
        this.getNextBuffer();
        assert (this.rwBuffer.remaining() >= expected) : "remaining=" + this.rwBuffer.remaining() + " expected=" + expected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void flushNoSync(boolean withBytePadding) throws IOException {
        try {
            if (withBytePadding) {
                for (int i = this.rwBuffer.remaining(); i > 0; --i) {
                    this.rwBuffer.put((byte)-128);
                }
            }
            this.rwBuffer.flip();
            do {
                assert (this.rwBuffer.capacity() != 0);
                int byteswritten = this.channel.write(this.rwBuffer);
                assert (byteswritten > 0);
                this.totalBytesWritten += byteswritten;
                if (GemFireXDUtils.TraceTempFileIO) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Written [").append(this.file).append("] ");
                    sb.append(byteswritten).append(" bytes totaling ").append(this.totalBytesWritten).append(" bytes constituting rows ").append(this.rowsWritten).append(" total rows rises to ").append(this.numRows);
                    if (this.diagnoseFileData) {
                        sb.append("\n buffer [").append(this.rwBuffer).append(" ").append(this.rwBuffer.hasArray() ? Arrays.toString(this.rwBuffer.array()) : "<direct buffer>").append(" ] ");
                    }
                    SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)sb.toString());
                }
                this.rowsWritten = 0;
            } while (this.rwBuffer.hasRemaining());
        }
        finally {
            this.rwBuffer.clear();
        }
        assert (this.rwBuffer.remaining() == this.rwBuffer.capacity());
        assert (this.rwBuffer.position() == 0);
    }

    private final void getNextBuffer() {
        this.rwBuffer = this.file.getReadBuffer(this.capacity, this.rwBuffer);
        this.totalBytesRead += this.file.bytesRead();
        if (GemFireXDUtils.TraceTempFileIO) {
            StringBuilder sb = new StringBuilder();
            sb.append("Read [").append(this.file).append("] ");
            sb.append(this.file.bytesRead()).append(" bytes totaling ").append(this.totalBytesRead).append(" bytes out of ").append(this.totalBytesWritten).append(" rows remaining ").append(this.numRows).append(", rows read on last file read ").append(this.rowsRead);
            if (this.diagnoseFileData) {
                sb.append("\n buffer [").append(this.rwBuffer).append(" ").append(this.rwBuffer.hasArray() ? Arrays.toString(this.rwBuffer.array()) : "<direct buffer>").append(" ] ");
            }
            SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)sb.toString());
        }
        this.rowsRead = 0;
    }

    @Override
    public void close() {
        try {
            this.channel.close();
            this.file.delete();
            if (this.rowSource != null) {
                this.rowSource.closeRowSource();
            }
            this.rwBuffer = null;
        }
        catch (IOException e) {
            throw GemFireXDRuntimeException.newRuntimeException("FileStreamInputOutput:close Unexpected IOException ", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean fetchNext(ExecRow row) throws StandardException {
        block10: {
            if (this.numRows-- <= 0L) {
                if (GemFireXDUtils.TraceTempFileIO) {
                    SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)("Returned all rows from file " + this.file));
                }
                return false;
            }
            if (!this.isArray && this.isDvdArray) break block10;
            remaining = this.rwBuffer.remaining();
            if (remaining >= 4) {
                bytelength = this.rwBuffer.getInt();
            } else {
                this.getNextBuffer();
                bytelength = this.rwBuffer.getInt();
            }
            db = new byte[bytelength];
            r = (AbstractCompactExecRow)row;
            try {
                this.readFully(db, 0, bytelength);
            }
            catch (IOException e) {
                t = e.getCause();
                if (t instanceof StandardException) {
                    throw (StandardException)t;
                }
                throw GemFireXDRuntimeException.newRuntimeException("FileStreamInputOutput:fetchNext exception", e);
            }
            rf = r.getRowFormatter();
            if (!rf.isTableFormatter()) ** GOTO lbl-1000
            container = rf.container;
            if (container.singleSchema == null) {
                r.setRowArray(db, container.getRowFormatter(db));
            } else lbl-1000:
            // 2 sources

            {
                r.setRowArray(db, rf);
            }
            ++this.rowsRead;
            return true;
        }
        this.rwBuffer.remaining();
        if (!FileStreamInputOutput.$assertionsDisabled && !this.isDvdArray) {
            throw new AssertionError();
        }
        row.setRowArray(this.readDVDBuffer());
        ++this.rowsRead;
        return true;
    }

    @Override
    public void getContainerProperties(Properties prop) throws StandardException {
    }

    public static final ByteBuffer allocateBuffer(int targetSize, TransactionController tc) throws StandardException {
        int size;
        String pValue = PropertyUtil.getServiceProperty(tc, "gemfirexd.storage.streamFileBufferSize");
        int configuredSz = PropertyUtil.handleInt(pValue, 1024, Integer.MAX_VALUE, 16384);
        int n = size = targetSize == 0 || targetSize > configuredSz ? configuredSz : targetSize;
        assert (size > 0) : "size=" + size + "targetSize=" + targetSize + " configuredSz=" + configuredSz + " pValue=" + pValue;
        return FileStreamInputOutput.realAllocate(size);
    }

    private static final ByteBuffer realAllocate(int size) {
        return ByteBuffer.allocate(size);
    }

    @Override
    public ContainerKey getId() {
        SanityManager.THROWASSERT((String)"FileStreamInputOutput:getId: shouldn't be called... ");
        return null;
    }

    @Override
    public void removeContainer() throws StandardException {
        SanityManager.THROWASSERT((String)"FileStreamInputOutput:removeContainer: shouldn't be called... ");
    }

    @Override
    public ExecRow getTemplateRow() {
        return this.templateRow;
    }

    private StringBuilder toString(DataValueDescriptor[] dvd, StringBuilder sb) throws StandardException {
        for (int i = 0; i < dvd.length; ++i) {
            sb.append(dvd[i].getString()).append("(").append(dvd[i].getTypeName()).append("),");
        }
        return sb;
    }

    @Override
    public final void write(int b) throws IOException {
        this.checkWriteBounds(1, false);
        this.rwBuffer.put((byte)b);
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        if (this.checkWriteBounds(len, true)) {
            this.rwBuffer.put(b, off, len);
            return;
        }
        int remaining = this.rwBuffer.remaining();
        do {
            if (len < remaining) {
                this.rwBuffer.put(b, off, len);
                return;
            }
            this.rwBuffer.put(b, off, remaining);
            off += remaining;
            remaining = this.rwBuffer.capacity();
            this.flushNoSync(false);
        } while ((len -= remaining) > 0);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.checkWriteBounds(1, false);
        this.rwBuffer.put((byte)(v ? 1 : 0));
    }

    @Override
    public void writeByte(int v) throws IOException {
        boolean hasSpace = this.checkWriteBounds(1, false);
        assert (hasSpace) : "BufferOverflowException will occur " + this.rwBuffer.position() + " " + this.rwBuffer.capacity() + " " + this.rwBuffer.limit();
        this.rwBuffer.put((byte)v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        SanityManager.THROWASSERT((String)"FileStreamInputOutput:writeBytes: String overload not allowed... ");
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.checkWriteBounds(2, false);
        this.rwBuffer.putChar((char)v);
    }

    @Override
    public void writeChars(String s) throws IOException {
        SanityManager.THROWASSERT((String)"FileStreamInputOutput:writeChars: String overload not allowed... ");
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.checkWriteBounds(8, false);
        this.rwBuffer.putDouble(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.checkWriteBounds(4, false);
        this.rwBuffer.putFloat(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.checkWriteBounds(4, false);
        this.rwBuffer.putInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.checkWriteBounds(8, false);
        this.rwBuffer.putLong(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.checkWriteBounds(2, false);
        this.rwBuffer.putShort((short)v);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        SanityManager.THROWASSERT((String)"FileStreamInputOutput:writeUTF: String overload not allowed... ");
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.checkReadBounds(1);
        return this.rwBuffer.get() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        this.checkReadBounds(1);
        return this.rwBuffer.get();
    }

    @Override
    public char readChar() throws IOException {
        this.checkReadBounds(2);
        return this.rwBuffer.getChar();
    }

    @Override
    public double readDouble() throws IOException {
        this.checkReadBounds(8);
        return this.rwBuffer.getDouble();
    }

    @Override
    public float readFloat() throws IOException {
        this.checkReadBounds(4);
        return this.rwBuffer.getFloat();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        int remaining = this.rwBuffer.remaining();
        if (remaining >= len) {
            this.rwBuffer.get(b, off, len);
            return;
        }
        while (len > 0) {
            if (remaining >= len) {
                this.rwBuffer.get(b, off, len);
                return;
            }
            this.rwBuffer.get(b, off, remaining);
            off += remaining;
            len -= remaining;
            this.getNextBuffer();
            remaining = this.rwBuffer.capacity();
        }
    }

    @Override
    public int readInt() throws IOException {
        this.checkReadBounds(4);
        return this.rwBuffer.getInt();
    }

    @Override
    public String readLine() throws IOException {
        SanityManager.THROWASSERT((String)"FileStreamInputOutput:readLine: String overload not allowed... ");
        return null;
    }

    @Override
    public long readLong() throws IOException {
        this.checkReadBounds(8);
        return this.rwBuffer.getLong();
    }

    @Override
    public short readShort() throws IOException {
        this.checkReadBounds(2);
        return this.rwBuffer.getShort();
    }

    @Override
    public String readUTF() throws IOException {
        SanityManager.THROWASSERT((String)"FileStreamInputOutput:readUTF: String overload not allowed... ");
        return null;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.checkReadBounds(1);
        return this.rwBuffer.get() & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.checkReadBounds(2);
        return this.rwBuffer.getShort() & 0xFFFF;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        SanityManager.THROWASSERT((String)"FileStreamInputOutput:skipBytes:unexpected operation... ");
        return 0;
    }

    @Override
    public void flush() throws IOException {
        SanityManager.THROWASSERT((String)"FileStreamInputOutput:flush:unexpected operation... ");
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        SanityManager.THROWASSERT((String)"FileStreamInputOutput:writeObject:unexpected operation... ");
    }

    @Override
    public int available() throws IOException {
        return this.rwBuffer.remaining();
    }

    @Override
    public int read() throws IOException {
        SanityManager.THROWASSERT((String)"FileStreamInputOutput:read:unexpected operation... ");
        return 0;
    }

    @Override
    public int read(byte[] b) throws IOException {
        SanityManager.THROWASSERT((String)"FileStreamInputOutput:read(byte[]):unexpected operation... ");
        return 0;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        SanityManager.THROWASSERT((String)"FileStreamInputOutput:read(byte[], off, len):unexpected operation... ");
        return 0;
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        SanityManager.THROWASSERT((String)"FileStreamInputOutput:readObject:unexpected operation... ");
        return null;
    }

    @Override
    public long skip(long n) throws IOException {
        SanityManager.THROWASSERT((String)"FileStreamInputOutput:skip:unexpected operation... ");
        return 0L;
    }

    public void flushAndSync(boolean isByteArray) throws StandardException, IOException {
        this.flushNoSync(!isByteArray);
        this.channel.force(true);
    }
}

