/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.procedure.coordinate;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.UserDataValue;
import com.pivotal.gemfirexd.internal.impl.sql.GenericParameterValueSet;
import com.pivotal.gemfirexd.procedure.ProcedureResultProcessor;

public class ProxyParameterValueSet
implements ParameterValueSet {
    private Activation activation;
    private GenericParameterValueSet pvs;
    volatile boolean ready;
    private ProcedureResultProcessor prp;

    ProxyParameterValueSet(Activation activation, GenericParameterValueSet pvs, ProcedureResultProcessor prp) {
        this.activation = activation;
        this.pvs = pvs;
        this.prp = prp;
    }

    @Override
    public int allAreSet() {
        return this.pvs.allAreSet();
    }

    @Override
    public boolean checkNoDeclaredOutputParameters() {
        return this.pvs.checkNoDeclaredOutputParameters();
    }

    @Override
    public void clearParameters() {
        this.pvs.clearParameters();
    }

    @Override
    public ParameterValueSet getClone() {
        this.checkReady();
        return this.pvs.getClone();
    }

    @Override
    public DataValueDescriptor getParameter(int position) throws StandardException {
        this.checkReady();
        return this.pvs.getParameter(position);
    }

    @Override
    public int getParameterCount() {
        return this.pvs.getParameterCount();
    }

    @Override
    public DataValueDescriptor getParameterForGet(int position) throws StandardException {
        this.checkReady();
        return this.pvs.getParameterForGet(position);
    }

    @Override
    public DataValueDescriptor getParameterForSet(int position) throws StandardException {
        this.checkReady();
        return this.pvs.getParameterForSet(position);
    }

    @Override
    public short getParameterMode(int parameterIndex) {
        return this.pvs.getParameterMode(parameterIndex);
    }

    @Override
    public int getPrecision(int parameterIndex) {
        this.checkReady();
        return this.pvs.getPrecision(parameterIndex);
    }

    @Override
    public DataValueDescriptor getReturnValueForSet() throws StandardException {
        this.checkReady();
        return this.pvs.getReturnValueForSet();
    }

    @Override
    public int getScale(int parameterIndex) {
        this.checkReady();
        return this.pvs.getScale(parameterIndex);
    }

    @Override
    public boolean hasReturnOutputParameter() {
        return this.pvs.hasReturnOutputParameter();
    }

    @Override
    public void initialize(DataTypeDescriptor[] types) throws StandardException {
        this.pvs.initialize(types);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws StandardException {
        this.pvs.registerOutParameter(parameterIndex, sqlType, scale);
    }

    @Override
    public void setParameterAsObject(int parameterIndex, Object value) throws StandardException {
        this.pvs.setParameterAsObject(parameterIndex, value);
    }

    @Override
    public void setParameterMode(int position, int mode) {
        this.pvs.setParameterMode(position, mode);
    }

    @Override
    public void transferDataValues(ParameterValueSet pvstarget) throws StandardException {
        this.pvs.transferDataValues(pvstarget);
    }

    @Override
    public void validate() throws StandardException {
        this.pvs.validate();
    }

    /*
     * Loose catch block
     */
    private void checkReady() {
        if (this.ready) {
            return;
        }
        while (true) {
            try {
                Object[] parameters = this.prp.getOutParameters();
                if (parameters == null) {
                    this.ready = true;
                    return;
                }
                DataValueFactory dvf = this.activation.getDataValueFactory();
                int index = 0;
                int numParameters = this.pvs.getParameterCount();
                for (int i = 1; i <= numParameters; ++i) {
                    short mode = this.pvs.getParameterMode(i);
                    if (mode != 2 && mode != 4) continue;
                    DataValueDescriptor param = this.pvs.getParameter(i - 1);
                    assert (param != null) : "the dvd should not be null!";
                    Object val = parameters[index];
                    if (val == null) {
                        param.setToNull();
                    } else {
                        UserDataValue dvd = dvf.getDataValue(val);
                        param.setValue(dvd);
                    }
                    ++index;
                }
                this.ready = true;
                return;
            }
            catch (InterruptedException parameters) {
                continue;
            }
            break;
        }
        catch (StandardException e) {
            throw new AssertionError((Object)"Error happens in the checkReady() in the ProxyParameterValueSet!");
        }
    }

    @Override
    public boolean isListOfConstants() {
        return this.pvs.isListOfConstants();
    }

    @Override
    public boolean canReleaseOnClose() {
        return this.pvs.canReleaseOnClose();
    }
}

