/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.procedure.coordinate;

import com.pivotal.gemfirexd.internal.catalog.AliasInfo;
import com.pivotal.gemfirexd.internal.catalog.types.SynonymAliasInfo;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassInspector;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.AliasDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;

public class ProcedureProcessorNode
extends QueryTreeNode {
    private String className;
    private String aliasName;
    private boolean defaultProcessor = false;

    @Override
    public void init(Object arg1, Object arg2) throws StandardException {
        this.className = (String)arg1;
        this.aliasName = (String)arg2;
    }

    public void bindExpression(DataDictionary dd) throws StandardException {
        this.className = this.getClassName(dd);
        if (this.className != null) {
            ClassInspector ci = this.getClassFactory().getClassInspector();
            try {
                if (!ci.accessible(this.className)) {
                    throw StandardException.newException("42X51", this.className);
                }
            }
            catch (ClassNotFoundException e) {
                throw StandardException.newException("42X51", this.className);
            }
            if (!ci.assignableTo(this.className, "com.pivotal.gemfirexd.procedure.ProcedureResultProcessor")) {
                throw StandardException.newException("X0Z17.S", (Object)this.className, (Object)"com.pivotal.gemfirexd.procedure.ProcedureResultProcessor");
            }
        } else {
            this.defaultProcessor = true;
        }
    }

    private String getClassName(DataDictionary dd) throws StandardException {
        if (this.className != null) {
            return this.className;
        }
        if (this.aliasName != null) {
            SchemaDescriptor sd = Misc.getLanguageConnectionContext().getDefaultSchema();
            AliasDescriptor ad = dd.getAliasDescriptor(sd.getUUID().toString(), this.aliasName, 'R');
            if (ad == null) {
                this.className = this.aliasName;
                this.aliasName = null;
                return this.className;
            }
            AliasInfo ainfo = ad.getAliasInfo();
            assert (ainfo != null);
            assert (ainfo instanceof SynonymAliasInfo) : "alias info type is: " + ainfo.getClass();
            this.className = ((SynonymAliasInfo)ainfo).getSynonymTable();
        }
        return this.className;
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.defaultProcessor) {
            acb.pushThisAsActivation(mb);
            mb.callMethod((short)185, null, "getExecutionFactory", "com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory", 0);
            mb.callMethod((short)185, null, "getDefaultProcedureResultProcessor", "com.pivotal.gemfirexd.procedure.ProcedureResultProcessor", 0);
        } else {
            mb.pushNewStart(this.className);
            mb.pushNewComplete(0);
            mb.upCast("com.pivotal.gemfirexd.procedure.ProcedureResultProcessor");
        }
    }
}

