/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.procedure.cohort;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.ColocationHelper;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.procedure.cohort.ProcedureSender;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.ProxyResultDescription;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.ConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ResultSetFactory;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation;
import com.pivotal.gemfirexd.procedure.OutgoingResultSet;
import com.pivotal.gemfirexd.procedure.ProcedureExecutionContext;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public final class ProcedureExecutionContextImpl
implements ProcedureExecutionContext {
    private final BaseActivation activation;
    private final ProcedureSender procedureSender;
    private final ResultSet[][] dynamicResultSets;
    private final String tableName;
    private final String procedureName;
    private final ResultSetFactory rsFactory;
    private final ConnectionContext cc;
    private Region region;
    private final boolean isPossDup;
    private final String whereClause;
    private ArrayList<Connection> nestedConnsList;
    EmbedConnection parentConn;
    private int batchSize;

    public ProcedureExecutionContextImpl(Activation activation, ProcedureSender sender, String whereClause, boolean isPossibleDup, ResultSet[][] dynamicResultSets, String tableName, String procedureName) {
        this.activation = (BaseActivation)activation;
        this.dynamicResultSets = dynamicResultSets;
        this.tableName = tableName;
        this.procedureName = procedureName;
        this.whereClause = whereClause;
        this.isPossDup = isPossibleDup;
        this.rsFactory = this.activation.getExecutionFactory().getResultSetFactory();
        this.procedureSender = sender;
        if (this.procedureSender != null) {
            this.parentConn = this.procedureSender.setProcedureExecutionContext(this);
        }
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        ContextManager cm = lcc.getContextManager();
        this.cc = (ConnectionContext)((Object)cm.getContext("JDBC_ConnectionContext"));
    }

    @Override
    public String[] getColocatedTableNames() {
        Map map;
        if (this.tableName != null) {
            this.region = Misc.getRegionForTable(this.tableName, false);
        }
        if (this.region != null && this.region.getAttributes().getDataPolicy().withPartitioning() && (map = ColocationHelper.getAllColocationRegions((PartitionedRegion)((PartitionedRegion)this.region))) != null) {
            String[] ret = new String[map.size()];
            Iterator itr = map.keySet().iterator();
            int i = -1;
            while (itr.hasNext()) {
                String fpath = (String)itr.next();
                String[] parts = fpath.split("/");
                assert (parts.length == 2);
                ret[i++] = parts[0] + "." + parts[1];
            }
            if (ret.length > 0) {
                return ret;
            }
        }
        return null;
    }

    @Override
    public Connection getConnection() {
        Connection conn = null;
        try {
            if (this.parentConn != null) {
                conn = this.parentConn.getLocalDriver().getNewNestedConnection(this.parentConn);
            } else if (this.cc != null) {
                conn = this.cc.getNestedConnection(true);
            }
            if (conn != null) {
                if (this.nestedConnsList == null) {
                    this.nestedConnsList = new ArrayList();
                }
                this.nestedConnsList.add(conn);
            }
        }
        catch (SQLException e) {
            Misc.getCacheLogWriter().warning("could not get nested connection", (Throwable)e);
        }
        return conn;
    }

    public ArrayList<Connection> getNestedConnectionList() {
        return this.nestedConnsList;
    }

    @Override
    public String getFilter() {
        return this.whereClause;
    }

    @Override
    public OutgoingResultSet getOutgoingResultSet(int rsNumber) {
        ResultSet embedResultSet;
        int number;
        int n = number = this.dynamicResultSets != null ? this.dynamicResultSets.length : 0;
        if (number == 0) {
            return null;
        }
        if (rsNumber < 1 || rsNumber > number) {
            throw new AssertionError((Object)("The result set number is not between 1 and " + number));
        }
        int resultSetNumber = rsNumber - 1;
        ResultSet oldResultSet = this.dynamicResultSets[resultSetNumber][0];
        if (oldResultSet != null) {
            throw new AssertionError((Object)(" The " + resultSetNumber + " result set has been set!"));
        }
        ProxyResultDescription rd = new ProxyResultDescription(false);
        this.activation.switchResultDescription(rd);
        OutgoingResultSet resultSet = this.rsFactory.getOutgoingResultSet(this.activation, resultSetNumber, rd);
        try {
            embedResultSet = this.cc.getResultSet((com.pivotal.gemfirexd.internal.iapi.sql.ResultSet)((Object)resultSet));
        }
        catch (SQLException e) {
            throw new AssertionError((Object)"Cannot allocate a outgoing result set!");
        }
        this.dynamicResultSets[resultSetNumber][0] = embedResultSet;
        if (this.procedureSender != null) {
            this.procedureSender.addOutgoingResultSet(resultSet);
        }
        return resultSet;
    }

    @Override
    public String getProcedureName() {
        return this.procedureName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public boolean isPartitioned(String tableName) {
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("ProcedureExecutionContextImpl::isPartitioned tableName passed is either null or empty");
        }
        Region reg = Misc.getRegionForTableByPath(tableName, true);
        if (reg == null) {
            throw new IllegalArgumentException("ProcedureExecutionContextImpl::isPartitioned no region found corresponding to the tableName: " + tableName);
        }
        return reg.getAttributes().getDataPolicy().withPartitioning();
    }

    @Override
    public boolean isPossibleDuplicate() {
        return this.isPossDup;
    }

    @Override
    public void checkQueryCancelled() throws SQLException {
        BaseActivation act = this.activation;
        if (act != null && act.isQueryCancelled()) {
            try {
                act.checkCancellationFlag();
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
    }
}

