/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.procedure;

import com.gemstone.gemfire.DataSerializer;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class ProcedureChunkMessage
extends GfxdDataSerializable
implements Serializable {
    private static final long serialVersionUID = -1977996002198903592L;
    public static final byte UNKNOWN_TYPE = 0;
    public static final byte OUT_PARAMETER = 1;
    public static final byte META_DATA = 2;
    public static final byte RESULTSET = 3;
    public static final byte PROCEDURE_END = 4;
    public static final String[] typeName = new String[]{"Unknown type", "Out parameter", "Meta data", "Resultset", "Procedure end"};
    private byte type;
    private int resultSetNumber;
    private boolean lastChunk;
    private int seqNumber;
    private int prevSeqNumber;
    private transient int colNumber;
    private transient int rowNumber;
    private transient ArrayList<List<Object>> chunks;

    public ProcedureChunkMessage() {
        this.chunks = null;
        this.colNumber = 0;
        this.resultSetNumber = -1;
        this.rowNumber = 0;
        this.type = 0;
        this.lastChunk = false;
    }

    public ProcedureChunkMessage(byte type) {
        this.chunks = null;
        this.colNumber = 0;
        this.resultSetNumber = -1;
        this.rowNumber = 0;
        this.type = type;
        this.lastChunk = false;
    }

    public ProcedureChunkMessage(byte type, int resultSetNumber, ArrayList<List<Object>> chunks) {
        this.type = type;
        this.resultSetNumber = resultSetNumber;
        this.chunks = chunks;
        this.lastChunk = false;
        if (this.chunks == null || this.chunks.size() == 0) {
            this.colNumber = 0;
            this.rowNumber = 0;
        } else {
            this.rowNumber = this.chunks.size();
            this.colNumber = this.chunks.get(0).size();
        }
    }

    public final int getSeqNumber() {
        return this.seqNumber;
    }

    public final void setSeqNumber(int seqNumber) {
        this.seqNumber = seqNumber;
    }

    public final int getPrevSeqNumber() {
        return this.prevSeqNumber;
    }

    public final void setPrevSeqNumber(int prevSeqNumber) {
        this.prevSeqNumber = prevSeqNumber;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public int getColumnNumber() {
        return this.colNumber;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public ArrayList<List<Object>> getChunks() {
        return this.chunks;
    }

    public void setChunks(ArrayList<List<Object>> chunks) {
        this.chunks = chunks;
    }

    public int getResultSetNumber() {
        return this.resultSetNumber;
    }

    public void setResultSetNumber(int resultSetNumber) {
        this.resultSetNumber = resultSetNumber;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.type = in.readByte();
        this.resultSetNumber = in.readInt();
        this.rowNumber = in.readInt();
        this.colNumber = in.readInt();
        this.lastChunk = in.readBoolean();
        this.seqNumber = in.readInt();
        this.prevSeqNumber = in.readInt();
        this.chunks = new ArrayList();
        for (int rowIndex = 0; rowIndex < this.rowNumber; ++rowIndex) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (int colIndex = 0; colIndex < this.colNumber; ++colIndex) {
                row.add(DataSerializer.readObject((DataInput)in));
            }
            this.chunks.add(row);
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer != null) {
            observer.beforeProcedureChunkMessageSend(this);
        }
        out.writeByte(this.type);
        out.writeInt(this.resultSetNumber);
        out.writeInt(this.rowNumber);
        out.writeInt(this.colNumber);
        out.writeBoolean(this.lastChunk);
        out.writeInt(this.seqNumber);
        out.writeInt(this.prevSeqNumber);
        for (int rowIndex = 0; rowIndex < this.rowNumber; ++rowIndex) {
            List<Object> row = this.chunks.get(rowIndex);
            for (int colIndex = 0; colIndex < this.colNumber; ++colIndex) {
                DataSerializer.writeObject((Object)row.get(colIndex), (DataOutput)out);
            }
        }
    }

    public void setLast() {
        this.lastChunk = true;
    }

    public boolean isLast() {
        return this.lastChunk;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("ResultSetID=").append(this.resultSetNumber);
        str.append(";Type=").append(typeName[this.type]);
        str.append(";PrevSeq=").append(this.prevSeqNumber);
        str.append(";CurrentSeq=").append(this.seqNumber);
        if (this.chunks != null) {
            int rowIndex = 0;
            for (List<Object> row : this.chunks) {
                str.append(" row#" + rowIndex);
                for (Object o : row) {
                    str.append(" " + o);
                }
                ++rowIndex;
            }
        }
        return str.toString();
    }

    @Override
    public byte getGfxdID() {
        return 20;
    }
}

