/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.procedure;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionInvocationTargetException;
import com.gemstone.gemfire.internal.shared.Version;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.procedure.cohort.ProcedureSender;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericParameterValueSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class DistributedProcedureCallFunction
implements Function,
Declarable {
    public static final String FUNCTIONID = "gfxd-DistributedProcedureCallFunction";

    public void init(Properties props) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FunctionContext context) {
        DistributedProcedureCallFunctionArgs arguments = (DistributedProcedureCallFunctionArgs)context.getArguments();
        String sqlText = "<COHORT> " + arguments.sqlText;
        ProcedureSender sender = null;
        long connectionId = arguments.connectionId;
        long timeOutMillis = arguments.timeOutMillis;
        long stmtId = arguments.stmtId;
        Properties props = arguments.props;
        EmbedConnection conn = null;
        GfxdConnectionWrapper wrapper = null;
        int syncVersion = -1;
        String whereClause = arguments.getWhereClause();
        String tableName = arguments.getTableName();
        boolean isPossibleDuplicate = false;
        if (context instanceof RegionFunctionContext) {
            isPossibleDuplicate = ((RegionFunctionContext)context).isPossibleDuplicate();
        }
        Object thr = null;
        GemFireTransaction tc = null;
        TXStateInterface tx = null;
        Activation act = null;
        try {
            if (GemFireXDUtils.TraceQuery) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("DistributedProcedureCallFunction: executing procedure with arguments [" + arguments + "] posDup=" + isPossibleDuplicate));
            }
            String defaultSchema = arguments.defaultSchema;
            tx = TXManagerImpl.getCurrentTXState();
            wrapper = GfxdConnectionHolder.getOrCreateWrapper(defaultSchema, connectionId, false, props);
            conn = wrapper.getConnectionForSynchronization();
            Object object = conn.getConnectionSynchronization();
            synchronized (object) {
                syncVersion = wrapper.convertToHardReference(conn);
                tc = (GemFireTransaction)conn.getLanguageConnection().getTransactionExecute();
                GfxdConnectionWrapper.checkForTransaction(conn, tc, tx);
                EmbedStatement statement = wrapper.getStatement(sqlText, stmtId, true, false, false, false, null, true, 0L, 0);
                statement.setQueryTimeout((int)(timeOutMillis / 1000L));
                EmbedPreparedStatement ps = (EmbedPreparedStatement)statement;
                sender = new ProcedureSender(context.getResultSender(), conn);
                sender.initialize();
                act = ps.getActivation();
                GenericParameterValueSet pvs = (GenericParameterValueSet)ps.getParms();
                act.setProcedureSender(sender);
                act.setPossibleDuplicate(isPossibleDuplicate);
                pvs.setWhereClause(whereClause);
                pvs.setTableName(tableName);
                DataValueDescriptor[] parameters = arguments.parameterValues;
                int[][] parameterInfo = arguments.getParameterInfo();
                int parametersNum = pvs.getParameterCount();
                for (int i = 0; i < parametersNum; ++i) {
                    short mode = pvs.getParameterMode(i + 1);
                    if (mode == 2 || mode == 4) {
                        pvs.registerOutParameter(i, parameterInfo[i][0], parameterInfo[i][1]);
                    }
                    if (mode != 2 && mode != 1) continue;
                    pvs.getParameterForSet(i).setValue(parameters[i]);
                }
                ps.execute();
                GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
                do {
                    ResultSet rs;
                    if (act.isQueryCancelled()) {
                        act.checkCancellationFlag();
                    }
                    if ((rs = statement.getResultSet()) == null) break;
                    EmbedResultSet embedRS = (EmbedResultSet)rs;
                    if (embedRS.isOutgoingResultSet()) continue;
                    if (observer != null) {
                        if (!observer.beforeProcedureResultSetSend(sender, embedRS)) continue;
                        sender.sendResultSet(embedRS);
                        continue;
                    }
                    sender.sendResultSet(embedRS);
                } while (statement.getMoreResults());
                if (observer != null) {
                    if (observer.beforeProcedureOutParamsSend(sender, pvs)) {
                        sender.sendOutParameters(pvs);
                    }
                } else {
                    sender.sendOutParameters(pvs);
                }
            }
        }
        catch (Throwable ex) {
            Error err;
            if (ex instanceof Error && SystemFailure.isJVMFailureError((Error)(err = (Error)ex))) {
                SystemFailure.initiateFailure((Error)err);
                throw err;
            }
            if (GemFireXDUtils.TraceQuery) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("DistributedProcedureCallFunction: exception for procedure: " + sqlText), (Throwable)ex);
            }
            if (GemFireXDUtils.retryToBeDone(ex)) {
                thr = new InternalFunctionInvocationTargetException(ex);
            }
            String cancelInProgress = null;
            GemFireCacheImpl cache = null;
            cache = Misc.getGemFireCacheNoThrow();
            if (cache != null) {
                cancelInProgress = cache.getCancelCriterion().cancelInProgress();
                if (cancelInProgress != null) {
                    thr = new CacheClosedException(cancelInProgress, ex);
                }
                if (ex instanceof FunctionException) {
                    thr = (FunctionException)ex;
                }
                thr = new FunctionException(ex);
            }
            thr = new CacheClosedException();
        }
        finally {
            try {
                if (sender != null && thr == null) {
                    sender.endProcedureCall();
                    if (wrapper != null && !wrapper.isClosed()) {
                        try {
                            wrapper.closeStatement(stmtId);
                        }
                        catch (SQLException e) {
                            if (GemFireXDUtils.TraceQuery) {
                                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("DistributedProcedureCallFunction: Ignored exception while closing statement: " + sqlText), (Throwable)e);
                            }
                        }
                    }
                }
            }
            finally {
                if (act != null) {
                    act.setProcedureSender(null);
                    act.setPossibleDuplicate(false);
                }
                if (tc != null) {
                    tc.resetTXState();
                }
                if (wrapper != null && !wrapper.isClosed() && wrapper.convertToSoftReference(syncVersion)) {
                    wrapper.markUnused();
                }
            }
            if (thr != null) {
                throw thr;
            }
        }
    }

    public static DistributedProcedureCallFunctionArgs newDistributedProcedureCallFunctionArgs(String sqlText, String whereClause, String tableName, String defaultSchema, long connId, DataValueDescriptor[] parameterValues, int[][] parameterInfo, Properties props, long timeOutMillis, long stmtId) {
        return new DistributedProcedureCallFunctionArgs(sqlText, whereClause, tableName, defaultSchema, connId, parameterValues, parameterInfo, props, timeOutMillis, stmtId);
    }

    public String getId() {
        return FUNCTIONID;
    }

    public boolean hasResult() {
        return true;
    }

    public boolean isHA() {
        return true;
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public static final class DistributedProcedureCallFunctionArgs
    extends GfxdDataSerializable
    implements Serializable {
        String sqlText;
        String whereClause;
        String tableName;
        String defaultSchema;
        DataValueDescriptor[] parameterValues;
        int[][] parameterInfo;
        private long connectionId;
        private long timeOutMillis;
        private long stmtId;
        private Properties props;
        private static final Version[] serializationVersions = new Version[]{Version.GFXD_101};

        public DistributedProcedureCallFunctionArgs() {
        }

        DistributedProcedureCallFunctionArgs(String sqlText, String whereClause, String tableName, String defaultSchema, long connId, DataValueDescriptor[] parameterValues, int[][] parameterInfo, Properties props, long timeOutMillis, long stmtId) {
            this.sqlText = sqlText;
            this.whereClause = whereClause;
            this.tableName = tableName;
            this.defaultSchema = defaultSchema;
            if (parameterValues != null) {
                for (DataValueDescriptor dvd : parameterValues) {
                    dvd.setRegionContext(null);
                }
            }
            this.parameterValues = parameterValues;
            this.parameterInfo = parameterInfo;
            this.connectionId = connId;
            this.timeOutMillis = timeOutMillis;
            this.stmtId = stmtId;
            this.props = props;
        }

        @Override
        public Version[] getSerializationVersions() {
            return serializationVersions;
        }

        public String getSqlText() {
            return this.sqlText;
        }

        public String getWhereClause() {
            return this.whereClause;
        }

        public String getTableName() {
            return this.tableName;
        }

        public DataValueDescriptor[] getParameterValues() {
            return this.parameterValues;
        }

        public int[][] getParameterInfo() {
            return this.parameterInfo;
        }

        @Override
        public byte getGfxdID() {
            return 95;
        }

        public void fromDataPre_GFXD_1_0_1_0(DataInput in) throws IOException, ClassNotFoundException {
            int i;
            super.fromData(in);
            this.sqlText = DataSerializer.readString((DataInput)in);
            this.whereClause = DataSerializer.readString((DataInput)in);
            this.tableName = DataSerializer.readString((DataInput)in);
            this.defaultSchema = DataSerializer.readString((DataInput)in);
            this.connectionId = GemFireXDUtils.readCompressedHighLow(in);
            this.props = (Properties)DataSerializer.readObject((DataInput)in);
            int parameterNumber = in.readInt();
            this.parameterValues = new DataValueDescriptor[parameterNumber];
            for (i = 0; i < parameterNumber; ++i) {
                this.parameterValues[i] = DataType.readDVD(in);
            }
            this.parameterInfo = new int[parameterNumber][3];
            for (i = 0; i < parameterNumber; ++i) {
                this.parameterInfo[i][0] = in.readInt();
                this.parameterInfo[i][1] = in.readInt();
                this.parameterInfo[i][2] = in.readInt();
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.fromDataPre_GFXD_1_0_1_0(in);
            this.timeOutMillis = GemFireXDUtils.readCompressedHighLow(in);
            this.stmtId = GemFireXDUtils.readCompressedHighLow(in);
        }

        public void toDataPre_GFXD_1_0_1_0(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString((String)this.sqlText, (DataOutput)out);
            DataSerializer.writeString((String)this.whereClause, (DataOutput)out);
            DataSerializer.writeString((String)this.tableName, (DataOutput)out);
            DataSerializer.writeString((String)this.defaultSchema, (DataOutput)out);
            GemFireXDUtils.writeCompressedHighLow(out, this.connectionId);
            DataSerializer.writeObject((Object)this.props, (DataOutput)out);
            int parameterNumber = this.parameterValues == null ? 0 : this.parameterValues.length;
            out.writeInt(parameterNumber);
            if (parameterNumber > 0) {
                for (DataValueDescriptor dvd : this.parameterValues) {
                    InternalDataSerializer.invokeToData((DataSerializableFixedID)dvd, (DataOutput)out);
                }
                for (int i = 0; i < this.parameterInfo.length; ++i) {
                    out.writeInt(this.parameterInfo[i][0]);
                    out.writeInt(this.parameterInfo[i][1]);
                    out.writeInt(this.parameterInfo[i][2]);
                }
            }
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            this.toDataPre_GFXD_1_0_1_0(out);
            GemFireXDUtils.writeCompressedHighLow(out, this.timeOutMillis);
            GemFireXDUtils.writeCompressedHighLow(out, this.stmtId);
        }

        public String toString() {
            return "DistributedProcedureCallFunctionArgs sqlText '" + this.sqlText + "' whereClause '" + this.whereClause + "' tableName '" + this.tableName + "' defaultSchema=" + this.defaultSchema + ", connectionId=" + this.connectionId + " parameters: " + ArrayUtils.objectString((Object)this.parameterValues) + " timeOutMillis:" + this.timeOutMillis + " statementId:" + this.stmtId;
        }
    }
}

