/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management.impl;

import com.pivotal.gemfirexd.internal.engine.management.StatementMXBean;
import com.pivotal.gemfirexd.internal.engine.management.impl.StatementMBeanBridge;
import com.pivotal.gemfirexd.internal.impl.sql.GenericStatement;
import java.util.concurrent.atomic.AtomicInteger;

public class StatementMBean
implements StatementMXBean {
    private final StatementMBeanBridge bridge;
    private final AtomicInteger refCount;

    public StatementMBean(StatementMBeanBridge bridge) {
        this.bridge = bridge;
        this.refCount = new AtomicInteger();
    }

    public void updateBridge(GenericStatement statement) {
        this.refCount.incrementAndGet();
        this.bridge.update(statement);
    }

    @Override
    public long getQNNumTimesCompiled() {
        return this.bridge.getQNNumTimesCompiled();
    }

    @Override
    public long getDNNumTimesCompiled() {
        return this.bridge.getDNNumTimesCompiled();
    }

    @Override
    public long getQNNumExecutions() {
        return this.bridge.getQNNumExecutions();
    }

    @Override
    public long getDNNumExecution() {
        return this.bridge.getDNNumExecution();
    }

    @Override
    public long getQNNumExecutionsInProgress() {
        return this.bridge.getQNNumExecutionsInProgress();
    }

    @Override
    public long getDNNumExecutionsInProgress() {
        return this.bridge.getDNNumExecutionsInProgress();
    }

    @Override
    public long getQNNumTimesGlobalIndexLookup() {
        return this.bridge.getQNNumTimesGlobalIndexLookup();
    }

    @Override
    public long getDNNumTimesGlobalIndexLookup() {
        return this.bridge.getDNNumTimesGlobalIndexLookup();
    }

    @Override
    public long getQNNumRowsModified() {
        return this.bridge.getQNNumRowsModified();
    }

    @Override
    public long getDNNumRowsModified() {
        return this.bridge.getDNNumRowsModified();
    }

    @Override
    public long getQNParseTime() {
        return this.bridge.getQNParseTime();
    }

    @Override
    public long getDNParseTime() {
        return this.bridge.getDNParseTime();
    }

    @Override
    public long getQNBindTime() {
        return this.bridge.getQNBindTime();
    }

    @Override
    public long getDNBindTime() {
        return this.bridge.getDNBindTime();
    }

    @Override
    public long getQNOptimizeTime() {
        return this.bridge.getQNOptimizeTime();
    }

    @Override
    public long getDNOptimizeTime() {
        return this.bridge.getDNOptimizeTime();
    }

    @Override
    public long getQNRoutingInfoTime() {
        return this.bridge.getQNRoutingInfoTime();
    }

    @Override
    public long getDNRoutingInfoTime() {
        return this.bridge.getDNRoutingInfoTime();
    }

    @Override
    public long getQNGenerateTime() {
        return this.bridge.getQNGenerateTime();
    }

    @Override
    public long getDNGenerateTime() {
        return this.bridge.getDNGenerateTime();
    }

    @Override
    public long getQNTotalCompilationTime() {
        return this.bridge.getQNTotalCompilationTime();
    }

    @Override
    public long getDNTotalCompilationTime() {
        return this.bridge.getDNTotalCompilationTime();
    }

    @Override
    public long getQNExecuteTime() {
        return this.bridge.getQNExecuteTime();
    }

    @Override
    public long getDNExecutionTime() {
        return this.bridge.getDNExecutionTime();
    }

    @Override
    public long getQNProjectionTime() {
        return this.bridge.getQNProjectionTime();
    }

    @Override
    public long getDNProjectionTime() {
        return this.bridge.getDNProjectionTime();
    }

    @Override
    public long getQNTotalExecutionTime() {
        return this.bridge.getQNTotalExecutionTime();
    }

    @Override
    public long getDNTotalExecutionTime() {
        return this.bridge.getDNTotalExecutionTime();
    }

    @Override
    public long getQNRowsModificationTime() {
        return this.bridge.getQNRowsModificationTime();
    }

    @Override
    public long getDNRowsModificationTime() {
        return this.bridge.getDNRowsModificationTime();
    }

    @Override
    public long getQNNumRowsSeen() {
        return this.bridge.getQNNumRowsSeenId();
    }

    @Override
    public long getQNMsgSendTime() {
        return this.bridge.getQNMsgSendTime();
    }

    @Override
    public long getQNMsgSerTime() {
        return this.bridge.getQNMsgSerTime();
    }

    @Override
    public long getQNRespDeSerTime() {
        return this.bridge.getQNRespDeSerTime();
    }

    @Override
    public long getNumProjectedRows() {
        return this.bridge.getDNNumProjectedRows();
    }

    @Override
    public long getNumNLJoinRowsReturned() {
        return this.bridge.getDNNumNLJoinRowsReturned();
    }

    @Override
    public long getNumHASHJoinRowsReturned() {
        return this.bridge.getDNNumHASHJoinRowsReturned();
    }

    @Override
    public long getNumTableRowsScanned() {
        return this.bridge.getDNNumTableRowsScanned();
    }

    @Override
    public long getNumRowsHashScanned() {
        return this.bridge.getDNNumRowsHashScanned();
    }

    @Override
    public long getNumIndexRowsScanned() {
        return this.bridge.getDNNumIndexRowsScanned();
    }

    @Override
    public long getNumRowsSorted() {
        return this.bridge.getDNNumRowsSorted();
    }

    @Override
    public long getNumSortRowsOverflowed() {
        return this.bridge.getDNNumSortRowsOverflowed();
    }

    @Override
    public long getNumSingleHopExecutions() {
        return this.bridge.getDNNumSingleHopExecutions();
    }

    @Override
    public long getSubQueryNumRowsSeen() {
        return this.bridge.getDNSubQueryNumRowsSeen();
    }

    @Override
    public long getMsgDeSerTime() {
        return this.bridge.getDNMsgDeSerTime();
    }

    @Override
    public long getMsgProcessTime() {
        return this.bridge.getDNMsgProcessTime();
    }

    @Override
    public long getResultIterationTime() {
        return this.bridge.getDNResultIterationTime();
    }

    @Override
    public long getRespSerTime() {
        return this.bridge.getDNRespSerTime();
    }

    @Override
    public long getThrottleTime() {
        return this.bridge.getDNThrottleTime();
    }

    @Override
    public long getNLJoinTime() {
        return this.bridge.getDNNLJoinTime();
    }

    @Override
    public long getHASHJoinTime() {
        return this.bridge.getDNHASHJoinTime();
    }

    @Override
    public long getTableScanTime() {
        return this.bridge.getDNTableScanTime();
    }

    @Override
    public long getHashScanTime() {
        return this.bridge.getDNHashScanTime();
    }

    @Override
    public long getIndexScanTime() {
        return this.bridge.getDNIndexScanTime();
    }

    @Override
    public long getSortTime() {
        return this.bridge.getDNSortTime();
    }

    @Override
    public long getSubQueryExecutionTime() {
        return this.bridge.getDNSubQueryExecutionTime();
    }

    @Override
    public String retrievString() {
        return this.bridge.getString();
    }

    public int getRefCount() {
        return this.refCount.get();
    }

    public int decRefCount() {
        return this.refCount.decrementAndGet();
    }
}

