/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management.impl;

import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.internal.engine.Misc;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class MBeanUpdateScheduler {
    private Map<String, ScheduledFuture<?>> registeredTasks = new ConcurrentHashMap();
    private ScheduledExecutorService service;
    private int updateRate = MBeanUpdateScheduler.getConfiguredUpdateRate();

    public MBeanUpdateScheduler() {
        this.service = Executors.newScheduledThreadPool(1, new MBeanUpdaterThreadFactory());
    }

    static int getConfiguredUpdateRate() {
        int configuredUpdateRate = 0;
        GemFireCacheImpl cache = Misc.getGemFireCacheNoThrow();
        if (cache != null) {
            configuredUpdateRate = cache.getDistributedSystem().getConfig().getJmxManagerUpdateRate();
        }
        return configuredUpdateRate > 0 ? configuredUpdateRate : 5000;
    }

    public int getUpdateRate() {
        return this.updateRate;
    }

    public void scheduleTaskWithFixedDelay(Runnable r, String serviceName, long initialDelay) {
        ScheduledFuture<?> scheduledFuture = this.service.scheduleWithFixedDelay(r, initialDelay, this.updateRate, TimeUnit.MILLISECONDS);
        this.registeredTasks.put(serviceName, scheduledFuture);
    }

    public void scheduleTaskAtFixedRate(Runnable r, String serviceName, long initialDelay) {
        ScheduledFuture<?> scheduledFuture = this.service.scheduleAtFixedRate(r, initialDelay, this.updateRate, TimeUnit.MILLISECONDS);
        this.registeredTasks.put(serviceName, scheduledFuture);
    }

    public void stopTask(String serviceName) {
        ScheduledFuture<?> scheduledFuture = this.registeredTasks.get(serviceName);
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
            this.registeredTasks.remove(serviceName);
        }
    }

    public void stopAllTasks() {
        this.registeredTasks.clear();
        this.service.shutdownNow();
        this.service = null;
        this.registeredTasks = null;
    }

    public String toString() {
        return MBeanUpdateScheduler.class.getSimpleName() + " [registeredTasks=" + this.registeredTasks + ", service=" + this.service + "]";
    }

    private static class MBeanUpdaterThreadFactory
    implements ThreadFactory {
        private static final String THREAD_GROUP_NAME = "GemFireXD MBean Updater Threads ";
        private ThreadGroup mbeanUpdaterThreads;
        private AtomicInteger ai = new AtomicInteger();

        public MBeanUpdaterThreadFactory() {
            this.mbeanUpdaterThreads = new ThreadGroup(THREAD_GROUP_NAME);
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread newThread = new Thread(this.mbeanUpdaterThreads, r, THREAD_GROUP_NAME + this.ai.getAndIncrement());
            newThread.setDaemon(true);
            return newThread;
        }
    }
}

