/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management.impl;

import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.management.internal.FederationComponent;
import com.gemstone.gemfire.management.internal.ProxyListener;
import com.gemstone.gemfire.management.internal.beans.AggregateHandler;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.management.AggregateStatementMXBean;
import com.pivotal.gemfirexd.internal.engine.management.GfxdMemberMXBean;
import com.pivotal.gemfirexd.internal.engine.management.StatementMXBean;
import com.pivotal.gemfirexd.internal.engine.management.TableMXBean;
import com.pivotal.gemfirexd.internal.engine.management.impl.AggregateStatementMBean;
import com.pivotal.gemfirexd.internal.engine.management.impl.AggregateStatementMBeanBridge;
import com.pivotal.gemfirexd.internal.engine.management.impl.GfxdDistributedSystemBridge;
import com.pivotal.gemfirexd.internal.engine.management.impl.InternalManagementService;
import com.pivotal.gemfirexd.internal.engine.management.impl.ManagementUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.Notification;
import javax.management.ObjectName;

public class GfxdMBeanAggregator
implements ProxyListener {
    private static final List<Class> aggregateMBeanList = new ArrayList<Class>();
    protected LogWriterI18n logger;
    private GfxdDistributedSystemBridge gfxdDistributedSystemBridge;
    private GfxdMemberHandler gfxdMemberHandler = new GfxdMemberHandler();
    private StatementAggregateHanlder statementHandler = new StatementAggregateHanlder();
    private GfxdTableMBeanHandler gfxdTableMBeanHandler;
    private InternalManagementService service;

    public GfxdMBeanAggregator(GfxdDistributedSystemBridge dsBridge) {
        this.logger = Misc.getI18NLogWriter();
        this.gfxdDistributedSystemBridge = dsBridge;
        this.service = InternalManagementService.getInstance(Misc.getMemStore());
        this.gfxdTableMBeanHandler = new GfxdTableMBeanHandler();
    }

    private AggregateHandler getHandler(Class interfaceClass) {
        if (interfaceClass.equals(GfxdMemberMXBean.class)) {
            return this.gfxdMemberHandler;
        }
        if (interfaceClass.equals(StatementMXBean.class)) {
            return this.statementHandler;
        }
        if (interfaceClass.equals(TableMXBean.class)) {
            return this.gfxdTableMBeanHandler;
        }
        return null;
    }

    public void afterCreateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
        if (!aggregateMBeanList.contains(interfaceClass)) {
            return;
        }
        AggregateHandler handler = this.getHandler(interfaceClass);
        handler.handleProxyAddition(objectName, interfaceClass, proxyObject, newVal);
    }

    public void afterRemoveProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent oldVal) {
        if (!aggregateMBeanList.contains(interfaceClass)) {
            return;
        }
        AggregateHandler handler = this.getHandler(interfaceClass);
        handler.handleProxyRemoval(objectName, interfaceClass, proxyObject, oldVal);
    }

    public void afterUpdateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal, FederationComponent oldVal) {
        if (!aggregateMBeanList.contains(interfaceClass)) {
            return;
        }
        AggregateHandler handler = this.getHandler(interfaceClass);
        handler.handleProxyUpdate(objectName, interfaceClass, proxyObject, newVal, oldVal);
    }

    public void afterPseudoCreateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
    }

    public void memberDeparted(InternalDistributedMember id, boolean crashed) {
        this.gfxdDistributedSystemBridge.memberDeparted(id, crashed);
    }

    public void memberJoined(InternalDistributedMember id) {
        this.gfxdDistributedSystemBridge.memberJoined(id);
    }

    public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }

    public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected) {
        this.gfxdDistributedSystemBridge.memberSuspect(id, whoSuspected);
    }

    public void handleNotification(Notification notification) {
        this.gfxdDistributedSystemBridge.sendSystemLevelNotification(notification);
    }

    static {
        aggregateMBeanList.add(GfxdMemberMXBean.class);
        aggregateMBeanList.add(StatementMXBean.class);
        aggregateMBeanList.add(TableMXBean.class);
    }

    private class GfxdTableMBeanHandler
    implements AggregateHandler {
        private GfxdTableMBeanHandler() {
        }

        public void handleProxyAddition(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
            TableMXBean memberProxy = (TableMXBean)interfaceClass.cast(proxyObject);
            GfxdMBeanAggregator.this.gfxdDistributedSystemBridge.addTableToSystem(objectName, memberProxy, newVal);
        }

        public void handleProxyRemoval(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent oldVal) {
            TableMXBean memberProxy = (TableMXBean)interfaceClass.cast(proxyObject);
            GfxdMBeanAggregator.this.gfxdDistributedSystemBridge.removeTableFromSystem(objectName, memberProxy, oldVal);
        }

        public void handleProxyUpdate(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal, FederationComponent oldVal) {
            GfxdMBeanAggregator.this.gfxdDistributedSystemBridge.updateTableFromSystem(objectName, newVal, oldVal);
        }

        public void handlePseudoCreateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
        }
    }

    private class StatementAggregateHanlder
    implements AggregateHandler {
        private StatementAggregateHanlder() {
        }

        public void handleProxyAddition(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
            AggregateStatementMBean aggregateStmtBean = this.getAggregateStatementMBean(objectName, true);
            String memberName = objectName.getKeyProperty("member");
            aggregateStmtBean.getBridge().aggregate(memberName, newVal, null);
        }

        public void handleProxyRemoval(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent oldVal) {
            AggregateStatementMBean aggregateStmtBean = this.getAggregateStatementMBean(objectName, false);
            if (aggregateStmtBean == null) {
                return;
            }
            String memberName = objectName.getKeyProperty("member");
            aggregateStmtBean.getBridge().aggregate(memberName, null, oldVal);
            if (aggregateStmtBean.getBridge().getMemberCount() == 0) {
                String name = objectName.getKeyProperty("name");
                ObjectName aggregateStatementName = ManagementUtils.getAggregateStatementMBeanName(name);
                GfxdMBeanAggregator.this.service.unregisterMBean(aggregateStatementName);
            }
        }

        public void handleProxyUpdate(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal, FederationComponent oldVal) {
            AggregateStatementMBean aggregateStmtBean = this.getAggregateStatementMBean(objectName, false);
            if (aggregateStmtBean == null) {
                return;
            }
            String memberName = objectName.getKeyProperty("member");
            aggregateStmtBean.getBridge().aggregate(memberName, newVal, oldVal);
        }

        private synchronized AggregateStatementMBean getAggregateStatementMBean(ObjectName statementObjectName, boolean createAggregateMBean) {
            String name = statementObjectName.getKeyProperty("name");
            ObjectName aggregateStatementName = ManagementUtils.getAggregateStatementMBeanName(name);
            AggregateStatementMXBean bean = GfxdMBeanAggregator.this.service.getMBeanInstance(aggregateStatementName, AggregateStatementMXBean.class);
            AggregateStatementMBean statementMBean = null;
            if (bean != null) {
                statementMBean = (AggregateStatementMBean)bean;
            } else if (createAggregateMBean) {
                AggregateStatementMBeanBridge bridge = new AggregateStatementMBeanBridge();
                statementMBean = new AggregateStatementMBean(bridge);
                GfxdMBeanAggregator.this.service.registerMBean(statementMBean, aggregateStatementName);
            }
            return statementMBean;
        }

        public void handlePseudoCreateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
        }
    }

    private class GfxdMemberHandler
    implements AggregateHandler {
        private GfxdMemberHandler() {
        }

        public void handleProxyAddition(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
            GfxdMemberMXBean memberProxy = (GfxdMemberMXBean)interfaceClass.cast(proxyObject);
            GfxdMBeanAggregator.this.gfxdDistributedSystemBridge.addMemberToSystem(objectName, memberProxy, newVal);
        }

        public void handleProxyRemoval(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent oldVal) {
            GfxdMemberMXBean memberProxy = (GfxdMemberMXBean)interfaceClass.cast(proxyObject);
            GfxdMBeanAggregator.this.gfxdDistributedSystemBridge.removeMemberFromSystem(objectName, memberProxy, oldVal);
        }

        public void handleProxyUpdate(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal, FederationComponent oldVal) {
        }

        public void handlePseudoCreateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
        }
    }
}

