/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management.impl;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.management.internal.FederationComponent;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.management.TableMXBean;
import com.pivotal.gemfirexd.internal.engine.management.impl.InternalManagementService;
import com.pivotal.gemfirexd.internal.engine.management.impl.ManagementUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.management.ObjectName;

public class GfxdAggregateTableStatsMonitor {
    private static final String POLICY = "Policy";
    private long numberOfRows = 0L;
    private double entrySize = 0.0;
    FederationComponent newState;
    FederationComponent oldState = null;
    ObjectName objectName = null;
    protected LogWriterI18n logger = InternalDistributedSystem.getLoggerI18n();

    public void aggregate(FederationComponent newState, FederationComponent oldState, ObjectName objectName) {
        this.newState = newState;
        this.oldState = oldState;
        this.objectName = objectName;
    }

    public double getEntrySize() {
        this.updateStats();
        return this.entrySize;
    }

    public long getNumberOfRows() {
        this.updateStats();
        return this.numberOfRows;
    }

    private synchronized void updateStats() {
        try {
            String[] grps;
            String tableName = this.objectName.getKeyProperty("table");
            String policyName = new String();
            ArrayList<String> servergroups = new ArrayList<String>();
            servergroups.add("DEFAULT");
            if (this.oldState != null) {
                policyName = (String)this.oldState.getValue(POLICY);
                grps = (String[])this.oldState.getValue("ServerGroups");
                if (grps != null) {
                    Collections.addAll(servergroups, grps);
                }
            } else if (this.newState != null) {
                policyName = (String)this.newState.getValue(POLICY);
                grps = (String[])this.newState.getValue("ServerGroups");
                if (grps != null) {
                    Collections.addAll(servergroups, grps);
                }
            }
            GemFireCacheImpl cache = Misc.getGemFireCacheNoThrow();
            if (cache != null && tableName != null && policyName != null && !cache.isClosed() && !cache.isCacheAtShutdownAll()) {
                this.numberOfRows = 0L;
                this.entrySize = 0.0;
                Set dsMembers = CliUtil.getAllMembers((Cache)cache);
                for (DistributedMember dsMember : dsMembers) {
                    for (String serverGroup : servergroups) {
                        try {
                            ObjectName tableObjectName = ManagementUtils.getTableMBeanName(serverGroup, MBeanJMXAdapter.getMemberNameOrId((DistributedMember)dsMember), tableName);
                            TableMXBean mbean = InternalManagementService.getAnyInstance().getMBeanInstance(tableObjectName, TableMXBean.class);
                            if (mbean == null) continue;
                            if (policyName.toLowerCase().contains(DataPolicy.PARTITION.toString().toLowerCase())) {
                                this.numberOfRows += mbean.getNumberOfRows();
                                this.entrySize += mbean.getEntrySize();
                                continue;
                            }
                            if (servergroups.size() > 1) {
                                if (serverGroup.equals("DEFAULT")) continue;
                                this.numberOfRows = mbean.getNumberOfRows();
                                this.entrySize = mbean.getEntrySize();
                                continue;
                            }
                            this.numberOfRows = mbean.getNumberOfRows();
                            this.entrySize = mbean.getEntrySize();
                        }
                        catch (Exception e) {
                            this.logger.warning(LocalizedStrings.DEBUG, (Object)"exception in updatestats", (Throwable)e);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            this.logger.warning(LocalizedStrings.DEBUG, (Object)"exception occured in updatestats", (Throwable)ex);
        }
    }
}

