/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management.impl;

import com.gemstone.gemfire.management.internal.FederationComponent;
import com.gemstone.gemfire.management.internal.beans.stats.LongStatsDeltaAggregator;
import com.gemstone.gemfire.management.internal.beans.stats.StatsAggregator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AggregateStatementMBeanBridge {
    private static final String QN_NUM_TIMES_COMPILED = "QNNumTimesCompiled";
    private static final String QN_NUM_EXECUTIONS = "QNNumExecutions";
    private static final String QN_NUM_EXECUTION_IN_PROGRESS = "QNNumExecutionsInProgress";
    private static final String QN_NUM_TIMES_GLOBAL_INDEX_LOOKUP = "QNNumTimesGlobalIndexLookup";
    private static final String QN_NUM_ROWS_MODIFIED = "QNNumRowsModified";
    private static final String QN_PARSE_TIME = "QNParseTime";
    private static final String QN_BIND_TIME = "QNBindTime";
    private static final String QN_OPTIMIZE_TIME = "QNOptimizeTime";
    private static final String QN_ROUTING_INFO_TIME = "QNRoutingInfoTime";
    private static final String QN_GENERATE_TIME = "QNGenerateTime";
    private static final String QN_TOTAL_COMPILATION_TIME = "QNTotalCompilationTime";
    private static final String QN_EXECUTE_TIME = "QNExecuteTime";
    private static final String QN_PROJECTION_TIME = "QNProjectionTime";
    private static final String QN_TOTAL_EXECUTION_TIME = "QNTotalExecutionTime";
    private static final String QN_ROWS_MODIFICATION_TIME = "QNRowsModificationTime";
    private static final String QN_NUM_ROWS_SEEN = "QNNumRowsSeen";
    private static final String QN_MSG_SEND_TIME = "QNMsgSendTime";
    private static final String QN_MSG_SER_TIME = "QNMsgSerTime";
    private static final String QN_RESP_DESER_TIME = "QNRespDeSerTime";
    private AggregateStatementClusterStatsMonitor monitor = new AggregateStatementClusterStatsMonitor();
    private LongStatsDeltaAggregator deltas;
    private volatile int memberCount = 0;

    public AggregateStatementMBeanBridge() {
        ArrayList<String> keysList = new ArrayList<String>();
        keysList.add(QN_NUM_TIMES_COMPILED);
        keysList.add(QN_NUM_EXECUTIONS);
        keysList.add(QN_NUM_EXECUTION_IN_PROGRESS);
        keysList.add(QN_NUM_TIMES_GLOBAL_INDEX_LOOKUP);
        keysList.add(QN_NUM_ROWS_MODIFIED);
        keysList.add(QN_PARSE_TIME);
        keysList.add(QN_BIND_TIME);
        keysList.add(QN_OPTIMIZE_TIME);
        keysList.add(QN_ROUTING_INFO_TIME);
        keysList.add(QN_GENERATE_TIME);
        keysList.add(QN_TOTAL_COMPILATION_TIME);
        keysList.add(QN_EXECUTE_TIME);
        keysList.add(QN_PROJECTION_TIME);
        keysList.add(QN_TOTAL_EXECUTION_TIME);
        keysList.add(QN_ROWS_MODIFICATION_TIME);
        keysList.add(QN_NUM_ROWS_SEEN);
        keysList.add(QN_MSG_SEND_TIME);
        keysList.add(QN_MSG_SER_TIME);
        this.deltas = new LongStatsDeltaAggregator(keysList);
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public void aggregate(String member, FederationComponent newState, FederationComponent oldState) {
        if (newState != null && oldState == null) {
            ++this.memberCount;
        }
        if (newState == null && oldState != null) {
            --this.memberCount;
        }
        this.monitor.aggregate(newState, oldState);
        this.deltas.aggregate(newState, oldState);
        this.insertIntoTable(member, newState, oldState);
    }

    private void insertIntoTable(String member, FederationComponent newState, FederationComponent oldState) {
    }

    public long getBindTime() {
        return this.deltas.getDelta(QN_BIND_TIME);
    }

    public long getExecutionTime() {
        return this.deltas.getDelta(QN_EXECUTE_TIME);
    }

    public long getGenerateTime() {
        return this.deltas.getDelta(QN_GENERATE_TIME);
    }

    public long getNumExecution() {
        return this.deltas.getDelta(QN_NUM_EXECUTIONS);
    }

    public long getNumExecutionsInProgress() {
        return this.monitor.getNumExecutionsInProgresss();
    }

    public long getNumRowsModified() {
        return this.deltas.getDelta(QN_NUM_ROWS_MODIFIED);
    }

    public long getNumTimesCompiled() {
        return this.deltas.getDelta(QN_NUM_TIMES_COMPILED);
    }

    public long getNumTimesGlobalIndexLookup() {
        return this.deltas.getDelta(QN_NUM_TIMES_GLOBAL_INDEX_LOOKUP);
    }

    public long getOptimizeTime() {
        return this.deltas.getDelta(QN_OPTIMIZE_TIME);
    }

    public long getParseTime() {
        return this.deltas.getDelta(QN_PARSE_TIME);
    }

    public long getProjectionTime() {
        return this.deltas.getDelta(QN_PROJECTION_TIME);
    }

    public long getQNMsgSendTime() {
        return this.deltas.getDelta(QN_MSG_SEND_TIME);
    }

    public long getQNMsgSerTime() {
        return this.deltas.getDelta(QN_MSG_SER_TIME);
    }

    public long getQNNumRowsSeen() {
        return this.deltas.getDelta(QN_NUM_ROWS_SEEN);
    }

    public long getRoutingInfoTime() {
        return this.deltas.getDelta(QN_ROUTING_INFO_TIME);
    }

    public long getRowsModificationTime() {
        return this.deltas.getDelta(QN_ROWS_MODIFICATION_TIME);
    }

    public long getTotalCompilationTime() {
        return this.deltas.getDelta(QN_TOTAL_COMPILATION_TIME);
    }

    public long getTotalExecutionTime() {
        return this.deltas.getDelta(QN_TOTAL_EXECUTION_TIME);
    }

    public long getQNRespDeSerTime() {
        return this.deltas.getDelta(QN_RESP_DESER_TIME);
    }

    public AggregateStatementClusterStatsMonitor getMonitor() {
        return this.monitor;
    }

    class AggregateStatementClusterStatsMonitor {
        private StatsAggregator aggregator;
        private Map<String, Class<?>> typeMap = new HashMap();

        public void aggregate(FederationComponent newState, FederationComponent oldState) {
            this.aggregator.aggregate(newState, oldState);
        }

        public AggregateStatementClusterStatsMonitor() {
            this.intTypeMap();
            this.aggregator = new StatsAggregator(this.typeMap);
        }

        private void intTypeMap() {
            this.typeMap.put(AggregateStatementMBeanBridge.QN_NUM_EXECUTION_IN_PROGRESS, Long.TYPE);
        }

        public long getNumExecutionsInProgresss() {
            return this.aggregator.getIntValue(AggregateStatementMBeanBridge.QN_NUM_EXECUTION_IN_PROGRESS).intValue();
        }
    }
}

