/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management;

import com.gemstone.gemfire.LogWriter;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.management.impl.InternalManagementService;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import javax.management.ObjectName;

public class GfxdManagementService {
    public static final String DISABLE_MANAGEMENT_PROPERTY = "gemfire.disableManagement";
    private static final Object INSTANCE_LOCK = GfxdManagementService.class;
    private static final Map<GemFireStore, GfxdManagementService> INSTANCES = new Hashtable<GemFireStore, GfxdManagementService>();
    private InternalManagementService internalManagementService;
    private static boolean loggedDisabled;

    private GfxdManagementService(GemFireStore store) {
        this.internalManagementService = InternalManagementService.getInstance(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GfxdManagementService getInstance(GemFireStore store) {
        GfxdManagementService foundInstance = null;
        if (store != null && (foundInstance = INSTANCES.get(store)) == null && store != null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                foundInstance = INSTANCES.get(store);
                if (foundInstance == null) {
                    foundInstance = new GfxdManagementService(store);
                    INSTANCES.clear();
                    INSTANCES.put(store, foundInstance);
                }
            }
        }
        return foundInstance;
    }

    public static boolean isManagementDisabled() {
        return Boolean.getBoolean(DISABLE_MANAGEMENT_PROPERTY);
    }

    public static <T> void handleEvent(int eventId, T eventData) {
        GemFireStore store = GemFireStore.getBootedInstance();
        if (!GfxdManagementService.isManagementDisabled() && store != null) {
            GfxdManagementService managementService = GfxdManagementService.getInstance(store);
            if (managementService != null) {
                managementService.handleEventForManagement(eventId, eventData);
                InternalManagementService mgmt = managementService.internalManagementService;
                if (mgmt != null && mgmt.isStopped()) {
                    managementService.stopService();
                }
            }
        } else if (!loggedDisabled) {
            GfxdManagementService.logInfo("Management is disabled, MBeans won't be available.", null);
            loggedDisabled = true;
        }
    }

    private static void logInfo(String message, Throwable t) {
        LogWriter logger = Misc.getCacheLogWriterNoThrow();
        if (logger != null && logger.infoEnabled()) {
            logger.info(message, t);
        } else {
            SanityManager.DEBUG_PRINT((String)Level.INFO.toString().toLowerCase(), (String)message, (Throwable)t);
        }
    }

    private <T> void handleEventForManagement(int eventId, T eventData) {
        if (this.internalManagementService != null && !this.internalManagementService.isStopped()) {
            this.internalManagementService.handleEvent(eventId, eventData);
        }
    }

    public <T> Object registerMBean(T bean, ObjectName objectName) {
        return this.internalManagementService.registerMBean(bean, objectName);
    }

    public void unregisterMBean(ObjectName objectName) {
        this.internalManagementService.unregisterMBean(objectName);
    }

    public boolean isManager() {
        return this.internalManagementService.isManager();
    }

    public void startManager() {
        this.internalManagementService.startManager();
    }

    public void stopManager() {
        this.internalManagementService.stopManager();
    }

    public boolean isStopped() {
        return this.internalManagementService.isStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            INSTANCES.clear();
        }
        if (!this.internalManagementService.isStopped()) {
            this.internalManagementService.stopService();
        }
    }
}

