/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler;

import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.Criteria;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.Filter;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.InvalidPathException;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.Cache;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.Utils;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.ArrayPathToken;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.CompiledPath;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.FilterPathToken;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.PathToken;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.PropertyPathToken;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.RootPathToken;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.ScanPathToken;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.WildcardPathToken;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.spi.compiler.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathCompiler {
    private static final Logger logger = LoggerFactory.getLogger(PathCompiler.class);
    private static final String PROPERTY_OPEN = "['";
    private static final String PROPERTY_CLOSE = "']";
    private static final char DOCUMENT = '$';
    private static final char ANY = '*';
    private static final char PERIOD = '.';
    private static final char BRACKET_OPEN = '[';
    private static final char BRACKET_CLOSE = ']';
    private static final char SPACE = ' ';
    private static final Cache cache = new Cache(200);

    public static Path tokenize(String path, Filter ... filters) {
        String cacheKey;
        Path p;
        Utils.notEmpty(path, "Path may not be null empty", new Object[0]);
        path = path.trim();
        LinkedList<Filter> filterList = new LinkedList<Filter>(Arrays.asList(filters));
        if (!path.startsWith("$")) {
            path = "$." + path;
        }
        if ((p = cache.get(cacheKey = path + filterList.toString())) != null) {
            return p;
        }
        RootPathToken root = null;
        char[] chars = path.toCharArray();
        int i = 0;
        String fragment = "";
        block7: do {
            char current = chars[i];
            switch (current) {
                case ' ': {
                    throw new InvalidPathException("Space not allowed in path");
                }
                case '$': {
                    fragment = "$";
                    ++i;
                    break;
                }
                case '[': {
                    int positions = PathCompiler.fastForwardUntilClosed(chars, i);
                    fragment = new String(chars, i, positions);
                    i += positions;
                    break;
                }
                case '.': {
                    if (chars[++i] == '.') {
                        fragment = "..";
                        ++i;
                        break;
                    }
                    int positions = PathCompiler.fastForward(chars, i);
                    if (positions == 0) continue block7;
                    if (positions == 1 && chars[i] == '*') {
                        fragment = "[*]";
                    } else {
                        PathCompiler.assertValidFieldChars(chars, i, positions);
                        fragment = PROPERTY_OPEN + new String(chars, i, positions) + PROPERTY_CLOSE;
                    }
                    i += positions;
                    break;
                }
                case '*': {
                    fragment = "[*]";
                    ++i;
                    break;
                }
                default: {
                    int positions = PathCompiler.fastForward(chars, i);
                    fragment = PROPERTY_OPEN + new String(chars, i, positions) + PROPERTY_CLOSE;
                    i += positions;
                }
            }
            if (root == null) {
                root = (RootPathToken)PathComponentAnalyzer.analyze(fragment, filterList);
                continue;
            }
            root.append(PathComponentAnalyzer.analyze(fragment, filterList));
        } while (i < chars.length);
        CompiledPath pa = new CompiledPath(root);
        cache.put(cacheKey, pa);
        return pa;
    }

    private static void assertValidFieldChars(char[] chars, int start, int positions) {
        for (int i = start; i < start + positions; ++i) {
            char c = chars[i];
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '$' || c == '@') continue;
            throw new InvalidPathException("Invalid field name! Use bracket notation if your filed names does not match pattern: ([a-zA-Z@][a-zA-Z0-9@\\$_\\-]*)$");
        }
    }

    private static int fastForward(char[] chars, int index) {
        char current;
        int skipCount = 0;
        while (index < chars.length && (current = chars[index]) != '.' && current != '[' && current != ' ') {
            ++index;
            ++skipCount;
        }
        return skipCount;
    }

    private static int fastForwardUntilClosed(char[] chars, int index) {
        int skipCount = 0;
        int nestedBrackets = 0;
        ++index;
        ++skipCount;
        while (index < chars.length) {
            char current = chars[index];
            ++index;
            ++skipCount;
            if (current == ']' && nestedBrackets == 0) break;
            if (current == '[') {
                ++nestedBrackets;
            }
            if (current != ']') continue;
            --nestedBrackets;
        }
        return skipCount;
    }

    static class PathComponentAnalyzer {
        private static final Pattern FILTER_PATTERN = Pattern.compile("^\\[\\s*\\?\\s*[,\\s*\\?]*?\\s*]$");
        private char[] chars;
        private int i;
        private char current;
        private final LinkedList<Filter> filterList;
        private final String pathFragment;

        PathComponentAnalyzer(String pathFragment, LinkedList<Filter> filterList) {
            this.pathFragment = pathFragment;
            this.filterList = filterList;
        }

        static PathToken analyze(String pathFragment, LinkedList<Filter> filterList) {
            return new PathComponentAnalyzer(pathFragment, filterList).analyze();
        }

        public PathToken analyze() {
            if ("$".equals(this.pathFragment)) {
                return new RootPathToken();
            }
            if ("..".equals(this.pathFragment)) {
                return new ScanPathToken();
            }
            if ("[*]".equals(this.pathFragment)) {
                return new WildcardPathToken();
            }
            if (".*".equals(this.pathFragment)) {
                return new WildcardPathToken();
            }
            if ("[?]".equals(this.pathFragment)) {
                return new FilterPathToken(this.filterList.poll());
            }
            if (FILTER_PATTERN.matcher(this.pathFragment).matches()) {
                int criteriaCount = Utils.countMatches(this.pathFragment, "?");
                ArrayList<Filter> filters = new ArrayList<Filter>(criteriaCount);
                for (int i = 0; i < criteriaCount; ++i) {
                    filters.add(this.filterList.poll());
                }
                return new FilterPathToken(filters);
            }
            this.chars = this.pathFragment.toCharArray();
            this.i = 0;
            do {
                this.current = this.chars[this.i];
                switch (this.current) {
                    case '?': {
                        return this.analyzeCriteriaSequence();
                    }
                    case '\'': {
                        return this.analyzeProperty();
                    }
                }
                if (Character.isDigit(this.current) || this.current == ':' || this.current == '-' || this.current == '@') {
                    return this.analyzeArraySequence();
                }
                ++this.i;
            } while (this.i < this.chars.length);
            throw new InvalidPathException("Could not analyze path component: " + this.pathFragment);
        }

        private PathToken analyzeCriteriaSequence() {
            StringBuilder pathBuffer = new StringBuilder();
            StringBuilder operatorBuffer = new StringBuilder();
            StringBuilder valueBuffer = new StringBuilder();
            ArrayList<Criteria> criteria = new ArrayList<Criteria>();
            boolean isAndCriteria = false;
            boolean isOrCriteria = false;
            int bracketCount = 0;
            boolean functionBracketOpened = false;
            boolean functionBracketClosed = false;
            boolean propertyOpen = false;
            this.current = this.chars[++this.i];
            while (this.current != ']' || bracketCount != 0) {
                switch (this.current) {
                    case '[': {
                        ++bracketCount;
                        pathBuffer.append(this.current);
                        break;
                    }
                    case ']': {
                        --bracketCount;
                        pathBuffer.append(this.current);
                        break;
                    }
                    case '@': {
                        pathBuffer.append('$');
                        break;
                    }
                    case '(': {
                        if (!propertyOpen) {
                            functionBracketOpened = true;
                            break;
                        }
                    }
                    case ')': {
                        if (!propertyOpen) {
                            functionBracketClosed = true;
                            break;
                        }
                    }
                    default: {
                        char c;
                        char op1;
                        if ('\'' == this.current) {
                            propertyOpen = !propertyOpen;
                        }
                        if (bracketCount == 0 && this.isOperatorChar(this.current)) {
                            operatorBuffer.append(this.current);
                            break;
                        }
                        if (bracketCount == 0 && this.isAnd(this.current)) {
                            isAndCriteria = true;
                            if (this.isAnd(this.chars[this.i + 1])) {
                                op1 = this.current;
                                c = this.chars[++this.i];
                            }
                            criteria.add(this.createCriteria(pathBuffer, operatorBuffer, valueBuffer));
                            pathBuffer = new StringBuilder();
                            operatorBuffer = new StringBuilder();
                            valueBuffer = new StringBuilder();
                            break;
                        }
                        if (bracketCount == 0 && this.isOr(this.current)) {
                            isOrCriteria = true;
                            if (this.isOr(this.chars[this.i + 1])) {
                                op1 = this.current;
                                c = this.chars[++this.i];
                            }
                            criteria.add(this.createCriteria(pathBuffer, operatorBuffer, valueBuffer));
                            pathBuffer = new StringBuilder();
                            operatorBuffer = new StringBuilder();
                            valueBuffer = new StringBuilder();
                            break;
                        }
                        if (operatorBuffer.length() > 0) {
                            valueBuffer.append(this.current);
                            break;
                        }
                        pathBuffer.append(this.current);
                    }
                }
                this.current = this.chars[++this.i];
            }
            if (!functionBracketOpened || !functionBracketClosed) {
                throw new InvalidPathException("Function wrapping brackets are not matching. A filter function must match [?(<statement>)]");
            }
            if (isAndCriteria && isOrCriteria) {
                throw new InvalidPathException(" & and | operators can not be used in same expression.");
            }
            criteria.add(this.createCriteria(pathBuffer, operatorBuffer, valueBuffer));
            Filter filter2 = Filter.filter(criteria, isAndCriteria, isOrCriteria);
            return new FilterPathToken(filter2);
        }

        private Criteria createCriteria(StringBuilder pathBuffer, StringBuilder operatorBuffer, StringBuilder valueBuffer) {
            return Criteria.create(pathBuffer.toString().trim(), operatorBuffer.toString().trim(), valueBuffer.toString().trim());
        }

        private boolean isAnd(char c) {
            return c == '&';
        }

        private boolean isOr(char c) {
            return c == '|';
        }

        private boolean isLogicOperatorChar(char c) {
            return this.isAnd(c) || this.isOr(c);
        }

        private boolean isOperatorChar(char c) {
            return c == '=' || c == '!' || c == '<' || c == '>';
        }

        private PathToken analyzeProperty() {
            ArrayList<String> properties = new ArrayList<String>();
            StringBuilder buffer = new StringBuilder();
            boolean propertyIsOpen = false;
            while (this.current != ']') {
                switch (this.current) {
                    case '\'': {
                        if (propertyIsOpen) {
                            properties.add(buffer.toString());
                            buffer = new StringBuilder();
                            propertyIsOpen = false;
                            break;
                        }
                        propertyIsOpen = true;
                        break;
                    }
                    default: {
                        if (!propertyIsOpen) break;
                        buffer.append(this.current);
                    }
                }
                this.current = this.chars[++this.i];
            }
            return new PropertyPathToken(properties);
        }

        private PathToken analyzeArraySequence() {
            StringBuilder buffer = new StringBuilder();
            ArrayList<Integer> numbers = new ArrayList<Integer>();
            boolean contextSize = this.current == '@';
            boolean sliceTo = false;
            boolean sliceFrom = false;
            boolean sliceBetween = false;
            boolean indexSequence = false;
            boolean singleIndex = false;
            if (contextSize) {
                this.current = this.chars[++this.i];
                this.current = this.chars[++this.i];
                while (this.current != '-') {
                    if (this.current == ' ' || this.current == '(' || this.current == ')') {
                        this.current = this.chars[++this.i];
                        continue;
                    }
                    buffer.append(this.current);
                    this.current = this.chars[++this.i];
                }
                String function = buffer.toString();
                buffer = new StringBuilder();
                if (!function.equals("size") && !function.equals("length")) {
                    throw new InvalidPathException("Invalid function: @." + function + ". Supported functions are: [(@.length - n)] and [(@.size() - n)]");
                }
                while (this.current != ')') {
                    if (this.current == ' ') {
                        this.current = this.chars[++this.i];
                        continue;
                    }
                    buffer.append(this.current);
                    this.current = this.chars[++this.i];
                }
            } else {
                while (Character.isDigit(this.current) || this.current == ',' || this.current == ' ' || this.current == ':' || this.current == '-') {
                    switch (this.current) {
                        case ' ': {
                            break;
                        }
                        case ':': {
                            if (buffer.length() == 0) {
                                sliceTo = true;
                                this.current = this.chars[++this.i];
                                while (Character.isDigit(this.current) || this.current == ' ' || this.current == '-') {
                                    if (this.current != ' ') {
                                        buffer.append(this.current);
                                    }
                                    this.current = this.chars[++this.i];
                                }
                                numbers.add(Integer.parseInt(buffer.toString()));
                                buffer = new StringBuilder();
                                break;
                            }
                            numbers.add(Integer.parseInt(buffer.toString()));
                            buffer = new StringBuilder();
                            this.current = this.chars[++this.i];
                            while (Character.isDigit(this.current) || this.current == ' ' || this.current == '-') {
                                if (this.current != ' ') {
                                    buffer.append(this.current);
                                }
                                this.current = this.chars[++this.i];
                            }
                            if (buffer.length() == 0) {
                                sliceFrom = true;
                                break;
                            }
                            sliceBetween = true;
                            numbers.add(Integer.parseInt(buffer.toString()));
                            buffer = new StringBuilder();
                            break;
                        }
                        case ',': {
                            numbers.add(Integer.parseInt(buffer.toString()));
                            buffer = new StringBuilder();
                            indexSequence = true;
                            break;
                        }
                        default: {
                            buffer.append(this.current);
                        }
                    }
                    if (this.current != ']') {
                        this.current = this.chars[++this.i];
                        continue;
                    }
                    break;
                }
            }
            if (buffer.length() > 0) {
                numbers.add(Integer.parseInt(buffer.toString()));
            }
            boolean bl = singleIndex = numbers.size() == 1 && !sliceTo && !sliceFrom && !contextSize;
            if (logger.isTraceEnabled()) {
                logger.debug("numbers are                : {}", (Object)((Object)numbers).toString());
                logger.debug("sequence is singleNumber   : {}", (Object)singleIndex);
                logger.debug("sequence is numberSequence : {}", (Object)indexSequence);
                logger.debug("sequence is sliceFrom      : {}", (Object)sliceFrom);
                logger.debug("sequence is sliceTo        : {}", (Object)sliceTo);
                logger.debug("sequence is sliceBetween   : {}", (Object)sliceBetween);
                logger.debug("sequence is contextFetch   : {}", (Object)contextSize);
                logger.debug("---------------------------------------------");
            }
            ArrayPathToken.Operation operation = null;
            if (singleIndex) {
                operation = ArrayPathToken.Operation.SINGLE_INDEX;
            } else if (indexSequence) {
                operation = ArrayPathToken.Operation.INDEX_SEQUENCE;
            } else if (sliceFrom) {
                operation = ArrayPathToken.Operation.SLICE_FROM;
            } else if (sliceTo) {
                operation = ArrayPathToken.Operation.SLICE_TO;
            } else if (sliceBetween) {
                operation = ArrayPathToken.Operation.SLICE_BETWEEN;
            } else if (contextSize) {
                operation = ArrayPathToken.Operation.CONTEXT_SIZE;
            }
            assert (operation != null);
            return new ArrayPathToken(numbers, operation);
        }
    }
}

