/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler;

import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.Configuration;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.Filter;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.InvalidPathException;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.EvaluationContextImpl;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.spi.compiler.PathToken;
import java.util.Arrays;
import java.util.Collection;

class FilterPathToken
extends PathToken {
    private static final String[] FRAGMENTS = new String[]{"[?]", "[?,?]", "[?,?,?]", "[?,?,?,?]", "[?,?,?,?,?]"};
    private final Collection<Filter> filters;

    public FilterPathToken(Filter filter) {
        this.filters = Arrays.asList(filter);
    }

    public FilterPathToken(Collection<Filter> filters) {
        this.filters = filters;
    }

    @Override
    void evaluate(String currentPath, Object model, EvaluationContextImpl ctx) {
        if (!ctx.jsonProvider().isArray(model)) {
            throw new InvalidPathException(String.format("Filter: %s can only be applied to arrays. Current context is: %s", this.toString(), model));
        }
        int idx = 0;
        Iterable<Object> objects = ctx.jsonProvider().toIterable(model);
        for (Object idxModel : objects) {
            if (this.accept(idxModel, ctx.configuration())) {
                this.handleArrayIndex(idx, currentPath, model, ctx);
            }
            ++idx;
        }
    }

    public boolean accept(Object obj, Configuration configuration) {
        boolean accept = true;
        for (Filter filter : this.filters) {
            if (filter.apply(obj, configuration)) continue;
            accept = false;
            break;
        }
        return accept;
    }

    @Override
    public String getPathFragment() {
        return FRAGMENTS[this.filters.size() - 1];
    }

    @Override
    boolean isTokenDefinite() {
        return false;
    }
}

