/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.jayway.jsonpath;

import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.Option;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal.Utils;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.spi.json.JsonProvider;
import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.spi.json.JsonProviderFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class Configuration {
    private final JsonProvider provider;
    private final Set<Option> options;

    private Configuration(JsonProvider provider, EnumSet<Option> options) {
        Utils.notNull(provider, "provider can not be null", new Object[0]);
        Utils.notNull(options, "options can not be null", new Object[0]);
        this.provider = provider;
        this.options = Collections.unmodifiableSet(options);
    }

    public Configuration provider(JsonProvider provider) {
        return Configuration.builder().jsonProvider(provider).options(this.options).build();
    }

    public JsonProvider getProvider() {
        return this.provider;
    }

    public Configuration addOptions(Option ... options) {
        EnumSet<Option> opts = EnumSet.noneOf(Option.class);
        opts.addAll(this.options);
        opts.addAll(Arrays.asList(options));
        return Configuration.builder().jsonProvider(this.provider).options(opts).build();
    }

    public Configuration options(Option ... options) {
        return Configuration.builder().jsonProvider(this.provider).options(options).build();
    }

    public Set<Option> getOptions() {
        return this.options;
    }

    public boolean containsOption(Option option) {
        return this.options.contains((Object)option);
    }

    public static Configuration defaultConfiguration() {
        return new Configuration(JsonProviderFactory.createProvider(), EnumSet.noneOf(Option.class));
    }

    public static ConfigurationBuilder builder() {
        return new ConfigurationBuilder();
    }

    public static class ConfigurationBuilder {
        private JsonProvider provider;
        private EnumSet<Option> options = EnumSet.noneOf(Option.class);

        public ConfigurationBuilder jsonProvider(JsonProvider provider) {
            this.provider = provider;
            return this;
        }

        public ConfigurationBuilder options(Option ... flags) {
            this.options.addAll(Arrays.asList(flags));
            return this;
        }

        public ConfigurationBuilder options(Set<Option> options) {
            this.options.addAll(options);
            return this;
        }

        public Configuration build() {
            if (this.provider == null) {
                this.provider = JsonProviderFactory.createProvider();
            }
            return new Configuration(this.provider, this.options);
        }
    }
}

