/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.hadoop.mapreduce;

import com.pivotal.gemfirexd.hadoop.mapred.RowOutputFormat;
import com.pivotal.gemfirexd.internal.engine.hadoop.mapreduce.NoIterNoUpdateResultSetProxy;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputFormatUtil {
    public static final String OUTPUT_TABLE = "gfxd.output.tablename";
    public static final String OUTPUT_SCHEMA = "gfxd.output.schemaname";
    public static final String OUTPUT_URL = "gfxd.output.dburl";
    private static final String METHOD_PREFIX = "set";
    private final Logger logger = LoggerFactory.getLogger(OutputFormatUtil.class);
    public static int resultCountTest;

    public <VALUE> List<Method> spotTableColumnSetters(VALUE value) {
        Method[] methods;
        ArrayList<Method> columnSetters = new ArrayList<Method>();
        for (Method method : methods = value.getClass().getDeclaredMethods()) {
            String name;
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters == null || parameters.length != 2 || !(name = method.getName()).startsWith(METHOD_PREFIX) || name.length() <= METHOD_PREFIX.length() || Modifier.isPrivate(method.getModifiers()) || !Integer.TYPE.isAssignableFrom(parameters[0]) || !PreparedStatement.class.isAssignableFrom(parameters[1])) continue;
            columnSetters.add(method);
        }
        return columnSetters;
    }

    public String createQuery(String tableName, List<Method> columnSetters) {
        StringBuffer query = new StringBuffer("PUT INTO ");
        query.append(tableName).append("(");
        Iterator<Method> iter = columnSetters.iterator();
        while (iter.hasNext()) {
            Method method = iter.next();
            String name = method.getName();
            int prefixLen = METHOD_PREFIX.length();
            query.append(Character.toLowerCase(name.charAt(prefixLen)));
            if (name.length() > prefixLen + 1) {
                query.append(name.substring(prefixLen + 1));
            }
            if (!iter.hasNext()) continue;
            query.append(", ");
        }
        query.append(") VALUES (");
        iter = columnSetters.iterator();
        while (iter.hasNext()) {
            iter.next();
            query.append("?");
            if (!iter.hasNext()) continue;
            query.append(", ");
        }
        query.append(");");
        return query.toString();
    }

    private static Connection getConnection(String driver, String url, Logger logger) throws IOException, ClassNotFoundException {
        Class.forName(driver);
        try {
            Connection conn = DriverManager.getConnection(url);
            return conn;
        }
        catch (SQLException e) {
            logger.error("Error in connecting to gemfirexd instance", (Throwable)e);
            throw new IOException(e);
        }
    }

    <V> RowOutputFormat<V> getMapreduceInputFormat(V val) {
        return new RowOutputFormat();
    }

    public static ResultSet getNonIterableResultSet(EmbedResultSet rs) {
        return new NoIterNoUpdateResultSetProxy(rs);
    }

    public class RowCommandBatchExecutor {
        final int BATCH_SIZE;
        PreparedStatement st;
        private final Connection connection;
        int count;

        public RowCommandBatchExecutor(String driver, String url, int batch) throws IOException, ClassNotFoundException {
            this(OutputFormatUtil.getConnection(driver, url, this$0.logger), batch);
        }

        public RowCommandBatchExecutor(Connection conn, int batchSize) {
            this.BATCH_SIZE = batchSize;
            this.connection = conn;
        }

        public void initStatement(String query) throws SQLException {
            this.st = this.connection.prepareStatement(query);
        }

        public boolean isNotInitialized() {
            return this.st == null;
        }

        public <V> int executeWriteStatement(V val, List<Method> methods) throws IOException, SQLException {
            int i = 0;
            for (Method method : methods) {
                try {
                    method.invoke(val, ++i, this.st);
                }
                catch (Exception e) {
                    OutputFormatUtil.this.logger.error("Error executing setter method " + method.getName(), (Throwable)e);
                    e.printStackTrace();
                    throw new IOException(e);
                }
            }
            this.st.addBatch();
            ++this.count;
            resultCountTest = 0;
            if (this.BATCH_SIZE > 0 && this.count >= this.BATCH_SIZE) {
                resultCountTest = this.st.executeBatch().length;
                this.count = 0;
            }
            return resultCountTest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int close() throws IOException {
            resultCountTest = 0;
            try {
                if (this.st == null) return resultCountTest;
                resultCountTest = this.st.executeBatch().length;
                return resultCountTest;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new IOException("Failed to commit data", e);
            }
            finally {
                try {
                    if (this.st != null) {
                        this.st.close();
                        this.st = null;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (this.connection != null && !this.connection.isClosed()) {
                            this.connection.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

