/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.hadoop.mapreduce;

import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HDFSRegionDirector;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.hadoop.mapreduce.Row;
import com.pivotal.gemfirexd.hadoop.mapreduce.RowInputFormat;
import com.pivotal.gemfirexd.hadoop.mapreduce.RowRecordReader;
import com.pivotal.gemfirexd.internal.engine.Misc;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;

public class DumpHDFSData {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, InterruptedException, SQLException {
        if (args.length < 3 || args.length > 4) {
            System.err.println("Usage: DumpHDFSData namenode_url homedir tablename");
            System.err.println("  Dumps the RAW data for the table tablename into a CSV format for debugging purposes");
            System.exit(1);
        }
        String namenodeURL = args[0];
        String homeDir = args[1];
        String table = args[2];
        Configuration conf = new Configuration();
        conf.set("fs.default.name", namenodeURL);
        FileSystem fs = FileSystem.get((Configuration)conf);
        try (PrintStream out = new PrintStream(table + ".csv");){
            String fullTable = RowInputFormat.getFullyQualifiedTableName(table);
            String folder = HDFSRegionDirector.HdfsRegionManager.getRegionFolder((String)Misc.getRegionPath(fullTable));
            RemoteIterator fileItr = fs.listFiles(new Path(homeDir + "/" + folder), true);
            conf.set("gfxd.input.homedir", homeDir);
            conf.set("gfxd.input.tablename", table);
            boolean wroteHeader = false;
            TaskAttemptContextImpl context = new TaskAttemptContextImpl(conf, new TaskAttemptID());
            while (fileItr.hasNext()) {
                LocatedFileStatus file = (LocatedFileStatus)fileItr.next();
                Path path = file.getPath();
                if (!path.getName().endsWith("hop")) continue;
                CombineFileSplit split = new CombineFileSplit(new Path[]{path}, new long[]{file.getLen()});
                RowRecordReader reader = new RowRecordReader();
                reader.initialize((InputSplit)split, (TaskAttemptContext)context);
                while (reader.nextKeyValue()) {
                    int i;
                    Row row = reader.getCurrentValue();
                    ResultSet rs = row.getRowAsResultSet();
                    Event.Type op = row.getEventType();
                    long ts = row.getTimestamp();
                    int numColumns = rs.getMetaData().getColumnCount();
                    if (!wroteHeader) {
                        out.print("timestamp,operation,path");
                        for (i = 1; i <= numColumns; ++i) {
                            out.print(",");
                            out.print(rs.getMetaData().getColumnName(i));
                        }
                        out.println();
                        wroteHeader = true;
                    }
                    out.print(ts);
                    out.print(",");
                    out.print((Object)op);
                    out.print(",");
                    out.print(path);
                    for (i = 1; i <= numColumns; ++i) {
                        out.print(",");
                        String s = rs.getString(i);
                        s = s != null ? s.replaceAll("([,\n])", "\\\\1") : "NULL";
                        out.print(s);
                    }
                    out.println();
                }
            }
        }
    }
}

