/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.utils;

import com.gemstone.gemfire.internal.offheap.OffHeapRegionEntryHelper;
import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRegionEntryUtils;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;

public abstract class ServerResolverUtils
extends ResolverUtils {
    private ServerResolverUtils() {
    }

    public static int addBytesToHashLarge(OffHeapByteSource bytes, int offset, int length, int hash) {
        int currentBatchNum = 0;
        int baseOffset = offset;
        int batchSize = OffHeapRegionEntryUtils.calculateBatchSize(length);
        byte[] batch = new byte[batchSize];
        int totalBatchNum = OffHeapRegionEntryUtils.calculateNumberOfBatches(length, batchSize);
        while (currentBatchNum < totalBatchNum) {
            int size = OffHeapRegionEntryUtils.fillBatch(batch, bytes, currentBatchNum++, length, totalBatchNum, baseOffset);
            for (int i = 0; i < size; ++i) {
                hash ^= sbox[batch[i] & 0xFF];
                hash *= 3;
            }
        }
        return hash;
    }

    public static int addBytesToHash(OffHeapByteSource bytes, int hash) {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int length = bytes.getLength();
        return ServerResolverUtils.addBytesToHash(unsafe, bytes.getUnsafeAddress(0, length), length, hash);
    }

    public static int addBytesToHash(OffHeapByteSource bytes, int offset, int length, int hash) {
        return ServerResolverUtils.addBytesToHash(UnsafeMemoryChunk.getUnsafeWrapper(), bytes.getUnsafeAddress(offset, length), length, hash);
    }

    public static int addBytesToHash(UnsafeWrapper unsafe, long memOffset, int length, int hash) {
        long v;
        long endRound8Pos;
        long endPos = memOffset + (long)length;
        long l = endRound8Pos = length % 8 != 0 ? endPos - 8L : endPos;
        if (OffHeapRegionEntryHelper.NATIVE_BYTE_ORDER_IS_LITTLE_ENDIAN) {
            while (memOffset < endRound8Pos) {
                v = unsafe.getLong(memOffset);
                hash ^= sbox[(int)(v & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 8 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 16 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 24 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 32 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 40 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 48 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 56 & 0xFFL)];
                hash *= 3;
                memOffset += 8L;
            }
        } else {
            while (memOffset < endRound8Pos) {
                v = unsafe.getLong(memOffset);
                hash ^= sbox[(int)(v >>> 56 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 48 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 40 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 32 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 24 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 16 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 8 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v & 0xFFL)];
                hash *= 3;
                memOffset += 8L;
            }
        }
        while (memOffset < endPos) {
            hash ^= sbox[unsafe.getByte(memOffset) & 0xFF];
            hash *= 3;
            ++memOffset;
        }
        return hash;
    }

    private static int addBytesToChunkedHash(UnsafeWrapper unsafe, long memOffset, int length, int hash) {
        long endPos = memOffset + (long)length;
        while (memOffset < endPos) {
            int nextInt = 0;
            for (int i = 0; i < 4 && memOffset < endPos; ++memOffset, ++i) {
                nextInt <<= 8;
                nextInt += unsafe.getByte(memOffset) & 0xFF;
            }
            hash = 31 * hash + nextInt;
        }
        return hash;
    }

    public static int addBytesToBucketHash(OffHeapByteSource bs, int offset, int length, int hash, int typeId) {
        if (bs != null) {
            return ServerResolverUtils.addBytesToBucketHash(UnsafeMemoryChunk.getUnsafeWrapper(), bs.getUnsafeAddress(offset, length), length, hash, typeId);
        }
        return hash;
    }

    public static int addBytesToBucketHash(UnsafeWrapper unsafe, long memOffset, int length, int hash, int typeId) {
        switch (typeId) {
            case 7: 
            case 10: 
            case 11: 
            case 80: 
            case 83: 
            case 84: 
            case 195: 
            case 199: {
                return ServerResolverUtils.addBytesToChunkedHash(unsafe, memOffset, length, hash);
            }
        }
        return ServerResolverUtils.addBytesToHash(unsafe, memOffset, length, hash);
    }
}

