/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ComparisonQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ValueQueryInfo;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.shared.common.ColumnRoutingObjectInfo;

public class ValueListQueryInfo
extends AbstractQueryInfo
implements ValueQueryInfo {
    private final ValueQueryInfo[] valueArray;
    private final boolean isListDynamic;

    public ValueListQueryInfo(ValueQueryInfo[] vqiArr, boolean isListDynamic) {
        this.valueArray = vqiArr;
        this.isListDynamic = isListDynamic;
    }

    public Object[] evaluate(Activation activation) throws StandardException {
        int len = this.valueArray.length;
        Object[] retVal = new Object[len];
        for (int i = 0; i < len; ++i) {
            retVal[i] = this.valueArray[i].evaluate(activation);
        }
        return retVal;
    }

    int getSize() {
        return this.valueArray.length;
    }

    @Override
    public boolean isDynamic() {
        return this.isListDynamic;
    }

    public Object[] getPrimaryKey() throws StandardException {
        int len = this.valueArray.length;
        Object[] pkArrr = new Object[len];
        for (int i = 0; i < len; ++i) {
            pkArrr[i] = this.valueArray[i].getPrimaryKey();
        }
        return pkArrr;
    }

    public Object[] getIndexKey() throws StandardException {
        int len = this.valueArray.length;
        Object[] pkArrr = new Object[len];
        for (int i = 0; i < len; ++i) {
            pkArrr[i] = this.valueArray[i].getIndexKey();
        }
        return pkArrr;
    }

    ValueQueryInfo[] getOperands() {
        return this.valueArray;
    }

    @Override
    public DataValueDescriptor evaluateToGetDataValueDescriptor(Activation activation) throws StandardException {
        throw new UnsupportedOperationException("This method is not supported . Invoke evaluateToGetDataValueDescriptorArray(Activation) instead.");
    }

    @Override
    public DataValueDescriptor[] evaluateToGetDataValueDescriptorArray(Activation activation) throws StandardException {
        int len = this.valueArray.length;
        DataValueDescriptor[] dvdArr = new DataValueDescriptor[len];
        for (int i = 0; i < len; ++i) {
            dvdArr[i] = this.valueArray[i].evaluateToGetDataValueDescriptor(activation);
        }
        return dvdArr;
    }

    @Override
    public ColumnRoutingObjectInfo[] evaluateToGetColumnInfos(Activation activation) throws StandardException {
        int len = this.valueArray.length;
        ColumnRoutingObjectInfo[] ret = new ColumnRoutingObjectInfo[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = ComparisonQueryInfo.getAppropriateRoutingObjectInfo(activation, this.valueArray[i], null);
        }
        return ret;
    }

    @Override
    public int typeOfValue() {
        return 3;
    }

    @Override
    public int evaluateToGetParameterNumber(Activation activation) throws StandardException {
        throw new UnsupportedOperationException("evaluateToGetParameterNumber should not be called for ValueLiastQueryInfo");
    }

    @Override
    public int[] evaluateToGetParameterArray(Activation activation) throws StandardException {
        throw new UnsupportedOperationException("evaluateToGetParameterArray should not be called for ValueLiastQueryInfo");
    }

    @Override
    public DataValueDescriptor evaluateToGetConstant(Activation activation) throws StandardException {
        throw new UnsupportedOperationException("evaluateToGetConstant should not be called for ValueLiastQueryInfo");
    }

    @Override
    public DataValueDescriptor[] evaluateToGetConstantArray(Activation activation) throws StandardException {
        throw new UnsupportedOperationException("evaluateToGetConstantArray should not be called for ValueLiastQueryInfo");
    }

    @Override
    public Object[] evaluateToGetObjectArray(Activation activation) throws StandardException {
        int len = this.valueArray.length;
        Object[] objArr = new Object[len];
        block4: for (int i = 0; i < len; ++i) {
            int type = this.valueArray[i].typeOfValue();
            switch (type) {
                case 0: {
                    objArr[i] = this.valueArray[i].evaluateToGetParameterNumber(activation);
                    continue block4;
                }
                case 1: 
                case 2: {
                    objArr[i] = this.valueArray[i].evaluateToGetConstant(activation);
                    continue block4;
                }
                default: {
                    throw new GemFireXDRuntimeException("ValueQueryInfo type: " + type + " not expected here");
                }
            }
        }
        return objArr;
    }

    @Override
    public int getParamType(Activation activation) throws StandardException {
        throw new UnsupportedOperationException("Override the method appropriately");
    }

    @Override
    public int getMaximumWidth() {
        return 0;
    }
}

