/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.PrimaryDynamicKey;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ValueQueryInfo;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.shared.common.ColumnRoutingObjectInfo;

public final class ParameterQueryInfo
extends AbstractQueryInfo
implements ValueQueryInfo {
    private final int paramIndex;
    private int maxwidth;

    public ParameterQueryInfo(int index) {
        this.paramIndex = index;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public Object getPrimaryKey() {
        return new PrimaryDynamicKey(this);
    }

    @Override
    public Object getIndexKey() {
        return new PrimaryDynamicKey(this);
    }

    @Override
    public Object evaluate(Activation activation) throws StandardException {
        ParameterValueSet pvs = activation.getParameterValueSet();
        return pvs.getParameter(this.paramIndex).getObject();
    }

    @Override
    public DataValueDescriptor evaluateToGetDataValueDescriptor(Activation activation) throws StandardException {
        ParameterValueSet pvs = activation.getParameterValueSet();
        return pvs.getParameter(this.paramIndex);
    }

    @Override
    public DataValueDescriptor[] evaluateToGetDataValueDescriptorArray(Activation activation) throws StandardException {
        throw new UnsupportedOperationException("This method is not supported . Invoke evaluateToGetDataValueDescriptor(Activation) instead.");
    }

    @Override
    public int typeOfValue() {
        return 0;
    }

    @Override
    public int evaluateToGetParameterNumber(Activation activation) throws StandardException {
        return this.paramIndex;
    }

    @Override
    public int[] evaluateToGetParameterArray(Activation activation) throws StandardException {
        throw new UnsupportedOperationException("evaluateToGetParameterArray method is not supported . Invoke evaluateToGetParameterNumber(Activation) instead.");
    }

    @Override
    public DataValueDescriptor evaluateToGetConstant(Activation activation) throws StandardException {
        throw new UnsupportedOperationException("evaluateToGetConstant should not be called for ParameterQueryInfo");
    }

    @Override
    public DataValueDescriptor[] evaluateToGetConstantArray(Activation activation) throws StandardException {
        throw new UnsupportedOperationException("evaluateToGetConstantArray should not be called for ParameterQueryInfo");
    }

    @Override
    public Object[] evaluateToGetObjectArray(Activation activation) throws StandardException {
        throw new UnsupportedOperationException("evaluateToGetObjectArray should not be called for ParameterQueryInfo");
    }

    @Override
    public int getParamType(Activation activation) throws StandardException {
        activation.getParameterValueSet();
        ExecPreparedStatement ps = activation.getPreparedStatement();
        DataTypeDescriptor dtd = ps.getParameterTypes()[this.paramIndex];
        return dtd.getDVDTypeFormatId();
    }

    @Override
    public ColumnRoutingObjectInfo[] evaluateToGetColumnInfos(Activation activation) {
        return null;
    }

    public void setMaximumWidth(int length) {
        this.maxwidth = length;
    }

    @Override
    public int getMaximumWidth() {
        return this.maxwidth;
    }

    public int hashCode() {
        return this.paramIndex * 3;
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == ParameterQueryInfo.class) {
            return this.paramIndex == ((ParameterQueryInfo)other).paramIndex;
        }
        return false;
    }
}

