/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.gemstone.gnu.trove.THashMap;
import com.gemstone.gnu.trove.THashSet;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.TableQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.ArrayList;
import java.util.EnumSet;

public abstract class NcjHashMapWrapper {
    public static int MINUS_ONE = -1;

    private NcjHashMapWrapper() {
    }

    public static String getEnumValues() {
        StringBuilder strBldr = new StringBuilder();
        strBldr.append(" { ");
        for (Local lenum : EnumSet.allOf(Local.class)) {
            strBldr.append((Object)lenum);
            strBldr.append(":");
            strBldr.append(lenum.value);
            strBldr.append(", ");
        }
        strBldr.append("}");
        return strBldr.toString();
    }

    public static int getSecondTablePositionIndex() {
        return Local.ONE.value;
    }

    public static int getFirstTablePositionIndex() {
        return Local.ZERO.value;
    }

    static int getMaxTableAllowed() {
        return Local.MAXTABLES.value;
    }

    static int getTotalTableAllowed() {
        return Local.TOTALTABLES.value;
    }

    private static void addValue(THashMap ncjMetaData, int index, String val) {
        if (val == null) {
            SanityManager.THROWASSERT((String)("Null not allowed for index=" + index));
        }
        ncjMetaData.put((Object)index, (Object)val);
    }

    private static String getValue(THashMap ncjMetaData, int index) {
        Object val = ncjMetaData.get((Object)index);
        if (val != null) {
            return (String)val;
        }
        return null;
    }

    private static boolean isEquals(THashMap ncjMetaData, int index, String otherVal) {
        if (otherVal == null) {
            return false;
        }
        Object val = ncjMetaData.get((Object)index);
        if (val != null && val instanceof String) {
            String strVal = (String)val;
            return strVal == otherVal || strVal.equals(otherVal);
        }
        return false;
    }

    private static void addToArrayList(THashMap ncjMetaData, int index, String val) {
        ArrayList<String> valList;
        Object obj;
        if (val == null) {
            SanityManager.THROWASSERT((String)("Null not allowed for index=" + index));
        }
        if ((obj = ncjMetaData.get((Object)index)) == null) {
            valList = new ArrayList<String>(Local.MAXTABLES.value);
            ncjMetaData.put((Object)index, valList);
        } else {
            valList = (ArrayList<String>)obj;
        }
        valList.add(val);
    }

    private static ArrayList<String> getArrayList(THashMap ncjMetaData, int index) {
        Object val = ncjMetaData.get((Object)index);
        if (val != null && val instanceof ArrayList) {
            return (ArrayList)val;
        }
        return null;
    }

    private static void addToTHashSet(THashMap ncjMetaData, int index, String val) {
        THashSet valSet;
        Object obj;
        if (val == null) {
            SanityManager.THROWASSERT((String)("Null not allowed for index=" + index));
        }
        if ((obj = ncjMetaData.get((Object)index)) == null) {
            valSet = new THashSet(Local.MAXTABLES.value);
            ncjMetaData.put((Object)index, (Object)valSet);
        } else {
            valSet = (THashSet)obj;
        }
        valSet.add((Object)val);
    }

    private static THashSet getTHashSet(THashMap ncjMetaData, int index) {
        Object val = ncjMetaData.get((Object)index);
        if (val != null && val instanceof THashSet) {
            return (THashSet)val;
        }
        return null;
    }

    static void addTableAtFirstPosition(THashMap ncjMetaData, String strVal, boolean isPull, TableQueryInfo logTqi) {
        if (isPull) {
            NcjHashMapWrapper.addToTHashSet(ncjMetaData, Local.PULLTABLES.value, strVal);
        }
        NcjHashMapWrapper.addValue(ncjMetaData, Local.FIRSTTABLE.value, strVal);
        if (GemFireXDUtils.TraceNCJIter) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJIter", (String)("Added Table " + strVal + " at first Position. isRemotePull= " + isPull + " ,tqi=" + logTqi));
        }
    }

    static void addTableAtSecondPosition(THashMap ncjMetaData, String strVal, boolean isPull, TableQueryInfo logTqi) {
        if (isPull) {
            NcjHashMapWrapper.addToTHashSet(ncjMetaData, Local.PULLTABLES.value, strVal);
        }
        NcjHashMapWrapper.addValue(ncjMetaData, Local.SECONDTABLE.value, strVal);
        if (GemFireXDUtils.TraceNCJIter) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJIter", (String)("Added Table " + strVal + " at second Position. isRemotePull= " + isPull + " ,tqi=" + logTqi));
        }
    }

    static void addTableAtHigherPosition(THashMap ncjMetaData, String strVal, boolean isPull, TableQueryInfo logTqi) {
        if (isPull) {
            NcjHashMapWrapper.addToTHashSet(ncjMetaData, Local.PULLTABLES.value, strVal);
        }
        NcjHashMapWrapper.addToArrayList(ncjMetaData, Local.HIGHERJOINORDER.value, strVal);
        if (GemFireXDUtils.TraceNCJIter) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJIter", (String)("Added Table " + strVal + " at next Position. isRemotePull= " + isPull + " ,tqi=" + logTqi));
        }
    }

    public static boolean isTabForPull(THashMap ncjMetaData, String strVal) {
        THashSet tSet;
        if (strVal != null && (tSet = NcjHashMapWrapper.getTHashSet(ncjMetaData, Local.PULLTABLES.value)) != null && tSet.size() > 0) {
            return tSet.contains((Object)strVal);
        }
        return false;
    }

    public static boolean isTabAtSecondPosition(THashMap ncjMetaData, String strVal) {
        SanityManager.ASSERT((strVal != null ? 1 : 0) != 0);
        return NcjHashMapWrapper.isEquals(ncjMetaData, Local.SECONDTABLE.value, strVal);
    }

    public static boolean isTabAtFirstPosition(THashMap ncjMetaData, String strVal) {
        SanityManager.ASSERT((strVal != null ? 1 : 0) != 0);
        return NcjHashMapWrapper.isEquals(ncjMetaData, Local.FIRSTTABLE.value, strVal);
    }

    public static int indexOfHigherLevelJoinOrder(THashMap ncjMetaData, String strVal) {
        ArrayList<String> tList = NcjHashMapWrapper.getArrayList(ncjMetaData, Local.HIGHERJOINORDER.value);
        if (tList != null && tList.size() > 0) {
            SanityManager.ASSERT((strVal != null ? 1 : 0) != 0);
            return tList.indexOf(strVal);
        }
        return MINUS_ONE;
    }

    public static int sizeOfHigherLevelJoinOrder(THashMap ncjMetaData) {
        ArrayList<String> tList = NcjHashMapWrapper.getArrayList(ncjMetaData, Local.HIGHERJOINORDER.value);
        if (tList != null) {
            return tList.size();
        }
        return 0;
    }

    public static int getNoOfTabsForPull(THashMap ncjMetaData) {
        THashSet tSet = NcjHashMapWrapper.getTHashSet(ncjMetaData, Local.PULLTABLES.value);
        if (tSet != null) {
            return tSet.size();
        }
        return 0;
    }

    public static int getNoOfTabsForPullAtFirstLevel(THashMap ncjMetaData) {
        int count = 0;
        if (NcjHashMapWrapper.isTabForPull(ncjMetaData, NcjHashMapWrapper.getValue(ncjMetaData, Local.FIRSTTABLE.value))) {
            ++count;
        }
        if (NcjHashMapWrapper.isTabForPull(ncjMetaData, NcjHashMapWrapper.getValue(ncjMetaData, Local.SECONDTABLE.value))) {
            ++count;
        }
        return count;
    }

    private static void addIntValue(THashMap ncjMetaData, int index, int val) {
        ncjMetaData.put((Object)index, (Object)val);
    }

    private static Integer getIntValue(THashMap ncjMetaData, int index) {
        Object val = ncjMetaData.get((Object)index);
        if (val instanceof Integer) {
            return (Integer)val;
        }
        return null;
    }

    public static void setBatchSize(THashMap ncjMetaData, int intVal) {
        NcjHashMapWrapper.addIntValue(ncjMetaData, Local.BATCHSIZE.value, intVal);
        if (GemFireXDUtils.TraceNCJIter) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJIter", (String)("Added Batch Size = " + intVal));
        }
    }

    public static int getBatchSize(THashMap ncjMetaData) {
        Integer value = NcjHashMapWrapper.getIntValue(ncjMetaData, Local.BATCHSIZE.value);
        if (value != null) {
            return value;
        }
        return 0;
    }

    public static void setCacheSize(THashMap ncjMetaData, int intVal) {
        NcjHashMapWrapper.addIntValue(ncjMetaData, Local.CACHESIZE.value, intVal);
        if (GemFireXDUtils.TraceNCJIter) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJIter", (String)("Added Cache Size = " + intVal));
        }
    }

    public static int getCacheSize(THashMap ncjMetaData) {
        Integer value = NcjHashMapWrapper.getIntValue(ncjMetaData, Local.CACHESIZE.value);
        if (value != null) {
            return value;
        }
        return 0;
    }

    private static enum Local {
        ZERO(0),
        ONE(1),
        MAXTABLES(4),
        TOTALTABLES(8),
        FIRSTTABLE(-91),
        SECONDTABLE(-92),
        PULLTABLES(-99),
        HIGHERJOINORDER(-100),
        BATCHSIZE(500),
        CACHESIZE(501);

        private int value;

        private Local(int value) {
            this.value = value;
        }
    }
}

