/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.message;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.FunctionExecutionException;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.SnappyResultHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.execution.LeadNodeExecutionObject;
import com.pivotal.gemfirexd.internal.engine.distributed.message.MemberExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.snappy.CallbackFactoryProvider;
import com.pivotal.gemfirexd.internal.snappy.InterpreterExecute;
import com.pivotal.gemfirexd.internal.snappy.LeadNodeExecutionContext;
import com.pivotal.gemfirexd.internal.snappy.SparkSQLExecute;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public final class LeadNodeExecutorMsg
extends MemberExecutorMessage<Object> {
    private LeadNodeExecutionContext ctx;
    private transient SparkSQLExecute exec;
    private LeadNodeExecutionObject execObject;
    private static final Pattern PARSE_EXCEPTION = Pattern.compile("(Pars[a-zA-Z]*Exception)|(Pars[a-zA-Z]*Error)");
    private static final Pattern EXEC_COMMAND = Pattern.compile("\\s*EXEC\\s+SCALA\\s+.*", 34);

    public LeadNodeExecutorMsg(LeadNodeExecutionContext ctx, GfxdResultCollector<Object> rc, LeadNodeExecutionObject execObject) {
        super(rc, (TXStateInterface)null, false, true);
        this.execObject = execObject;
        this.ctx = ctx;
    }

    public LeadNodeExecutorMsg() {
        super(true);
    }

    @Override
    public Set<DistributedMember> getMembers() {
        return Misc.getLeadNodes();
    }

    @Override
    public void postExecutionCallback() {
    }

    @Override
    public boolean isHA() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    protected void execute() throws Exception {
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        CallbackFactoryProvider.getClusterCallbacks().setLeadClassLoader();
        try {
            if (this.interpreterExecution()) {
                return;
            }
            Logger logger = null;
            if (GemFireXDUtils.TraceQuery) {
                logger = Logger.getLogger(this.getClass());
                StringBuilder str = new StringBuilder();
                this.appendFields(str);
                logger.info((Object)("LeadNodeExecutorMsg.execute: Got sql = " + str.toString()));
            }
            InternalDistributedMember m = this.getSenderForReply();
            Version v = m.getVersionObject();
            this.exec = this.execObject.getSparkSQlExecute(v, this.ctx, null);
            SnappyResultHolder srh = new SnappyResultHolder(this.exec, this.execObject.isUpdateOrDeleteOrPut());
            srh.prepareSend(this, this.execObject);
            this.lastResultSent = true;
            this.endMessage();
            if (GemFireXDUtils.TraceQuery) {
                assert (logger != null);
                logger.info((Object)"LeadNodeExecutorMsg.execute: Sent Last result ");
            }
        }
        catch (Exception ex) {
            Exception serverException = LeadNodeExecutorMsg.getExceptionToSendToServer(ex);
            Logger.getLogger(this.getClass()).warn((Object)("LeadNodeExecutorMsg.execute: failed with exception: " + ex));
            throw serverException;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    private boolean interpreterExecution() throws Exception {
        String sql = this.execObject.getSql();
        if (sql != null && EXEC_COMMAND.matcher(sql).matches()) {
            String user = this.ctx.getUserName() != null ? this.ctx.getUserName().toLowerCase() : "APP";
            InternalDistributedMember member = this.getSenderForReply();
            Version v = member.getVersionObject();
            InterpreterExecute intpexec = CallbackFactoryProvider.getClusterCallbacks().getInterpreterExecution(sql, v, this.ctx.getConnId());
            Object results = intpexec.execute(user, this.ctx.getAuthToken());
            if (results instanceof String[]) {
                SnappyResultHolder srh = new SnappyResultHolder((String[])results);
                this.lastResult(srh);
            } else {
                this.exec = this.execObject.getSparkSQlExecute(v, this.ctx, results);
                SnappyResultHolder srh = new SnappyResultHolder(this.exec, false);
                srh.prepareSend(this, this.execObject);
                this.lastResultSent = true;
                this.endMessage();
            }
            return true;
        }
        return false;
    }

    public static Exception getExceptionToSendToServer(Exception ex) {
        boolean wrapException = true;
        Exception sparkEx = null;
        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
            if (cause instanceof StandardException || cause instanceof SQLException) {
                return cause;
            }
            String causeName = cause.getClass().getName();
            if (causeName.contains("parboiled") || PARSE_EXCEPTION.matcher(causeName).find()) {
                return StandardException.newException("42X01", !wrapException ? cause : new SparkExceptionWrapper(cause), (Object)cause.getMessage());
            }
            if (causeName.contains("AnalysisException") || causeName.contains("NoSuch") || causeName.contains("NotFound")) {
                return StandardException.newException("42000", !wrapException ? cause : new SparkExceptionWrapper(cause), (Object)cause.getMessage());
            }
            if (causeName.contains("apache.spark.storage")) {
                return StandardException.newException("XSDA4.S", !wrapException ? cause : new SparkExceptionWrapper(cause), (Object)cause.getMessage());
            }
            if (causeName.contains("apache.spark.sql")) {
                for (Throwable nestedCause = cause.getCause(); nestedCause != null; nestedCause = nestedCause.getCause()) {
                    if (!nestedCause.getClass().getName().contains("ErrorLimitExceededException")) continue;
                    return StandardException.newException("38000", !wrapException ? nestedCause : new SparkExceptionWrapper(nestedCause), (Object)nestedCause.getMessage());
                }
                return StandardException.newException("38000", !wrapException ? cause : new SparkExceptionWrapper(cause), (Object)cause.getMessage());
            }
            if (!causeName.contains("SparkException")) continue;
            sparkEx = cause;
        }
        if (sparkEx != null) {
            return StandardException.newException("38000", (Throwable)(!wrapException ? sparkEx : new SparkExceptionWrapper(sparkEx)), (Object)sparkEx.getMessage());
        }
        return ex;
    }

    @Override
    protected void executeFunction(boolean enableStreaming) throws StandardException, SQLException {
        try {
            super.executeFunction(enableStreaming);
        }
        catch (RuntimeException re) {
            throw LeadNodeExecutorMsg.handleLeadNodeRuntimeException(re);
        }
    }

    public static Exception handleLeadNodeException(Exception e, String sql) {
        Exception cause = e instanceof RuntimeException ? LeadNodeExecutorMsg.handleLeadNodeRuntimeException((RuntimeException)e) : e;
        return GemFireXDRuntimeException.newRuntimeException("Failure for " + sql, cause);
    }

    public static RuntimeException handleLeadNodeRuntimeException(RuntimeException re) {
        DiskAccessException dae;
        RegionDestroyedException rde;
        Throwable cause = re;
        if (re instanceof GemFireXDRuntimeException || re instanceof FunctionException || re instanceof FunctionExecutionException || re instanceof ReplyException) {
            cause = re.getCause();
        }
        if (cause instanceof RegionDestroyedException && (rde = (RegionDestroyedException)cause).isRemote()) {
            rde.setNotRemote();
        }
        if (cause instanceof DiskAccessException && (dae = (DiskAccessException)cause).isRemote()) {
            dae.setNotRemote();
        }
        return re;
    }

    @Override
    protected LeadNodeExecutorMsg clone() {
        LeadNodeExecutorMsg msg = new LeadNodeExecutorMsg(this.ctx, (GfxdResultCollector)this.userCollector, this.execObject);
        msg.exec = this.exec;
        return msg;
    }

    @Override
    public byte getGfxdID() {
        return 56;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.ctx = (LeadNodeExecutionContext)DataSerializer.readObject((DataInput)in);
        this.execObject = (LeadNodeExecutionObject)DataSerializer.readObject((DataInput)in);
    }

    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject((Object)this.ctx, (DataOutput)out);
        DataSerializer.writeObject((Object)this.execObject, (DataOutput)out);
    }

    @Override
    public void appendFields(StringBuilder sb) {
        sb.append(this.execObject.toString());
    }

    @Override
    public void reset() {
        super.reset();
        this.execObject.reset();
    }

    private static class SparkExceptionWrapper
    extends Exception {
        private static final long serialVersionUID = -4668836542769295434L;

        public SparkExceptionWrapper(Throwable ex) {
            super(ex.getClass().getName() + ": " + ex.getMessage(), ex.getCause() != null ? new SparkExceptionWrapper(ex.getCause()) : null);
            this.setStackTrace(ex.getStackTrace());
        }
    }
}

