/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.pivotal.gemfirexd.internal.engine.distributed.ResultHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.concurrent.TimeUnit;

public final class GfxdSingleResultCollector
implements ResultCollector<Object, Object> {
    private volatile Object result;
    private final Object ignoreToken;

    public GfxdSingleResultCollector() {
        this.ignoreToken = null;
    }

    public GfxdSingleResultCollector(Object ignoreToken) {
        this.ignoreToken = ignoreToken;
    }

    public void addResult(DistributedMember memberID, Object resultOfSingleExecution) {
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("received addResult from member " + memberID + ": " + resultOfSingleExecution));
        }
        if (this.ignoreToken != null && this.ignoreToken.equals(resultOfSingleExecution)) {
            return;
        }
        if (this.result != null) {
            throw new GemFireXDRuntimeException(this.toString() + ": unexpected result " + resultOfSingleExecution + " with existing result " + this.result);
        }
        if (GemFireXDUtils.TraceFunctionException && resultOfSingleExecution instanceof Throwable) {
            SanityManager.DEBUG_PRINT((String)"TraceFunctionException", (String)("unexpected throwable received in addResult from member " + memberID), (Throwable)((Throwable)resultOfSingleExecution));
        }
        this.result = resultOfSingleExecution;
    }

    public Object getResult() throws FunctionException {
        if (GemFireXDUtils.TraceFunctionException && this.result instanceof Throwable) {
            throw new AssertionError((Object)("unexpected Throwable as result: " + this.result));
        }
        return this.result;
    }

    public Object getResult(long timeout, TimeUnit unit) throws FunctionException, InterruptedException {
        throw new AssertionError((Object)"getResult with timeout not expected to be invoked for GemFireXD");
    }

    public void clearResults() {
        if (GemFireXDUtils.isOffHeapEnabled() && this.result instanceof ResultHolder) {
            ((ResultHolder)this.result).freeOffHeapForCachedRowsAndCloseResultSet();
        }
        this.result = null;
    }

    public void endResults() {
    }
}

