/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResponseCode;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class GfxdReplyMessageProcessor
extends DirectReplyProcessor {
    private GfxdResponseCode responseCode = GfxdResponseCode.GRANT(1);
    private DistributedMember responseMember;
    private HashMap<DistributedMember, ReplyException> exceptions;
    private volatile ReplyException firstReplyException;

    public GfxdReplyMessageProcessor(DM dm, Set<DistributedMember> members, boolean register) {
        super(dm, dm.getSystem(), members, null);
        if (register) {
            super.register();
        }
    }

    public GfxdReplyMessageProcessor(DM dm, InternalDistributedMember member, boolean register) {
        super(dm, member);
        if (register) {
            super.register();
        }
    }

    public synchronized Set<DistributedMember> reset() {
        this.responseCode = GfxdResponseCode.GRANT(1);
        this.responseMember = null;
        this.exception = null;
        this.exceptions = null;
        return this.virtualReset();
    }

    protected abstract Set<DistributedMember> virtualReset();

    public final synchronized void setResponseCode(GfxdResponseCode code, DistributedMember member) {
        if (!this.responseCode.isException()) {
            if (code.isException() || code.isTimeout()) {
                this.responseCode = code;
                this.responseMember = member;
            } else if (code.isWaiting() && this.responseCode.isGrant()) {
                this.responseCode = code;
                this.responseMember = member;
            }
        }
    }

    public final GfxdResponseCode getResponseCode() {
        return this.responseCode;
    }

    public final DistributedMember getResponseMember() {
        return this.responseMember;
    }

    public final ReplyException getReplyException() {
        return this.exception;
    }

    private void setReplyException() {
        if (this.exception == null) {
            this.exception = this.firstReplyException;
        }
    }

    public final synchronized Map<DistributedMember, ReplyException> getReplyExceptions() {
        if (this.exceptions != null) {
            return new HashMap<DistributedMember, ReplyException>(this.exceptions);
        }
        return null;
    }

    protected synchronized void processExceptionFromMember(InternalDistributedMember member, ReplyException ex) {
        ReplyException replyEx;
        if (DistributionManager.VERBOSE | GemFireXDUtils.TraceFunctionException) {
            SanityManager.DEBUG_PRINT((String)"TraceFunctionException", (String)(this.toString() + " processExceptionFromMember: for member " + member + " received exception " + ex));
        }
        if ((replyEx = this.firstReplyException) == null || GemFireXDUtils.retryToBeDone(replyEx.getCause())) {
            this.firstReplyException = ex;
        }
        if (this.isExpectingDirectReply()) {
            this.setReplyException();
        }
        if (member != null) {
            if (this.exceptions == null) {
                this.exceptions = new HashMap();
            }
            this.exceptions.put((DistributedMember)member, ex);
        }
    }

    protected void postFinish() {
        super.postFinish();
        this.setReplyException();
    }

    protected final void processException(DistributionMessage msg, ReplyException ex) {
        this.processExceptionFromMember(msg.getSender(), ex);
    }

    protected final void processException(ReplyException ex) {
        this.processExceptionFromMember(ex.getSender(), ex);
    }

    protected boolean stopBecauseOfExceptions() {
        return false;
    }

    protected final boolean stillWaiting() {
        if (this.isExpectingDirectReply()) {
            return false;
        }
        if (this.shutdown) {
            ReplyException re;
            this.exception = re = new ReplyException((Throwable)new DistributedSystemDisconnectedException(LocalizedStrings.ReplyProcessor21_ABORTED_DUE_TO_SHUTDOWN.toLocalizedString()));
            return false;
        }
        return this.numMembers() > 0;
    }

    protected void checkIfDone() {
        if (!this.stillWaiting()) {
            this.finished();
        }
    }
}

