/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.internal.util.concurrent.StoppableCountDownLatch;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollectorHelper;
import com.pivotal.gemfirexd.internal.engine.distributed.OffHeapReleaseUtil;
import com.pivotal.gemfirexd.internal.engine.distributed.ResultHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class GfxdQueryResultCollector
extends ArrayList<Object>
implements GfxdResultCollector<Object> {
    private static final long serialVersionUID = 8434972705144037747L;
    protected final CancelCriterion stopper = Misc.getGemFireCache().getCancelCriterion();
    protected volatile StoppableCountDownLatch latch = new StoppableCountDownLatch(this.stopper, 1);
    protected volatile FunctionException functionException;
    protected final GfxdResultCollectorHelper helper;

    public GfxdQueryResultCollector() {
        this(8);
    }

    public GfxdQueryResultCollector(int initialCapacity) {
        this(initialCapacity, new GfxdResultCollectorHelper());
    }

    private GfxdQueryResultCollector(int initialCapacity, GfxdResultCollectorHelper helper) {
        super(initialCapacity);
        this.helper = helper;
    }

    @Override
    public final void setResultMembers(Set<DistributedMember> members) {
        this.helper.setResultMembers(members);
    }

    @Override
    public final Set<DistributedMember> getResultMembers() {
        return this.helper.getResultMembers();
    }

    @Override
    public final boolean setupContainersToClose(Collection<GemFireContainer> containers, GemFireTransaction tran) throws StandardException {
        return false;
    }

    @Override
    public void setNumRecipients(int n) {
    }

    @Override
    public GfxdResultCollectorHelper getStreamingHelper() {
        return null;
    }

    public void setProcessor(ReplyProcessor21 processor) {
    }

    public ReplyProcessor21 getProcessor() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResult(DistributedMember member, Object resultOfSingleExecution) {
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)(this.toString() + "#addResult: adding result: " + resultOfSingleExecution + " from member: " + member));
        }
        if (resultOfSingleExecution == null) {
            return;
        }
        boolean addMember = true;
        Throwable t = null;
        if (resultOfSingleExecution instanceof Throwable) {
            t = (Throwable)resultOfSingleExecution;
            this.addException(t, member);
            addMember = false;
        } else if (resultOfSingleExecution instanceof ResultHolder) {
            ResultHolder rh = (ResultHolder)resultOfSingleExecution;
            rh.applyRemoteTXChanges(member);
            t = rh.getException();
            if (t != null) {
                this.addException(t, member);
                addMember = false;
            }
        }
        if (addMember) {
            this.helper.addResultMember(member);
        }
        if (t == null) {
            GfxdQueryResultCollector gfxdQueryResultCollector = this;
            synchronized (gfxdQueryResultCollector) {
                long count = this.latch.getCount();
                if (count != 1L) {
                    SanityManager.THROWASSERT((String)("unexpected latch count=" + count));
                }
                this.add(resultOfSingleExecution);
            }
        }
    }

    public Object getResult() throws FunctionException, ReplyException {
        try {
            this.latch.await();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            this.stopper.checkCancelInProgress((Throwable)ie);
        }
        if (this.functionException != null) {
            throw this.functionException;
        }
        return this;
    }

    public final void endResults() {
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)(this.toString() + "#endResults: ending results"));
        }
        this.latch.countDown();
    }

    public Object getResult(long timeout, TimeUnit unit) throws FunctionException {
        throw new FunctionException("getResult with timeout not expected to be invoked in GemFireXD");
    }

    public void setException(Throwable exception) {
        this.addException(exception, (DistributedMember)Misc.getGemFireCache().getMyId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearResults() {
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)(this.toString() + "#clearResults: resetting the latch and clearing results"));
        }
        GfxdQueryResultCollector gfxdQueryResultCollector = this;
        synchronized (gfxdQueryResultCollector) {
            this.clearData();
        }
    }

    protected void clearData() {
        this.latch = new StoppableCountDownLatch(this.stopper, 1);
        this.functionException = null;
        if (GemFireXDUtils.isOffHeapEnabled()) {
            Iterator resultsIter = this.iterator();
            while (resultsIter.hasNext()) {
                Object obj = resultsIter.next();
                if (obj instanceof ResultHolder) {
                    OffHeapReleaseUtil.freeOffHeapReference((ResultHolder)obj);
                }
                resultsIter.remove();
            }
        } else {
            this.clear();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addException(Throwable t, DistributedMember member) {
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)(this.toString() + "#processException: from member [" + member + "] got exception"), (Throwable)t);
        }
        StandardException.fixUpRemoteException(t, member);
        GfxdQueryResultCollector gfxdQueryResultCollector = this;
        synchronized (gfxdQueryResultCollector) {
            this.addExceptionFromMember(t, member);
        }
    }

    protected void addExceptionFromMember(Throwable t, DistributedMember member) {
        if (this.functionException == null) {
            if (t instanceof FunctionException) {
                this.functionException = (FunctionException)t;
                if (t.getCause() != null) {
                    t = t.getCause();
                }
            } else {
                this.functionException = new FunctionException(t);
            }
        }
        this.functionException.addException(t);
    }

    @Override
    public GfxdResultCollector<Object> cloneCollector() {
        return new GfxdQueryResultCollector(8);
    }
}

