/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.internal.StructImpl;
import com.gemstone.gemfire.cache.query.internal.types.ObjectTypeImpl;
import com.gemstone.gemfire.cache.query.internal.types.StructTypeImpl;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.execute.BucketMovedException;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdListResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GfxdConfigMessage;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.jdbc.InternalDriver;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;

public class GfxdDumpLocalResultMessage
extends GfxdMessage {
    private boolean dumpBackingMap;

    public GfxdDumpLocalResultMessage() {
        this.dumpBackingMap = false;
    }

    public GfxdDumpLocalResultMessage(boolean dumpBackingMap) {
        this.dumpBackingMap = dumpBackingMap;
    }

    @Override
    protected void processMessage(DistributionManager dm) {
        block3: {
            LogWriter logger = dm.getLoggerI18n().convertToLogWriter();
            try {
                this.executeLocally((DM)dm, this.dumpBackingMap);
            }
            catch (Exception ex) {
                if (logger.severeEnabled()) {
                    logger.severe("GfxdDumpLocalResultMessage: SQL exception in executing message with fields as " + this.toString(), (Throwable)ex);
                }
                if (this.processorId <= 0 && dm != null) break block3;
                throw new ReplyException("Unexpected SQLException on member " + dm.getDistributionManagerId(), (Throwable)ex);
            }
        }
    }

    @Override
    protected void sendReply(ReplyException ex, DistributionManager dm) {
        ReplyMessage.send((InternalDistributedMember)this.getSender(), (int)this.processorId, (ReplyException)ex, (ReplySender)dm, null);
    }

    @Override
    protected boolean waitForNodeInitialization() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpTables(EmbedConnection conn, String sql) throws SQLException {
        EmbedStatement stmnt = (EmbedStatement)conn.createStatement();
        ResultSet rs = stmnt.executeQueryByPassQueryInfo(sql, false, true, 0, null);
        StructTypeImpl sti = GfxdDumpLocalResultMessage.getStructType(rs);
        StringBuilder aStr = new StringBuilder("ResultSet from gemfirexd is ");
        int size = 0;
        String[] fieldNames = sti.getFieldNames();
        int columnSize = fieldNames.length;
        try {
            while (((EmbedResultSet)rs).lightWeightNext()) {
                Object[] objects = new Object[columnSize];
                for (int i = 0; i < columnSize; ++i) {
                    objects[i] = rs.getObject(fieldNames[i]);
                }
                StructImpl aStruct = new StructImpl(sti, objects);
                aStr.append(aStruct.toString()).append("\n");
                ++size;
                if (aStr.length() <= 0x400000) continue;
                SanityManager.DEBUG_PRINT((String)"dump:localdataset", (String)aStr.toString());
                aStr.setLength(0);
            }
            SanityManager.DEBUG_PRINT((String)"dump:localdataset", (String)aStr.toString());
        }
        finally {
            ((EmbedResultSet)rs).lightWeightClose();
        }
        aStr.append("The size of list is ").append(size).append("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeLocally(DM dm, boolean dumpBackingMap) throws SQLException {
        SanityManager.DEBUG_PRINT((String)"dump:localdataset", (String)("GfxdDumpLocalResultMessage: Executing with fields as: " + this.toString()));
        EmbedConnection conn = (EmbedConnection)InternalDriver.activeDriver().connect("jdbc:gemfirexd:", new Properties());
        conn = conn.getRootConnection();
        ArrayList<String> tablesNames = new ArrayList<String>();
        try (EmbedStatement stmnt1 = (EmbedStatement)conn.createStatement();){
            ResultSet rs1 = stmnt1.executeQuery("select tableschemaname, tablename from sys.systables where tabletype = 'T' ");
            while (rs1.next()) {
                String schemaname = rs1.getString(1);
                String tablename = rs1.getString(2);
                tablesNames.add(schemaname + "." + tablename);
            }
            rs1.close();
        }
        for (String tablename : tablesNames) {
            boolean success;
            String query;
            block15: {
                query = "select * from " + tablename;
                SanityManager.DEBUG_PRINT((String)"dump:localdataset", (String)("GfxdDumpLocalResultMessage: Dumping result of query =: " + query));
                success = false;
                try {
                    if (conn.isClosed() || !conn.isValid(0)) {
                        conn.close();
                        conn = (EmbedConnection)InternalDriver.activeDriver().connect("jdbc:gemfirexd:", new Properties());
                    }
                    this.dumpTables(conn, query);
                    success = true;
                }
                catch (BucketMovedException bucketMovedException) {
                }
                catch (SQLException ex) {
                    boolean ignoreException = false;
                    if (ex.getCause() != null) {
                        if (ex.getCause() instanceof BucketMovedException) {
                            ignoreException = true;
                        } else if (ex.getCause().getCause() != null && ex.getCause().getCause() instanceof BucketMovedException) {
                            ignoreException = true;
                        }
                    }
                    if (!ignoreException) {
                        throw ex;
                    }
                    SanityManager.DEBUG_PRINT((String)"GfxdDumpLocalResultMessage:", (String)(" Ignoring BucketMovedException for sql " + query));
                    if (!this.dumpBackingMap) break block15;
                    SanityManager.DEBUG_PRINT((String)"dump:backingmap", (String)("GfxdDumpLocalResultMessage: Dumping backingmap for " + tablename));
                    Region r = Misc.getRegionForTableByPath(tablename, false);
                    if (!(r instanceof LocalRegion)) break block15;
                    ((LocalRegion)r).dumpBackingMap();
                }
            }
            if (!success) continue;
            SanityManager.DEBUG_PRINT((String)"dump:localdataset", (String)("GfxdDumpLocalResultMessage: Successfully executed query:= " + query));
        }
    }

    @Override
    public byte getGfxdID() {
        return 19;
    }

    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeBoolean(this.dumpBackingMap);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.dumpBackingMap = in.readBoolean();
    }

    private static StructTypeImpl getStructType(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int numOfColumns = rsmd.getColumnCount();
        ObjectType[] oTypes = new ObjectType[numOfColumns];
        String[] fieldNames = new String[numOfColumns];
        for (int i = 0; i < numOfColumns; ++i) {
            block3: {
                try {
                    String className = rsmd.getColumnClassName(i + 1);
                    oTypes[i] = "byte[]".equals(className) ? new ObjectTypeImpl(byte[].class) : ("char[]".equals(className) ? new ObjectTypeImpl(char[].class) : new ObjectTypeImpl(Class.forName(rsmd.getColumnClassName(i + 1))));
                }
                catch (ClassNotFoundException cnfe) {
                    LogWriter logger = Misc.getCacheLogWriter();
                    if (!logger.warningEnabled()) break block3;
                    logger.warning("GfxdDumpLocalResultMessage#getStructType: class not found for " + rsmd.getColumnClassName(i + 1), (Throwable)cnfe);
                }
            }
            fieldNames[i] = rsmd.getColumnName(i + 1);
        }
        StructTypeImpl sType = new StructTypeImpl(fieldNames, oTypes);
        return sType;
    }

    public static void sendBucketInfoDumpMsg(Set<DistributedMember> targetMembers, boolean dumpBackingMap) {
        try {
            GfxdConfigMessage<Object> msg = new GfxdConfigMessage<Object>(new GfxdListResultCollector(), targetMembers, GfxdConfigMessage.Operation.DUMP_BUCKETS, dumpBackingMap ? Boolean.TRUE : Boolean.FALSE, false);
            msg.setHA(false);
            msg.executeFunction();
        }
        catch (Exception ex) {
            throw GemFireXDRuntimeException.newRuntimeException("GfxdDumpLocalResultMessage: unexpected exception", ex);
        }
    }
}

