/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.diag;

import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplate;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.ConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINStatementDescriptor;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;

public class StatementPlansVTI
extends GfxdVTITemplate {
    private ResultSet statementPlans = null;
    private EmbedConnection conn = null;
    boolean runTimeStaticsMode;
    private static ResultColumnDescriptor[] columnInfo;
    private static ResultSetMetaData metadata;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        boolean retVal;
        this.runTimeStaticsMode = false;
        Statement ps = null;
        if (this.statementPlans == null) {
            boolean contextSet = false;
            try {
                ConnectionContext cc = (ConnectionContext)((Object)ContextService.getFactory().getCurrentContextManager().getContext("JDBC_ConnectionContext"));
                this.conn = (EmbedConnection)cc.getNestedConnection(true);
                if (this.conn == null) {
                    this.conn = GemFireXDUtils.getTSSConnection(true, true, true);
                }
                this.conn.getTR().setupContextStack();
                contextSet = true;
                LanguageConnectionContext lcc = this.conn.getLanguageConnection();
                this.runTimeStaticsMode = lcc.getRunTimeStatisticsMode();
                lcc.setRunTimeStatisticsMode(false, true);
                ps = this.conn.prepareStatementByPassQueryInfo(-1L, "select * from SYSSTAT.SYSXPLAIN_STATEMENTS where ORIGIN_MEMBER_ID = CURRENT_MEMBER_ID and LOCALLY_EXECUTED = 'false' ", false, false, false, null, 0L, 0);
                this.statementPlans = ps.executeQuery();
                if (GemFireXDUtils.TracePlanGeneration) {
                    String region = Misc.getRegionPath("SYSSTAT.SYSXPLAIN_STATEMENTS");
                    SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("plans collected locally in this VM is " + Misc.getRegion(region, true, false).size()));
                }
            }
            catch (StandardException se) {
                throw PublicAPI.wrapStandardException(se);
            }
            finally {
                if (contextSet) {
                    this.conn.getTR().restoreContextStack();
                }
                if (this.statementPlans == null && this.conn != null) {
                    this.conn.getLanguageConnection().setRunTimeStatisticsMode(this.runTimeStaticsMode, true);
                    this.conn.close();
                }
            }
        }
        if (!(retVal = this.statementPlans.next())) {
            try {
                this.statementPlans.close();
                if (ps != null) {
                    ps.close();
                }
            }
            finally {
                this.conn.getLanguageConnection().setRunTimeStatisticsMode(this.runTimeStaticsMode, true);
                this.conn.close();
            }
        }
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)(" StatementPlanVTI: returning has more rows = " + retVal));
        }
        return retVal;
    }

    @Override
    protected Object getObjectForColumn(int columnNumber) throws SQLException {
        return this.statementPlans.getObject(columnNumber);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.statementPlans.getString(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.statementPlans.getBoolean(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.statementPlans.getByte(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.statementPlans.getShort(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.statementPlans.getInt(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.statementPlans.getLong(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.statementPlans.getFloat(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.statementPlans.getDouble(columnIndex);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.statementPlans.getBytes(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.statementPlans.getDate(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.statementPlans.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.statementPlans.getTimestamp(columnIndex);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (metadata == null) {
            SystemColumn[] stmtCols = new XPLAINStatementDescriptor().buildColumnList();
            columnInfo = new ResultColumnDescriptor[stmtCols.length];
            for (int i = 0; i < stmtCols.length; ++i) {
                StatementPlansVTI.columnInfo[i] = EmbedResultSetMetaData.getResultColumnDescriptor(stmtCols[i].getName(), stmtCols[i].getType());
            }
            metadata = new EmbedResultSetMetaData(columnInfo);
        }
        return metadata;
    }
}

