/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.diag;

import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.callbacks.CallbackProcedures;
import com.pivotal.gemfirexd.internal.engine.ddl.catalog.GfxdSystemProcedures;
import com.pivotal.gemfirexd.internal.engine.ddl.catalog.messages.GfxdSystemProcedureMessage;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.ConnectionUtil;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import java.sql.SQLException;
import java.sql.Timestamp;

public final class HdfsProcedures
extends GfxdSystemProcedures {
    private HdfsProcedures() {
    }

    public static void dummy() {
    }

    public static long countEstimate(String fqtn) throws SQLException {
        String table;
        String schema;
        if (fqtn == null) {
            throw Util.generateCsSQLException("XIE06.S");
        }
        int dotIndex = fqtn.indexOf(46);
        if (dotIndex >= 0) {
            schema = fqtn.substring(0, dotIndex);
            table = fqtn.substring(dotIndex + 1);
        } else {
            schema = Misc.getDefaultSchemaName(ConnectionUtil.getCurrentLCC());
            table = fqtn;
        }
        try {
            GemFireContainer container = CallbackProcedures.getContainerForTable(schema, table);
            return container.getRegion().sizeEstimate();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static void forceCompaction(String fqtn, Integer maxWaitTime) throws SQLException, StandardException {
        String table;
        String schema;
        if (fqtn == null) {
            throw Util.generateCsSQLException("XIE06.S");
        }
        int dotIndex = fqtn.indexOf(46);
        if (dotIndex >= 0) {
            schema = fqtn.substring(0, dotIndex);
            table = fqtn.substring(dotIndex + 1);
        } else {
            schema = Misc.getDefaultSchemaName(ConnectionUtil.getCurrentLCC());
            table = fqtn;
        }
        try {
            GemFireContainer container = CallbackProcedures.getContainerForTable(schema, table);
            container.getRegion().forceHDFSCompaction(true, maxWaitTime);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        catch (UnsupportedOperationException e) {
            throw StandardException.newException("0A000.S.31", (Throwable)e, (Object)fqtn);
        }
        catch (FunctionException e) {
            throw StandardException.newException("X0Z27.S", (Throwable)e, (Object)e.getLocalizedMessage());
        }
    }

    public static void flushQueue(String fqtn, Integer maxWaitTime) throws SQLException, StandardException {
        String table;
        String schema;
        if (fqtn == null) {
            throw Util.generateCsSQLException("XIE06.S");
        }
        int dotIndex = fqtn.indexOf(46);
        if (dotIndex >= 0) {
            schema = fqtn.substring(0, dotIndex);
            table = fqtn.substring(dotIndex + 1);
        } else {
            schema = Misc.getDefaultSchemaName(ConnectionUtil.getCurrentLCC());
            table = fqtn;
        }
        try {
            GemFireContainer container = CallbackProcedures.getContainerForTable(schema, table);
            container.getRegion().flushHDFSQueue(maxWaitTime.intValue());
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        catch (FunctionException e) {
            throw StandardException.newException("X0Z27.S", (Throwable)e, (Object)e.getLocalizedMessage());
        }
    }

    public static Timestamp HDFS_LAST_MAJOR_COMPACTION(String fqtn) throws SQLException, StandardException {
        String table;
        String schema;
        long ts = 0L;
        if (fqtn == null) {
            throw Util.generateCsSQLException("XIE06.S");
        }
        int dotIndex = fqtn.indexOf(46);
        if (dotIndex >= 0) {
            schema = fqtn.substring(0, dotIndex);
            table = fqtn.substring(dotIndex + 1);
        } else {
            schema = Misc.getDefaultSchemaName(ConnectionUtil.getCurrentLCC());
            table = fqtn;
        }
        try {
            GemFireContainer container = CallbackProcedures.getContainerForTable(schema, table);
            ts = container.getRegion().lastMajorHDFSCompaction();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        catch (UnsupportedOperationException e) {
            throw StandardException.newException("0A000.S.31", (Throwable)e, (Object)fqtn);
        }
        return new Timestamp(ts);
    }

    public static void HDFS_FORCE_WRITEONLY_FILEROLLOVER(String fqtn, int minSizeForFileRollover) throws SQLException, StandardException {
        LocalRegion region = (LocalRegion)Misc.getRegionForTableByPath(fqtn = StringUtil.SQLToUpperCase(fqtn), false);
        if (region == null) {
            throw StandardException.newException("42X05", fqtn);
        }
        if (!region.isHDFSRegion() || region.isHDFSReadWriteRegion()) {
            throw StandardException.newException("0A000.S.34", fqtn);
        }
        Object[] params = new Object[]{fqtn, minSizeForFileRollover};
        GfxdSystemProcedureMessage.SysProcMethod.forceHDFSWriteonlyFileRollover.processMessage(params, (DistributedMember)Misc.getMyId());
        HdfsProcedures.publishMessage(params, false, GfxdSystemProcedureMessage.SysProcMethod.forceHDFSWriteonlyFileRollover, false, false);
    }
}

