/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl.wan;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewayQueueEvent;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.InternalDeltaEvent;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.GatewayEventEnqueueFilter;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventCallbackArgument;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLRegionQueue;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.GfxdGatewayEventListener;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.GfxdCBArgForSynchPrms;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.GfxdGatewaySenderStartMessage;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.GfxdGatewaySenderStopMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdCallbackArgument;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DataDictionaryImpl;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdSysAsyncEventListenerRowFactory;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdSysGatewaySenderRowFactory;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.TabInfoImpl;
import com.pivotal.gemfirexd.internal.jdbc.InternalDriver;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;

public class WanProcedures {
    public static void stopGatewaySender(String id) throws StandardException {
        if (id == null) {
            throw StandardException.newException("XIE06.S");
        }
        try {
            WanProcedures.stopGatewaySenderLocally(id);
            GfxdGatewaySenderStopMessage msg = new GfxdGatewaySenderStopMessage(id, false);
            GfxdDDLRegionQueue queue = Misc.getMemStore().getDDLStmtQueue();
            long replayKey = queue.newUUID();
            msg.setReplayKey(replayKey);
            queue.put(replayKey, msg);
            msg.send(Misc.getGemFireCache().getDistributedSystem(), null);
        }
        catch (StandardException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z22.S", ex, (Object)id, (Object)ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopGatewaySenderLocally(String id) throws Exception {
        GatewaySender sender = Misc.getGemFireCache().getGatewaySender(id.toUpperCase());
        if (sender != null) {
            sender.stop();
            WanProcedures.updateStartStatusToSysTable(sender.getId(), false, false);
        } else if (ServerGroupUtils.isDataStore()) {
            LogWriterI18n logger = Misc.getI18NLogWriter();
            if (logger.warningEnabled()) {
                logger.convertToLogWriter().warning("SYS.STOP_GATEWAY_SENDER: GatewaySender " + id + " is not present on this member");
            }
            LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
            EmbedConnection conn = null;
            boolean contextSet = false;
            try {
                Connection c;
                if (lcc != null) {
                    InternalDriver driver = InternalDriver.activeDriver();
                    c = driver.connect("jdbc:default:connection", null);
                } else {
                    conn = GemFireXDUtils.getTSSConnection(true, true, false);
                    conn.getTR().setupContextStack();
                    contextSet = true;
                    c = conn;
                }
                PreparedStatement ps = c.prepareStatement("select * from SYS.GATEWAYSENDERS where sender_id = ?");
                ps.setString(1, id.toUpperCase());
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) {
                    throw StandardException.newException("X0Z23.S", id);
                }
            }
            finally {
                if (contextSet) {
                    try {
                        conn.internalCommit();
                    }
                    catch (SQLException ex) {
                        SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)"WanProcedures#stopGatewaySenderLocally: exception encountered in commit", (Throwable)ex);
                    }
                    conn.getTR().restoreContextStack();
                }
            }
        }
    }

    public static void stopAsyncQueue(String id) throws StandardException {
        if (id == null) {
            throw StandardException.newException("XIE06.S");
        }
        try {
            WanProcedures.stopAsyncQueueLocally(id);
            GfxdGatewaySenderStopMessage msg = new GfxdGatewaySenderStopMessage(id, true);
            GfxdDDLRegionQueue queue = Misc.getMemStore().getDDLStmtQueue();
            long replayKey = queue.newUUID();
            msg.setReplayKey(replayKey);
            queue.put(replayKey, msg);
            msg.send(Misc.getGemFireCache().getDistributedSystem(), null);
        }
        catch (StandardException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z22.S", ex, (Object)id, (Object)ex.toString());
        }
    }

    public static void stopAsyncQueueLocally(String id) throws Exception {
        LogWriterI18n logger;
        AsyncEventQueue asyncQueue = Misc.getGemFireCache().getAsyncEventQueue(id.toUpperCase());
        if (asyncQueue != null) {
            asyncQueue.stop();
            WanProcedures.updateStartStatusToSysTable(asyncQueue.getId(), true, false);
        } else if (ServerGroupUtils.isDataStore() && (logger = Misc.getI18NLogWriter()).warningEnabled()) {
            logger.convertToLogWriter().warning("SYS.STOP_ASYNCEVENTLISTENER : AsyncEventListener " + id + " is not present on this member");
        }
    }

    public static void startGatewaySender(String id) throws StandardException {
        if (id == null) {
            throw StandardException.newException("XIE06.S");
        }
        try {
            WanProcedures.startGatewaySenderLocally(id);
            GfxdGatewaySenderStartMessage senderStart = new GfxdGatewaySenderStartMessage(id, false);
            GfxdDDLRegionQueue queue = Misc.getMemStore().getDDLStmtQueue();
            long replayKey = queue.newUUID();
            senderStart.setReplayKey(replayKey);
            queue.put(replayKey, senderStart);
            senderStart.send(Misc.getGemFireCache().getDistributedSystem(), null);
        }
        catch (StandardException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z22.S", ex, (Object)id, (Object)ex.toString());
        }
    }

    public static void startGatewaySenderLocally(String id) throws Exception {
        LogWriterI18n logger;
        AbstractGatewaySender sender = (AbstractGatewaySender)Misc.getGemFireCache().getGatewaySender(id.toUpperCase());
        if (sender != null) {
            CancelCriterion cc = sender.getCancelCriterion();
            String str = cc.cancelInProgress();
            if (str == null) {
                try {
                    sender.start();
                    WanProcedures.updateStartStatusToSysTable(sender.getId(), false, true);
                }
                catch (Exception ex) {
                    throw StandardException.newException("X0Z22.S", ex, (Object)id, (Object)ex.toString());
                }
            } else {
                LogWriter logger2 = Misc.getCacheLogWriter();
                if (logger2.warningEnabled()) {
                    logger2.warning(str);
                }
                Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(null);
            }
        } else if (ServerGroupUtils.isDataStore() && (logger = Misc.getI18NLogWriter()).warningEnabled()) {
            logger.convertToLogWriter().warning("SYS.START_GATEWAY_SENDER : GatewaySender " + id + " is not present on this member");
        }
    }

    public static void startAsyncQueue(String id) throws StandardException {
        if (id == null) {
            throw StandardException.newException("XIE06.S");
        }
        try {
            WanProcedures.startAsyncQueueLocally(id);
            GfxdGatewaySenderStartMessage senderStart = new GfxdGatewaySenderStartMessage(id, true);
            GfxdDDLRegionQueue queue = Misc.getMemStore().getDDLStmtQueue();
            long replayKey = queue.newUUID();
            senderStart.setReplayKey(replayKey);
            queue.put(replayKey, senderStart);
            senderStart.send(Misc.getGemFireCache().getDistributedSystem(), null);
        }
        catch (StandardException ex) {
            String asyncListenerRunningWarning = "01508";
            if (ex.getSQLState().equals(asyncListenerRunningWarning) || ex.getCause() instanceof StandardException && ((StandardException)ex.getCause()).getSQLState().equals(asyncListenerRunningWarning)) {
                LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
                if (lcc != null) {
                    lcc.getLastActivation().addWarning(StandardException.newWarning("01508", id));
                }
            }
            throw ex;
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z22.S", ex, (Object)id, (Object)ex.toString());
        }
    }

    public static void startAsyncQueueLocally(String id) throws Exception {
        LogWriterI18n logger;
        AsyncEventQueueImpl asyncQueue = (AsyncEventQueueImpl)Misc.getGemFireCache().getAsyncEventQueue(id.toUpperCase());
        if (asyncQueue != null) {
            CancelCriterion cc = asyncQueue.getSender().getCancelCriterion();
            String str = cc.cancelInProgress();
            if (str == null) {
                if (asyncQueue.isRunning()) {
                    throw StandardException.newException("01508", id);
                }
                try {
                    AsyncEventListener gfListener = asyncQueue.getAsyncEventListener();
                    if (!(gfListener instanceof GfxdGatewayEventListener)) {
                        Assert.fail((Object)("UnExpected Listener type " + gfListener));
                    }
                    GfxdGatewayEventListener listener = (GfxdGatewayEventListener)gfListener;
                    listener.reInit();
                    asyncQueue.start();
                    listener.start();
                    WanProcedures.updateStartStatusToSysTable(asyncQueue.getId(), true, true);
                }
                catch (Exception ex) {
                    throw StandardException.newException("X0Z22.S", ex, (Object)id, (Object)ex.toString());
                }
            } else {
                LogWriter logger2 = Misc.getCacheLogWriter();
                if (logger2.warningEnabled()) {
                    logger2.warning(str);
                }
                Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(null);
            }
        } else if (ServerGroupUtils.isDataStore() && (logger = Misc.getI18NLogWriter()).warningEnabled()) {
            logger.convertToLogWriter().warning("SYS.START_ASYNCEVENTLISTENER : AsyncEventListener " + id + " is not present on this member");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateStartStatusToSysTable(String id, boolean isAsyncEventQueue, boolean isStart) throws StandardException {
        LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
        EmbedConnection conn = null;
        boolean contextSet = false;
        try {
            if (lcc == null) {
                conn = GemFireXDUtils.getTSSConnection(true, true, false);
                lcc = conn.getLanguageConnectionContext();
                conn.getTR().setupContextStack();
                contextSet = true;
            }
            DataDictionaryImpl dd = (DataDictionaryImpl)lcc.getDataDictionary();
            TransactionController tc = lcc.getTransactionExecute();
            ExecIndexRow keyRow = dd.getExecutionFactory().getIndexableRow(1);
            keyRow.setColumn(1, new SQLChar(id));
            TabInfoImpl ti = null;
            if (isAsyncEventQueue) {
                ti = dd.getNonCoreTI(22);
                GfxdSysAsyncEventListenerRowFactory rf = (GfxdSysAsyncEventListenerRowFactory)ti.getCatalogRowFactory();
                ExecRow row = rf.makeEmptyRow();
                row.setColumn(12, new SQLBoolean(isStart));
                boolean[] bArray = new boolean[]{false};
                int[] colsToUpdate = new int[]{12};
                ti.updateRow(keyRow, row, 0, bArray, colsToUpdate, tc);
            } else {
                ti = dd.getNonCoreTI(21);
                GfxdSysGatewaySenderRowFactory rf = (GfxdSysGatewaySenderRowFactory)ti.getCatalogRowFactory();
                ExecRow row = rf.makeEmptyRow();
                row.setColumn(14, new SQLBoolean(isStart));
                boolean[] bArray = new boolean[]{false};
                int[] colsToUpdate = new int[]{14};
                ti.updateRow(keyRow, row, 0, bArray, colsToUpdate, tc);
            }
        }
        finally {
            if (contextSet) {
                conn.getTR().restoreContextStack();
            }
        }
        LogWriterI18n logger = Misc.getI18NLogWriter();
        if (logger.infoEnabled()) {
            logger.convertToLogWriter().info("WanProcedures:: updated AsyncEventListener/GatewaySender " + id + " isAsyncEventListener=" + isAsyncEventQueue + " start=" + isStart + " status in SYS table");
        }
    }

    public static void dummy() {
    }

    public static GatewayEventFilter getAsyncEventFilter() {
        return AsyncEventFilter.filter;
    }

    public static GatewayEventFilter getSerialDBSynchronizerFilter(boolean sendBulkDMLAsString) {
        return BULKDMLOptimizedDBSynchronizerFilter.filter;
    }

    public static GatewayEventFilter getSerialWanFilter(boolean sendBulkDMLAsString) {
        return SerialWanFilter.filter;
    }

    public static GatewayEventFilter getParallelWanFilter() {
        return ParallelWanFilter.filter;
    }

    public static class GfxdWanBULKDMLOptimizedFilter
    extends AsyncEventFilter {
        private static final GatewayEventFilter filter = new GfxdWanBULKDMLOptimizedFilter();

        @Override
        public boolean beforeEnqueue(GatewayQueueEvent event) {
            Operation op = event.getOperation();
            if (GemFireXDUtils.TraceDBSynchronizer) {
                SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)"WanProcedures::GfxdWanBULKDMLOptimizedFilter:enqueueEvent: Into the beforeEnqueue");
            }
            if (op == Operation.BULK_DML_OP) {
                if (GemFireXDUtils.TraceDBSynchronizer) {
                    SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)"WanProcedures::GfxdWanBULKDMLOptimizedFilter:enqueueEvent: Returning true for bulk DML op");
                }
                return true;
            }
            if (super.beforeEnqueue(event)) {
                Object cb = event.getCallbackArgument();
                if (cb instanceof GfxdCallbackArgument) {
                    GfxdCallbackArgument ecb = (GfxdCallbackArgument)cb;
                    if (ecb.isTransactional()) {
                        if (GemFireXDUtils.TraceDBSynchronizer) {
                            SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)"WanProcedures::GfxdWanBULKDMLOptimizedFilter:enqueueEvent: Returning false as even when it is PK based, because it is transactional or inserted via cache loading during get");
                        }
                        return false;
                    }
                    if (ecb.isPkBased()) {
                        GemFireContainer gfc = (GemFireContainer)event.getRegion().getUserAttribute();
                        if (!((InternalDeltaEvent)event).isGFXDCreate(false) || !gfc.getExtraTableInfo().hasAutoGeneratedColumns()) {
                            if (GemFireXDUtils.TraceDBSynchronizer) {
                                SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)"WanProcedures::GfxdWanBULKDMLOptimizedFilter:enqueueEvent: Returning true for PK based event");
                            }
                            return true;
                        }
                        if (GemFireXDUtils.TraceDBSynchronizer) {
                            SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("WanProcedures::GfxdWanBULKDMLOptimizedFilter:enqueueEvent: Returning true for PK based event due to auto-generated columns: " + Arrays.toString(gfc.getExtraTableInfo().getAutoGeneratedColumns())));
                        }
                        return true;
                    }
                    if (GemFireXDUtils.TraceDBSynchronizer) {
                        SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)"WanProcedures::GfxdWanBULKDMLOptimizedFilter:enqueueEvent: Returning false");
                    }
                } else {
                    if (cb == null || cb instanceof Integer) {
                        if (GemFireXDUtils.TraceDBSynchronizer) {
                            SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)"WanProcedures::GfxdWanBULKDMLOptimizedFilter:enqueueEvent: Returning false as it is not a PK based event nor bulk DML");
                        }
                        return false;
                    }
                    throw new InternalGemFireError("Unexpected callback argument type. callbackArg=" + cb + "; type=" + cb.getClass().getName());
                }
            }
            return false;
        }

        @Override
        boolean enqueuePart2(GatewayQueueEvent<?, ?> event) {
            return true;
        }
    }

    public static final class BULKDMLOptimizedDBSynchronizerFilter
    extends GfxdWanBULKDMLOptimizedFilter {
        private static final GatewayEventFilter filter = new BULKDMLOptimizedDBSynchronizerFilter();

        @Override
        public boolean beforeEnqueue(GatewayQueueEvent event) {
            Object rawCallbackArg;
            if (GemFireXDUtils.TraceDBSynchronizer) {
                SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)"WanProcedures::BULKDMLOptimizedDBSynchronizerFilter:enqueueEvent: Into the beforeEnqueue");
            }
            if (event instanceof EntryEventImpl && (rawCallbackArg = ((EntryEventImpl)event).getRawCallbackArgument()) instanceof GatewaySenderEventCallbackArgument) {
                int origDSId = ((GatewaySenderEventCallbackArgument)rawCallbackArg).getOriginatingDSId();
                int thisDSId = Misc.getDistributedSystem().getDM().getDistributedSystemId();
                if (origDSId >= 0 && thisDSId >= 0 && origDSId != thisDSId) {
                    if (GemFireXDUtils.TraceDBSynchronizer) {
                        SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("WanProcedures::BULKDMLOptimizedDBSynchronizerFilter:enqueueEvent: Returning true for event from other WAN site with DSID[" + origDSId + "]. My DSID is [" + thisDSId + "]"));
                    }
                    return true;
                }
            }
            if (super.beforeEnqueue(event)) {
                Object cb = event.getCallbackArgument();
                if (cb instanceof GfxdCallbackArgument && ((GfxdCallbackArgument)cb).isCacheLoaded()) {
                    if (GemFireXDUtils.TraceDBSynchronizer) {
                        SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)"WanProcedures::BULKDMLOptimizedDBSynchronizerFilter:enqueueEvent: Returning false as even when it is PK based, it is inserted via cache loading during get");
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        boolean enqueuePart2(GatewayQueueEvent<?, ?> event) {
            Object callbackArg = event.getCallbackArgument();
            if (callbackArg != null && callbackArg instanceof GfxdCallbackArgument) {
                return !((GfxdCallbackArgument)callbackArg).isSkipListeners();
            }
            return true;
        }
    }

    public static class ParallelWanFilter
    extends AsyncEventFilter {
        private static final GatewayEventFilter filter = new ParallelWanFilter();

        @Override
        public boolean beforeEnqueue(GatewayQueueEvent event) {
            Operation op = event.getOperation();
            if (op == Operation.BULK_DML_OP) {
                throw new GemFireXDRuntimeException("For ParallelWAN, BULKDML ops should not have come to the filter.");
            }
            if (super.beforeEnqueue(event)) {
                Object cb = event.getCallbackArgument();
                if (cb instanceof GfxdCallbackArgument) {
                    GfxdCallbackArgument ecb = (GfxdCallbackArgument)cb;
                    if (ecb.isTransactional()) {
                        if (GemFireXDUtils.TraceDBSynchronizer) {
                            SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)"WanProcedures::ParallelWanFilter:enqueueEvent: Returning true as even when it is PK based, because it is transactional or inserted via cache loading during get");
                        }
                        return true;
                    }
                    if (ecb.isPkBased()) {
                        GemFireContainer gfc = (GemFireContainer)event.getRegion().getUserAttribute();
                        if (!((InternalDeltaEvent)event).isGFXDCreate(false) || !gfc.getExtraTableInfo().hasAutoGeneratedColumns()) {
                            if (GemFireXDUtils.TraceDBSynchronizer) {
                                SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)"WanProcedures::ParallelWanFilter:enqueueEvent: Returning true for PK based event");
                            }
                            return true;
                        }
                        if (GemFireXDUtils.TraceDBSynchronizer) {
                            SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("WanProcedures::ParallelWanFilter:enqueueEvent: Returning true for PK based event due to auto-generated columns: " + Arrays.toString(gfc.getExtraTableInfo().getAutoGeneratedColumns())));
                        }
                        return true;
                    }
                    if (GemFireXDUtils.TraceDBSynchronizer) {
                        SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)"WanProcedures::GfxdParallelWanFilter:enqueueEvent: Returning true");
                    }
                    return true;
                }
                if (cb == null || cb instanceof Integer) {
                    if (GemFireXDUtils.TraceDBSynchronizer) {
                        SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)"WanProcedures::ParallelWanFilter:enqueueEvent: Returning false as it is not a PK based event nor bulk DML");
                    }
                    return false;
                }
                throw new InternalGemFireError("Unexpected callback argument type. callbackArg=" + cb + "; type=" + cb.getClass().getName());
            }
            return false;
        }

        @Override
        boolean enqueuePart2(GatewayQueueEvent<?, ?> event) {
            return true;
        }
    }

    public static class SerialWanFilter
    extends GatewayEventEnqueueFilter {
        private static final GatewayEventFilter filter = new SerialWanFilter();

        public static void logMessage(String message) {
            if (GemFireXDUtils.TraceDBSynchronizer) {
                SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("WanProcedures::SerialWanFilter:enqueueEvent: " + message));
            }
        }

        public boolean beforeEnqueue(GatewayQueueEvent event) {
            Operation op;
            SerialWanFilter.logMessage("beforeEnqueue");
            GemFireContainer container = (GemFireContainer)event.getRegion().getUserAttribute();
            Object cbArg = event.getCallbackArgument();
            GfxdCallbackArgument cb = null;
            if (cbArg != null && cbArg instanceof GfxdCallbackArgument) {
                cb = (GfxdCallbackArgument)cbArg;
            }
            if ((op = event.getOperation()) == Operation.BULK_DML_OP) {
                SerialWanFilter.logMessage("Returning false for bulk DML op since in WAN only events are sent across.");
                return false;
            }
            if (cb != null && cb.isCacheLoaded()) {
                SerialWanFilter.logMessage("Returning false for cache loaded event");
                return false;
            }
            if (container.isTemporaryContainer() || container.isSYSTABLES()) {
                SerialWanFilter.logMessage("Returning false for temporary/SYS tables");
                return false;
            }
            return true;
        }
    }

    public static final class SerialDBSynchronizerFilter
    extends GatewayEventEnqueueFilter {
        private static final GatewayEventFilter filter = new SerialDBSynchronizerFilter();

        public static void logMessage(String message) {
            if (GemFireXDUtils.TraceDBSynchronizer) {
                SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("WanProcedures::SerialDBSynchronizerFilter:enqueueEvent: " + message));
            }
        }

        private static boolean isEventFromRemoteSite(GatewayQueueEvent event) {
            if (event instanceof EntryEventImpl) {
                Object rawCallbackArg = ((EntryEventImpl)event).getRawCallbackArgument();
                int origDSId = -1;
                int thisDSId = -1;
                if (rawCallbackArg != null && rawCallbackArg instanceof GatewaySenderEventCallbackArgument) {
                    origDSId = ((GatewaySenderEventCallbackArgument)rawCallbackArg).getOriginatingDSId();
                    thisDSId = InternalDistributedSystem.getAnyInstance().getDistributionManager().getDistributedSystemId();
                    if (origDSId >= 0 && thisDSId >= 0 && origDSId != thisDSId) {
                        SerialDBSynchronizerFilter.logMessage("DSID[" + origDSId + "]. My DSID is [" + thisDSId + "]");
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean beforeEnqueue(GatewayQueueEvent event) {
            SerialDBSynchronizerFilter.logMessage("beforeEnqueue");
            GemFireContainer container = (GemFireContainer)event.getRegion().getUserAttribute();
            Object cbArg = event.getCallbackArgument();
            GfxdCallbackArgument cb = null;
            if (cbArg != null && cbArg instanceof GfxdCallbackArgument) {
                cb = (GfxdCallbackArgument)cbArg;
            }
            if (cb != null && cb.isSkipListeners()) {
                SerialDBSynchronizerFilter.logMessage("Return false because skipListeners is true");
                return false;
            }
            if (cb != null && cb.isCacheLoaded()) {
                SerialDBSynchronizerFilter.logMessage("Returning false for cache loaded event");
                return false;
            }
            if (container.isTemporaryContainer() || container.isSYSTABLES()) {
                SerialDBSynchronizerFilter.logMessage("Returning false for temporary/SYS tables");
                return false;
            }
            if (SerialDBSynchronizerFilter.isEventFromRemoteSite(event)) {
                SerialDBSynchronizerFilter.logMessage("Returning true for event from other WAN site");
                return true;
            }
            Operation op = event.getOperation();
            boolean isInsert = ((InternalDeltaEvent)event).isGFXDCreate(false);
            boolean autogen = container.getExtraTableInfo().hasAutoGeneratedColumns();
            SerialDBSynchronizerFilter.logMessage("op=" + op + ",isInsert=" + isInsert + ",autogen=" + autogen);
            if (autogen) {
                if (op == Operation.BULK_DML_OP) {
                    SerialDBSynchronizerFilter.logMessage("Returning false for bulk DML op because table has autogen columns");
                    return false;
                }
                SerialDBSynchronizerFilter.logMessage("Returning true for non-bulk DML op because table has autogen columns");
                return true;
            }
            if (op == Operation.BULK_DML_OP) {
                SerialDBSynchronizerFilter.logMessage("Returning true for bulk DML op");
                return true;
            }
            if (cb.isPkBased()) {
                SerialDBSynchronizerFilter.logMessage("Returning true for PK based op");
                return true;
            }
            SerialDBSynchronizerFilter.logMessage("Returning false for all other cases");
            return false;
        }
    }

    public static class AsyncEventFilter
    extends GatewayEventEnqueueFilter {
        private static final GatewayEventFilter filter = new AsyncEventFilter();

        public boolean beforeEnqueue(GatewayQueueEvent event) {
            GemFireContainer gc;
            if (GemFireXDUtils.TraceDBSynchronizer) {
                SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("WanProcedures::AsyncEventFilter:enqueueEvent: Event received for enqueuing: " + event));
            }
            if ((gc = (GemFireContainer)event.getRegion().getUserAttribute()).isTemporaryContainer() || gc.isSYSTABLES()) {
                if (GemFireXDUtils.TraceDBSynchronizer) {
                    SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)"WanProcedures::AsyncEventFilter:enqueueEvent: Returning false for temporary/SYS tables");
                }
                return false;
            }
            if (event.getOperation() == Operation.BULK_DML_OP) {
                boolean isTX;
                Object cbArg = event.getCallbackArgument();
                boolean bl = isTX = cbArg != null && cbArg instanceof GfxdCBArgForSynchPrms && ((GfxdCBArgForSynchPrms)cbArg).isTransactional();
                if (GemFireXDUtils.TraceDBSynchronizer) {
                    SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("WanProcedures::AsyncEventFilter:enqueueEvent: Returning " + isTX + " for BULK_DML_OP isTX=" + isTX));
                }
                return isTX;
            }
            boolean val = this.enqueuePart2(event);
            if (GemFireXDUtils.TraceDBSynchronizer) {
                SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("WanProcedures::AsyncEventFilter:enqueueEvent: Returning enqueuePart2 " + val));
            }
            return val;
        }

        boolean enqueuePart2(GatewayQueueEvent<?, ?> event) {
            Object callbackArg = event.getCallbackArgument();
            if (callbackArg != null && callbackArg instanceof GfxdCallbackArgument) {
                return !((GfxdCallbackArgument)callbackArg).isSkipListeners();
            }
            return true;
        }
    }
}

