/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl.resolver;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RegionEntryUtils;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BetweenOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UserTypeConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNodeList;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import com.pivotal.gemfirexd.internal.shared.common.SingleHopInformation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class GfxdRangePartitionResolver
extends GfxdPartitionResolver {
    private String columnName;
    private final ValueNodeList ranges;
    protected final SortedMap<Object, Object[]> rangeMap;
    private int pkIndexInGemFireKey = -1;
    private int colIndexInVal = -1;
    private ColumnReference colRef;
    private volatile String ddlString;

    public GfxdRangePartitionResolver(ColumnReference columnRef, ValueNodeList ranges) {
        this.columnName = columnRef.getSQLColumnName();
        this.ranges = ranges;
        this.rangeMap = new TreeMap<Object, Object[]>((Comparator<Object>)new ResolverUtils.GfxdRangeComparator("PARTITION BY RANGE (" + this.columnName + ')'));
        this.colRef = columnRef;
    }

    public GfxdRangePartitionResolver(String columnName, List<ResolverUtils.GfxdRange> ranges) throws StandardException {
        if (columnName == null || ranges == null) {
            throw StandardException.newException("39004", (Object)"PARTITION BY RANGE", (Object)"NULL COLUMN NAME OR RANGES");
        }
        String command = "PARTITION BY RANGE (" + columnName + ')';
        this.ranges = null;
        this.rangeMap = new TreeMap<Object, Object[]>((Comparator<Object>)new ResolverUtils.GfxdRangeComparator(command));
        int partitionNum = 1;
        for (ResolverUtils.GfxdRange range : ranges) {
            if (range == null) continue;
            range.setCommand(command);
            Object[] valarray = new Object[]{range, partitionNum};
            this.rangeMap.put(range, valarray);
            ++partitionNum;
        }
    }

    private GfxdRangePartitionResolver(ValueNodeList ranges, SortedMap<Object, Object[]> rangeMap) {
        this.ranges = null;
        this.rangeMap = rangeMap;
    }

    @Override
    public boolean isUsedInPartitioning(String columnToCheck) {
        return this.columnName.equals(columnToCheck);
    }

    @Override
    public int getPartitioningColumnIndex(String partitionColumn) {
        if (partitionColumn.equals(this.columnName)) {
            return 0;
        }
        return -1;
    }

    @Override
    public String[] getColumnNames() {
        return this.partitionColumnNames;
    }

    public String getName() {
        return "gfxd-range-partition-resolver";
    }

    public Properties getConfig() {
        Properties props = new Properties();
        props.setProperty("RANGES", this.toString());
        return props;
    }

    @Override
    public void bindExpression(FromList fromList, SubqueryList subqueryList, Vector<?> aggregateVector) throws StandardException {
        if (this.columnName == null) {
            throw StandardException.newException("39004", (Object)"PARTITION BY RANGE", (Object)"NULL COLUMN NAME");
        }
        this.ranges.bindExpression(fromList, subqueryList, aggregateVector);
        this.ranges.accept(new GfxdRangeListVisitor("PARTITION BY RANGE (" + this.columnName + ')'));
    }

    @Override
    public void setColumnInfo(TableDescriptor td, Activation activation) throws StandardException {
        if (td == null) {
            throw new AssertionError((Object)"GfxdRangePartitionResolver: td cannot be null");
        }
        DistributionDescriptor distDescp = td.getDistributionDescriptor();
        if (distDescp == null) {
            throw new AssertionError((Object)"GfxdRangePartitionResolver: distributionDescriptor cannot be null");
        }
        String[] partitionColNames = td.getDistributionDescriptor().getPartitionColumnNames();
        assert (partitionColNames != null);
        assert (partitionColNames.length == 1);
        assert (partitionColNames[0].equals(this.columnName));
        Map<String, Integer> pkMap = GemFireXDUtils.getPrimaryKeyColumnNamesToIndexMap(td, activation.getLanguageConnectionContext());
        Integer partitioningColIdxInPKey = null;
        if (pkMap == null || (partitioningColIdxInPKey = pkMap.get(this.columnName)) == null) {
            this.setColumnIndexForNonPrimaryColumn(td);
            if (pkMap != null) {
                this.globalIndexContainer = GfxdPartitionResolver.getContainerOfGlobalIndex(td, pkMap);
                this.setGlobalIndexCaching(this.globalIndexContainer);
            }
        } else {
            this.pkIndexInGemFireKey = GfxdRangePartitionResolver.getIndexInPrimaryKey(pkMap, partitioningColIdxInPKey);
            if (pkMap.containsKey(this.columnName) && pkMap.size() == 1) {
                this.isPrimaryKeyPartitioningKey = true;
            }
            this.colIndexInVal = partitioningColIdxInPKey - 1;
        }
        this.partitionColumnNames = new String[]{this.columnName};
    }

    private void setColumnIndexForNonPrimaryColumn(TableDescriptor td) throws StandardException {
        HashMap<String, Integer> colNameToIdxMap = GemFireXDUtils.getColumnNamesToIndexMap(td, false);
        if (colNameToIdxMap == null) {
            return;
        }
        Integer thisColIdx = colNameToIdxMap.get(this.columnName);
        if (thisColIdx != null) {
            this.colIndexInVal = thisColIdx;
            --this.colIndexInVal;
        }
    }

    @Override
    protected final boolean isPartitioningSubsetOfKey() {
        return this.pkIndexInGemFireKey != -1;
    }

    @Override
    public Object getRoutingObject(Object key, Object val, Region<?, ?> region) {
        Object routingObject;
        RegionKey gfkey = null;
        if (key instanceof RegionKey) {
            gfkey = (RegionKey)key;
        }
        if (this.pkIndexInGemFireKey != -1) {
            routingObject = this.getRoutingObjectForValue(gfkey.getKeyColumn(this.pkIndexInGemFireKey));
        } else if (val != null && !(val instanceof GemFireContainer.SerializableDelta)) {
            assert (this.colIndexInVal != -1) : "unexpected colIndexInVal=-1 with val " + val;
            DataValueDescriptor idxObj = RegionEntryUtils.getDVDFromValue(val, this.colIndexInVal + 1, this.gfContainer);
            routingObject = this.getRoutingObjectForValue(idxObj);
        } else {
            assert (this.globalIndexContainer != null && gfkey != null) : "expected to find global index in resolver " + this.toString();
            LocalRegion globalIndex = this.globalIndexContainer.getRegion();
            boolean queryHDFS = false;
            if (region instanceof PartitionedRegion) {
                queryHDFS = ((PartitionedRegion)region).includeHDFSResults();
            }
            if (globalIndex instanceof PartitionedRegion) {
                ((PartitionedRegion)globalIndex).setQueryHDFS(queryHDFS);
            }
            routingObject = GfxdRangePartitionResolver.getRoutingObjectFromGlobalIndex(this.globalIndexContainer, gfkey);
        }
        if (this.globalIndexContainer != null) {
            this.updateGlobalIndexCache(gfkey, routingObject);
        }
        return routingObject;
    }

    private Serializable getRoutingObjectForValue(DataValueDescriptor key) {
        Object[] routingKey = (Object[])this.rangeMap.get(new ResolverUtils.GfxdComparableFuzzy((Comparable)((Object)key), 0));
        if (routingKey != null && routingKey[1] != null) {
            return (Integer)routingKey[1];
        }
        return Integer.valueOf(key.hashCode());
    }

    @Override
    public Object getRoutingKeyForColumn(DataValueDescriptor key) {
        return this.getRoutingObjectForValue(key);
    }

    @Override
    public Object[] getRoutingObjectsForRange(DataValueDescriptor lowerBound, boolean lowerBoundInclusive, DataValueDescriptor upperBound, boolean upperBoundInclusive) {
        ArrayList<Integer> routingObjects;
        ResolverUtils.GfxdRange lastRangeOfSubMap;
        ResolverUtils.GfxdComparableFuzzy lowerBndGfxd = null;
        ResolverUtils.GfxdComparableFuzzy upperBndGfxd = null;
        Comparable lowerComp = (Comparable)((Object)lowerBound);
        Comparable upperComp = (Comparable)((Object)upperBound);
        boolean firstRangeObjectToBeRemoved = false;
        if (lowerComp == null) {
            lowerBoundInclusive = false;
            if (upperComp == null) {
                return null;
            }
            lowerBndGfxd = new ResolverUtils.GfxdComparableFuzzy(lowerComp, 1);
            upperBndGfxd = new ResolverUtils.GfxdComparableFuzzy(upperComp, upperBoundInclusive ? 0 : -1);
        } else if (upperBound == null) {
            lowerBndGfxd = new ResolverUtils.GfxdComparableFuzzy(lowerComp, lowerBoundInclusive ? 0 : 1);
            upperBndGfxd = new ResolverUtils.GfxdComparableFuzzy(upperComp, -1);
        } else {
            lowerBndGfxd = new ResolverUtils.GfxdComparableFuzzy(lowerComp, lowerBoundInclusive ? 0 : 1);
            upperBndGfxd = new ResolverUtils.GfxdComparableFuzzy(upperComp, upperBoundInclusive ? 0 : -1);
        }
        SortedMap<Object, Object[]> subMap = this.rangeMap.subMap(lowerBndGfxd, upperBndGfxd);
        if (subMap.isEmpty()) {
            return this.checkAndreturnRoutingObjects(lowerBndGfxd, upperBndGfxd);
        }
        Object[] elements = subMap.keySet().toArray();
        ResolverUtils.GfxdRange firstRangeEntry = (ResolverUtils.GfxdRange)elements[0];
        if (firstRangeEntry.inRange(lowerBndGfxd) > 0 && !((ResolverUtils.GfxdComparableFuzzy)firstRangeEntry.rangeStart()).getWrappedObject().equals(lowerBound)) {
            return null;
        }
        if (!lowerBoundInclusive && lowerBound != null) {
            firstRangeObjectToBeRemoved = this.checkIfFirstRangeObjectToBeRemoved(firstRangeEntry, lowerBndGfxd);
        }
        if ((lastRangeOfSubMap = this.isSubMapContinuous(subMap, firstRangeObjectToBeRemoved, routingObjects = new ArrayList<Integer>())) == null) {
            return null;
        }
        Object[] upperBoundValue = null;
        upperBoundValue = (Object[])this.rangeMap.get(upperBndGfxd);
        if (upperBoundValue == null) {
            return null;
        }
        ResolverUtils.GfxdRange upperBoundRange = (ResolverUtils.GfxdRange)upperBoundValue[0];
        Integer upperBoundRoutingValue = (Integer)upperBoundValue[1];
        boolean checkContinuity = true;
        if (!upperBoundInclusive && lastRangeOfSubMap.getEnd().getWrappedObject().equals(upperBound)) {
            checkContinuity = false;
        }
        if (checkContinuity) {
            if (!this.isContinuous(lastRangeOfSubMap, upperBoundRange)) {
                return null;
            }
            routingObjects.add(upperBoundRoutingValue);
        }
        if (routingObjects.size() == 0) {
            return null;
        }
        return routingObjects.toArray();
    }

    @Override
    public Object[] getRoutingObjectsForList(DataValueDescriptor[] keys) throws ClassCastException {
        Object[] routingObjects = new Object[keys.length];
        for (int index = 0; index < keys.length; ++index) {
            routingObjects[index] = this.getRoutingObjectForValue(keys[index]);
        }
        return routingObjects;
    }

    private Object[] checkAndreturnRoutingObjects(ResolverUtils.GfxdComparableFuzzy lowerBndGfxd, ResolverUtils.GfxdComparableFuzzy upperBndGfxd) {
        Object[] val1 = (Object[])this.rangeMap.get(lowerBndGfxd);
        Object[] val2 = (Object[])this.rangeMap.get(upperBndGfxd);
        if (val1 == null || val2 == null) {
            return null;
        }
        if (val1[1] != val2[1]) {
            return null;
        }
        Object[] ret = new Object[]{val1[1]};
        return ret;
    }

    private ResolverUtils.GfxdRange isSubMapContinuous(SortedMap<Object, Object[]> submap, boolean firstRangeObjectToBeRemoved, List<Integer> routingObjects) {
        ResolverUtils.GfxdRange prevKey = null;
        ResolverUtils.GfxdRange lastRange = null;
        for (Object[] tmpval : submap.values()) {
            ResolverUtils.GfxdRange thisKey;
            lastRange = thisKey = (ResolverUtils.GfxdRange)tmpval[0];
            Integer thisval = (Integer)tmpval[1];
            if (prevKey == null) {
                prevKey = thisKey;
                if (firstRangeObjectToBeRemoved) continue;
                routingObjects.add(thisval);
                continue;
            }
            if (!this.isContinuous(prevKey, thisKey)) {
                routingObjects = null;
                return null;
            }
            routingObjects.add(thisval);
            prevKey = thisKey;
        }
        return lastRange;
    }

    private boolean checkIfFirstRangeObjectToBeRemoved(ResolverUtils.GfxdRange firstEntry, ResolverUtils.GfxdComparableFuzzy lowerBound) {
        Comparable rhs;
        Comparable lhs = (Comparable)((ResolverUtils.GfxdComparableFuzzy)firstEntry.rangeEnd()).getWrappedObject();
        return lhs.compareTo(rhs = (Comparable)lowerBound.getWrappedObject()) == 0;
    }

    private boolean isContinuous(ResolverUtils.GfxdRange previous, ResolverUtils.GfxdRange current) {
        Object currObject;
        Object prevObject = ((ResolverUtils.GfxdComparableFuzzy)previous.rangeEnd()).getWrappedObject();
        return prevObject.equals(currObject = ((ResolverUtils.GfxdComparableFuzzy)current.rangeStart()).getWrappedObject());
    }

    public String toString() {
        return "GfxdRangePartitionResolver(" + this.getQualifiedTableName() + "): " + this.rangeMap.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDDLString() {
        if (this.ddlString == null) {
            GfxdRangePartitionResolver gfxdRangePartitionResolver = this;
            synchronized (gfxdRangePartitionResolver) {
                if (this.ddlString == null) {
                    StringBuilder sb = new StringBuilder("PARTITION BY RANGE (").append(this.columnName).append(") (");
                    for (Object o : this.rangeMap.keySet()) {
                        ResolverUtils.GfxdRange range = (ResolverUtils.GfxdRange)o;
                        range.getDDLString(sb);
                        sb.append(',');
                    }
                    sb.setCharAt(sb.length() - 1, ')');
                    this.ddlString = sb.toString();
                }
            }
        }
        return this.ddlString;
    }

    @Override
    public Serializable getRoutingObjectFromDvdArray(DataValueDescriptor[] values) {
        if (this.colIndexInVal != -1) {
            if (values == null) {
                throw new IllegalArgumentException("GfxdRangePartitionResolver: Passed in dvd array is null");
            }
            assert (values.length > this.colIndexInVal) : "GfxdRangePartitionResolver#getRoutingObjectFromDvdArray: Incomplete row passed as values";
            return this.getRoutingObjectForValue(values[this.colIndexInVal]);
        }
        throw new IllegalStateException("GfxdRangePartitionResolver: The state of this resolver is unexpected");
    }

    @Override
    public Object getRoutingObjectsForPartitioningColumns(DataValueDescriptor[] partitioningColumnObjects) {
        if (partitioningColumnObjects.length != 1) {
            throw new IllegalArgumentException("GfxdRangePartitionResolver.getRoutingObjectsForPartitioningColumns: range partitioning is done only on single column");
        }
        Serializable routingObject = null;
        routingObject = this.getRoutingObjectForValue(partitioningColumnObjects[0]);
        if (routingObject == null) {
            routingObject = Integer.valueOf(partitioningColumnObjects[0].hashCode());
        }
        return routingObject;
    }

    @Override
    public boolean requiresGlobalIndex() {
        return this.pkIndexInGemFireKey < 0;
    }

    @Override
    public GfxdPartitionResolver cloneObject() {
        GfxdRangePartitionResolver newRslvr = new GfxdRangePartitionResolver(this.ranges, this.rangeMap);
        newRslvr.columnName = this.columnName;
        return newRslvr;
    }

    @Override
    public void setPartitionColumns(String[] partCols, String[] refPartCols) {
        assert (partCols.length == 1) : "Range partitioning is valid for single column only";
        this.columnName = partCols[0];
    }

    @Override
    public boolean okForColocation(GfxdPartitionResolver rslvr) {
        if (rslvr instanceof GfxdRangePartitionResolver) {
            SortedMap<Object, Object[]> rangeMapOfThePassedRslvr = ((GfxdRangePartitionResolver)rslvr).rangeMap;
            if (this.rangeMap.size() != rangeMapOfThePassedRslvr.size()) {
                return false;
            }
            Iterator<Object> itr1 = this.rangeMap.keySet().iterator();
            Iterator<Object> itr2 = rangeMapOfThePassedRslvr.keySet().iterator();
            while (itr1.hasNext() && itr2.hasNext()) {
                Object[] val2_end;
                Object[] val2;
                ResolverUtils.GfxdRange key1 = (ResolverUtils.GfxdRange)itr1.next();
                ResolverUtils.GfxdRange key2 = (ResolverUtils.GfxdRange)itr2.next();
                if (key1.rangeStart().compareTo(key2.rangeStart()) != 0) {
                    return false;
                }
                if (key1.rangeEnd().compareTo(key2.rangeEnd()) != 0) {
                    return false;
                }
                Object[] val1 = (Object[])this.rangeMap.get(key1.rangeStart());
                if (!val1[1].equals((val2 = (Object[])rangeMapOfThePassedRslvr.get(key2.rangeStart()))[1])) {
                    return false;
                }
                Object[] val1_end = (Object[])this.rangeMap.get(key1.rangeEnd());
                if (val1_end[1].equals((val2_end = (Object[])rangeMapOfThePassedRslvr.get(key2.rangeEnd()))[1])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private int getTypeFormatIdFromRangeObject(ResolverUtils.GfxdRange range) {
        assert (range != null);
        ResolverUtils.GfxdComparableFuzzy boundary = null;
        Comparable start = range.rangeStart();
        if (start != null) {
            boundary = (ResolverUtils.GfxdComparableFuzzy)start;
        } else {
            Comparable end = range.rangeEnd();
            boundary = (ResolverUtils.GfxdComparableFuzzy)end;
        }
        assert (boundary != null);
        DataValueDescriptor dvd = (DataValueDescriptor)boundary.getWrappedObject();
        return dvd.getTypeFormatId();
    }

    @Override
    public void setResolverInfoInSingleHopInfoObject(SingleHopInformation info) throws StandardException {
        assert (info != null) : "unexpected null SingleHopInformation object";
        info.setResolverType(3);
        boolean typeFormatSet = false;
        Object map = null;
        ArrayList list = null;
        for (Map.Entry<Object, Object[]> v : this.rangeMap.entrySet()) {
            Object val = v.getKey();
            assert (val instanceof ResolverUtils.GfxdRange);
            ResolverUtils.GfxdRange range = (ResolverUtils.GfxdRange)val;
            if (!typeFormatSet) {
                int typeFormatId = this.getTypeFormatIdFromRangeObject(range);
                int[] typeArray = new int[]{typeFormatId};
                if (this.isValidTypeForSingleHop(typeArray, info)) {
                    info.setTypeFormatIdArray(typeArray);
                    typeFormatSet = true;
                    list = new ArrayList();
                } else {
                    info.setResolverType(0);
                    return;
                }
            }
            Integer value = (Integer)v.getValue()[1];
            this.addRangeTolist(range, list, value);
        }
        info.setRangeValueHolderList(list);
    }

    private void addRangeTolist(ResolverUtils.GfxdRange range, ArrayList list, Integer value) throws StandardException {
        Comparable end;
        assert (range != null);
        assert (range != null);
        ResolverUtils.GfxdComparableFuzzy boundary = null;
        Object lowerBound = null;
        Object upperBound = null;
        Comparable start = range.rangeStart();
        if (start != null) {
            boundary = (ResolverUtils.GfxdComparableFuzzy)start;
            DataValueDescriptor dvd = (DataValueDescriptor)boundary.getWrappedObject();
            lowerBound = dvd.getObject();
        }
        if ((end = range.rangeEnd()) != null) {
            boundary = (ResolverUtils.GfxdComparableFuzzy)end;
            DataValueDescriptor dvd = (DataValueDescriptor)boundary.getWrappedObject();
            upperBound = dvd.getObject();
        }
        SingleHopInformation.PlainRangeValueHolder rangeHolder = new SingleHopInformation.PlainRangeValueHolder(lowerBound, upperBound, value);
        list.add(rangeHolder);
    }

    class GfxdRangeListVisitor
    extends VisitorAdaptor {
        private final String command;

        public GfxdRangeListVisitor(String command) {
            this.command = command;
        }

        @Override
        public Visitable visit(Visitable node) throws StandardException {
            if (node instanceof BetweenOperatorNode) {
                BetweenOperatorNode betweenNode = (BetweenOperatorNode)node;
                ValueNodeList rightOperands = betweenNode.getRightOperandList();
                Integer newValue = GfxdRangePartitionResolver.this.rangeMap.size() + 1;
                try {
                    ConstantNode end;
                    ConstantNode start = (ConstantNode)rightOperands.elementAt(0);
                    if (start instanceof UserTypeConstantNode && ((UserTypeConstantNode)start).isInfinityValue()) {
                        start = null;
                    }
                    if ((end = (ConstantNode)rightOperands.elementAt(1)) instanceof UserTypeConstantNode && ((UserTypeConstantNode)end).isInfinityValue()) {
                        end = null;
                    }
                    DataValueDescriptor startDVD = GfxdPartitionResolver.getDVDFromConstantNode(start, GfxdRangePartitionResolver.this.colRef);
                    DataValueDescriptor endDVD = GfxdPartitionResolver.getDVDFromConstantNode(end, GfxdRangePartitionResolver.this.colRef);
                    if (startDVD != null && endDVD != null && startDVD.compare(endDVD) >= 0) {
                        throw StandardException.newException("0A000.S", "Begin range not less than end range");
                    }
                    ResolverUtils.GfxdRange range = new ResolverUtils.GfxdRange(this.command, (Object)startDVD, (Object)endDVD);
                    Object[] valarray = new Object[]{range, (int)newValue};
                    GfxdRangePartitionResolver.this.rangeMap.put(range, valarray);
                }
                catch (ClassCastException ex) {
                    throw StandardException.newException("22003", ex, (Object)"partition by range", (Object)GfxdRangePartitionResolver.this.colRef.getColumnName());
                }
            }
            return node;
        }

        @Override
        public boolean skipChildren(Visitable node) {
            return false;
        }

        @Override
        public boolean stopTraversal() {
            return false;
        }
    }
}

