/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl.callbacks.messages;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionInvocationTargetException;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.callbacks.CallbackProcedures;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.AbstractGfxdReplayableMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.FunctionExecutionException;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

public class GfxdSetWriterMessage
extends AbstractGfxdReplayableMessage {
    private static final long serialVersionUID = -1049891865971212028L;
    private String schema;
    private String table;
    private String implementation;
    private String initInfoStr;
    private String serverGroups;
    static final String CONFLATION_KEY_PREFIX = "__GFXD_INTERNAL_GFXDWRITER.";
    protected static final short HAS_SERVER_GROUPS = 64;

    public GfxdSetWriterMessage() {
    }

    public GfxdSetWriterMessage(String schema, String table, String implementation, String initInfo, String serverGroups) {
        this.schema = schema;
        this.table = table;
        this.implementation = implementation;
        this.initInfoStr = initInfo;
        this.serverGroups = serverGroups;
    }

    @Override
    public void execute() throws StandardException {
        LogWriter logger = Misc.getGemFireCache().getLoggerI18n().convertToLogWriter();
        EmbedConnection conn = null;
        boolean contextSet = false;
        try {
            conn = GemFireXDUtils.getTSSConnection(true, true, false);
            conn.getTR().setupContextStack();
            contextSet = true;
            if (logger.infoEnabled()) {
                logger.info("GfxdSetWriterMessage: Executing with fields as: " + this.toString());
            }
            CallbackProcedures.addGfxdCacheWriterLocally(CallbackProcedures.getContainerForTable(this.schema, this.table), this.implementation, this.initInfoStr, this.serverGroups);
        }
        catch (Exception ex) {
            if (logger.fineEnabled()) {
                logger.fine("GfxdSetWriterMessage#execute: exception encountered", (Throwable)ex);
            }
            if (GemFireXDUtils.retryToBeDone(ex)) {
                throw new InternalFunctionInvocationTargetException((Throwable)ex);
            }
            throw new FunctionExecutionException(ex);
        }
        finally {
            if (contextSet) {
                block14: {
                    try {
                        conn.internalCommit();
                    }
                    catch (SQLException ex) {
                        if (!logger.fineEnabled()) break block14;
                        logger.fine("GfxdSetWriterMessage#execute: exception encountered", (Throwable)ex);
                    }
                }
                conn.getTR().restoreContextStack();
            }
        }
    }

    @Override
    public byte getGfxdID() {
        return 24;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString((String)this.schema, (DataOutput)out);
        DataSerializer.writeString((String)this.table, (DataOutput)out);
        DataSerializer.writeString((String)this.implementation, (DataOutput)out);
        DataSerializer.writeString((String)this.initInfoStr, (DataOutput)out);
        if (this.serverGroups != null) {
            DataSerializer.writeString((String)this.serverGroups, (DataOutput)out);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.schema = DataSerializer.readString((DataInput)in);
        this.table = DataSerializer.readString((DataInput)in);
        this.implementation = DataSerializer.readString((DataInput)in);
        this.initInfoStr = DataSerializer.readString((DataInput)in);
        if ((this.flags & 0x40) != 0) {
            this.serverGroups = DataSerializer.readString((DataInput)in);
        }
    }

    @Override
    protected short computeCompressedShort(short flags) {
        flags = super.computeCompressedShort(flags);
        if (this.serverGroups != null) {
            flags = (short)(flags | 0x40);
        }
        return flags;
    }

    @Override
    public void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        sb.append("; schema = ");
        sb.append(this.schema);
        sb.append("; table = ");
        sb.append(this.table);
        sb.append("; implementation = ");
        sb.append(this.implementation);
        sb.append("; initInfoStr = ");
        sb.append(this.initInfoStr);
        if (this.serverGroups != null) {
            sb.append("; serverGroups=").append(this.serverGroups);
        }
    }

    public boolean shouldBeConflated() {
        return false;
    }

    public String getRegionToConflate() {
        return this.schema + '.' + this.table;
    }

    public Object getKeyToConflate() {
        return CONFLATION_KEY_PREFIX;
    }

    public Object getValueToConflate() {
        return null;
    }

    @Override
    public String getSQLStatement() {
        StringBuilder sb = new StringBuilder();
        sb.append("CALL SYS.ATTACH_WRITER('").append(this.schema).append("','").append(this.table).append("','").append(this.implementation).append("','").append(this.initInfoStr).append("',");
        if (this.serverGroups != null) {
            sb.append('\'').append(this.serverGroups).append('\'');
        } else {
            sb.append("NULL");
        }
        return sb.append(')').toString();
    }

    @Override
    public String getSchemaName() {
        return this.schema;
    }
}

