/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl;

import com.gemstone.gemfire.DataSerializer;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class PersistIdentityStart
extends GfxdDataSerializable {
    private String schemaName;
    private String tableName;
    private String columnName;
    private long startValue;

    public PersistIdentityStart() {
    }

    public PersistIdentityStart(String schemaName, String tableName, String columnName, long startValue) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columnName = columnName;
        this.startValue = startValue;
    }

    public void checkMatchingColumn(String schemaName, String tableName, String columnName) {
        if (!(schemaName.equals(this.schemaName) && tableName.equals(this.tableName) && columnName.equals(this.columnName))) {
            SanityManager.THROWASSERT((String)("Expected table=" + schemaName + '.' + tableName + " column=" + columnName + " but got " + this.toString()));
        }
    }

    public long getStartValue() {
        return this.startValue;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString((String)this.schemaName, (DataOutput)out);
        DataSerializer.writeString((String)this.tableName, (DataOutput)out);
        DataSerializer.writeString((String)this.columnName, (DataOutput)out);
        out.writeLong(this.startValue);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.schemaName = DataSerializer.readString((DataInput)in);
        this.tableName = DataSerializer.readString((DataInput)in);
        this.columnName = DataSerializer.readString((DataInput)in);
        this.startValue = in.readLong();
    }

    @Override
    public byte getGfxdID() {
        return 9;
    }

    public String toString() {
        return "PersistIdentityStart:table=" + this.schemaName + '.' + this.tableName + ";column=" + this.columnName + ";startValue=" + this.startValue;
    }
}

